/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.processSystem.processModules;

import neqsim.processSimulation.processEquipment.compressor.Compressor;
import neqsim.processSimulation.processEquipment.distillation.Condenser;
import neqsim.processSimulation.processEquipment.distillation.DistillationColumn;
import neqsim.processSimulation.processEquipment.distillation.Reboiler;
import neqsim.processSimulation.processEquipment.expander.Expander;
import neqsim.processSimulation.processEquipment.heatExchanger.Cooler;
import neqsim.processSimulation.processEquipment.heatExchanger.HeatExchanger;
import neqsim.processSimulation.processEquipment.mixer.Mixer;
import neqsim.processSimulation.processEquipment.separator.Separator;
import neqsim.processSimulation.processEquipment.splitter.Splitter;
import neqsim.processSimulation.processEquipment.stream.Stream;
import neqsim.processSimulation.processEquipment.stream.StreamInterface;
import neqsim.processSimulation.processEquipment.util.Recycle;
import neqsim.processSimulation.processEquipment.valve.ThrottlingValve;
import neqsim.processSimulation.processSystem.ProcessModuleBaseClass;
import neqsim.processSimulation.processSystem.ProcessSystem;
import neqsim.thermo.system.SystemSrkEos;

public class DPCUModule
extends ProcessModuleBaseClass {
    private static final long serialVersionUID = 1000L;
    StreamInterface ethaneOvhComp;
    StreamInterface gasDistColumnExit;
    StreamInterface liquidDistColumnExit;
    StreamInterface feedStream;
    StreamInterface gasExitStream;
    StreamInterface oilExitStream;
    StreamInterface glycolFeedStream;
    StreamInterface glycolExitStream;
    Separator glycolScrubber;
    Separator inletSeparator;
    double inletSepTemperature = 50.0;
    double pressureAfterRedValve = 55.0;
    double gasScrubberTemperature = 30.0;
    double firstStageOutPressure = 110.0;
    double glycolScrubberTemperature = 20.0;
    double secondStageOutPressure = 200.0;
    double glycolInjectionRate = 10.0;
    double exportGasTemperature = 303.15;
    double liquidPumpPressure = 150.0;
    Separator LTseparator;
    HeatExchanger heatExchanger1;
    ThrottlingValve valve1;
    Expander expander;
    Compressor compressor1;
    Mixer mixer;
    DistillationColumn distColumn;

    @Override
    public void addInputStream(String streamName, StreamInterface stream) {
        if (streamName.equals("feed stream")) {
            this.feedStream = stream;
        }
        if (streamName.equals("glycol feed stream")) {
            this.glycolFeedStream = stream;
        }
    }

    @Override
    public StreamInterface getOutputStream(String streamName) {
        if (!this.isInitializedStreams) {
            this.initializeStreams();
        }
        if (streamName.equals("gas exit stream")) {
            return this.gasExitStream;
        }
        if (streamName.equals("oil exit stream")) {
            return this.oilExitStream;
        }
        if (streamName.equals("gas from dist column")) {
            return this.gasDistColumnExit;
        }
        if (streamName.equals("liquid from dist column")) {
            return this.liquidDistColumnExit;
        }
        return null;
    }

    @Override
    public void initializeModule() {
        this.isInitializedModule = true;
        ThrottlingValve inletValve = new ThrottlingValve("inlet valve", this.feedStream);
        inletValve.setOutletPressure(this.pressureAfterRedValve);
        this.heatExchanger1 = new HeatExchanger(inletValve.getOutStream());
        this.heatExchanger1.setName("heatExchanger1");
        Cooler heatExchanger2 = new Cooler(this.heatExchanger1.getOutStream(0));
        this.heatExchanger1.setOutTemperature(252.14999999999998);
        heatExchanger2.setName("heatExchanger2");
        this.expander = new Expander("expander", heatExchanger2.getOutStream());
        this.expander.setOutletPressure(46.0);
        this.LTseparator = new Separator("LTseparator", this.expander.getOutStream());
        Splitter splitter = new Splitter("LTsplitter", this.LTseparator.getGasOutStream(), 2);
        splitter.setSplitFactors(new double[]{0.9, 0.1});
        this.heatExchanger1.addInStream(splitter.getSplitStream(0));
        this.mixer = new Mixer("gasmixer");
        this.mixer.addStream(this.heatExchanger1.getOutStream(1));
        this.mixer.addStream(splitter.getSplitStream(1));
        this.compressor1 = new Compressor("Compressor 1", this.mixer.getOutStream());
        this.compressor1.setOutletPressure(65.0);
        Recycle recycl = new Recycle("recycler");
        recycl.addStream(this.compressor1.getOutStream());
        this.valve1 = new ThrottlingValve(this.LTseparator.getLiquidOutStream());
        this.valve1.setOutletPressure(30.0);
        this.distColumn = new DistillationColumn(10, true, true);
        this.distColumn.addFeedStream(this.valve1.getOutStream(), 2);
        ((Reboiler)this.distColumn.getReboiler()).setRefluxRatio(10.7);
        ((Condenser)this.distColumn.getCondenser()).setRefluxRatio(10.7);
        this.getOperations().add(inletValve);
        this.getOperations().add(this.heatExchanger1);
        this.getOperations().add(heatExchanger2);
        this.getOperations().add(this.expander);
        this.getOperations().add(this.LTseparator);
        this.getOperations().add(splitter);
        this.getOperations().add(this.mixer);
        this.getOperations().add(this.compressor1);
        this.getOperations().add(recycl);
        this.getOperations().add(this.valve1);
    }

    @Override
    public void run() {
        if (!this.isInitializedModule) {
            this.initializeModule();
        }
        this.getOperations().run();
        this.gasExitStream = this.compressor1.getOutStream();
        this.oilExitStream = this.LTseparator.getLiquidOutStream();
        this.gasDistColumnExit = this.distColumn.getGasOutStream();
        this.liquidDistColumnExit = this.distColumn.getLiquidOutStream();
    }

    @Override
    public void initializeStreams() {
        this.isInitializedStreams = true;
    }

    @Override
    public void runTransient(double dt) {
        this.getOperations().runTransient();
    }

    @Override
    public void calcDesign() {
    }

    @Override
    public void setDesign() {
    }

    @Override
    public void setSpecification(String specificationName, double value) {
        if (specificationName.equals("pressure after reduction valve")) {
            this.pressureAfterRedValve = value;
        } else if (specificationName.equals("gas scrubber temperature")) {
            this.gasScrubberTemperature = value;
        }
    }

    @Override
    public void displayResult() {
        System.out.println("compressor power " + this.compressor1.getEnergy());
        System.out.println("expander power " + this.expander.getEnergy());
        this.valve1.displayResult();
    }

    public static void main(String[] args) {
        SystemSrkEos testSystem = new SystemSrkEos(280.65, 110.0);
        testSystem.addComponent("CO2", 0.0218295567233988);
        testSystem.addComponent("nitrogen", 0.00739237702184805);
        testSystem.addComponent("methane", 0.831767017569769);
        testSystem.addComponent("ethane", 0.0790893243389708);
        testSystem.addComponent("propane", 0.0378546917300062);
        testSystem.addComponent("i-butane", 0.00543253464081659);
        testSystem.addComponent("n-butane", 0.0095144918510181);
        testSystem.addComponent("i-pentane", 0.00207801067169675);
        testSystem.addComponent("n-pentane", 0.00211497210679094);
        testSystem.addComponent("n-hexane", 5.12675581812218E-4);
        testSystem.addComponent("n-heptane", 2.05410042894726E-4);
        testSystem.addComponent("n-octane", 6.77697183000435E-4);
        testSystem.createDatabase(true);
        testSystem.setMixingRule(2);
        Stream feedStream = new Stream("Well stream", testSystem);
        feedStream.getThermoSystem().setTotalFlowRate(5.0, "MSm^3/hr");
        DPCUModule dpcuModule = new DPCUModule();
        dpcuModule.addInputStream("feed stream", feedStream);
        dpcuModule.setSpecification("pressure after reduction valve", 108.0);
        ProcessSystem operations = new ProcessSystem();
        operations.add(feedStream);
        operations.add(dpcuModule);
        operations.run();
        dpcuModule.getOutputStream("gas exit stream").displayResult();
        dpcuModule.getOutputStream("oil exit stream").displayResult();
        dpcuModule.getOutputStream("gas from dist column").displayResult();
        dpcuModule.getOutputStream("liquid from dist column").displayResult();
        dpcuModule.displayResult();
    }
}

