/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.processSystem.processModules;

import neqsim.processSimulation.processEquipment.separator.Separator;
import neqsim.processSimulation.processEquipment.stream.Stream;
import neqsim.processSimulation.processEquipment.stream.StreamInterface;
import neqsim.processSimulation.processSystem.ProcessModuleBaseClass;

public class CO2RemovalModule
extends ProcessModuleBaseClass {
    private static final long serialVersionUID = 1000L;
    protected StreamInterface streamToAbsorber = null;
    protected StreamInterface streamFromAbsorber = null;
    protected StreamInterface gasFromCO2Stripper = null;
    protected Separator inletSeparator = null;

    @Override
    public void addInputStream(String streamName, StreamInterface stream) {
        if (streamName.equals("streamToAbsorber")) {
            this.streamToAbsorber = stream;
        }
    }

    @Override
    public StreamInterface getOutputStream(String streamName) {
        if (!this.isInitializedStreams) {
            this.initializeStreams();
        }
        if (streamName.equals("streamFromAbsorber")) {
            return this.streamFromAbsorber;
        }
        return null;
    }

    @Override
    public void run() {
        if (!this.isInitializedModule) {
            this.initializeModule();
        }
        this.getOperations().run();
        this.streamFromAbsorber = (Stream)this.inletSeparator.getGasOutStream().clone();
        this.streamFromAbsorber.getThermoSystem().addComponent("CO2", -this.streamFromAbsorber.getThermoSystem().getPhase(0).getComponent("CO2").getNumberOfMolesInPhase() * 0.99);
        this.streamFromAbsorber.getThermoSystem().addComponent("MEG", -this.streamFromAbsorber.getThermoSystem().getPhase(0).getComponent("MEG").getNumberOfMolesInPhase() * 0.99);
        this.streamFromAbsorber.getThermoSystem().init(1);
    }

    @Override
    public void initializeStreams() {
        this.isInitializedStreams = true;
        try {
            this.streamFromAbsorber = (Stream)this.streamToAbsorber.clone();
            this.streamFromAbsorber.setName("Stream from ABsorber");
            this.gasFromCO2Stripper = (Stream)this.streamToAbsorber.clone();
            this.gasFromCO2Stripper.setName("Gas stream from Stripper");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void initializeModule() {
        this.isInitializedModule = true;
        this.inletSeparator = new Separator(this.streamToAbsorber);
        this.getOperations().add(this.inletSeparator);
    }

    @Override
    public void runTransient(double dt) {
        this.getOperations().runTransient();
    }

    @Override
    public void calcDesign() {
    }

    @Override
    public void setDesign() {
    }
}

