/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.processSystem;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import neqsim.dataPresentation.fileHandeling.createTextFile.TextFile;
import neqsim.processSimulation.conditionMonitor.ConditionMonitor;
import neqsim.processSimulation.costEstimation.CostEstimateBaseClass;
import neqsim.processSimulation.measurementDevice.MeasurementDeviceInterface;
import neqsim.processSimulation.mechanicalDesign.SystemMechanicalDesign;
import neqsim.processSimulation.processEquipment.ProcessEquipmentBaseClass;
import neqsim.processSimulation.processEquipment.ProcessEquipmentInterface;
import neqsim.processSimulation.processEquipment.compressor.Compressor;
import neqsim.processSimulation.processEquipment.heatExchanger.Cooler;
import neqsim.processSimulation.processEquipment.heatExchanger.Heater;
import neqsim.processSimulation.processEquipment.pump.Pump;
import neqsim.processSimulation.processEquipment.util.Adjuster;
import neqsim.processSimulation.processEquipment.util.Recycle;
import neqsim.processSimulation.processEquipment.util.RecycleController;
import neqsim.processSimulation.processSystem.ModuleInterface;
import neqsim.thermo.system.SystemInterface;
import org.apache.commons.lang.SerializationUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProcessSystem
implements Serializable,
Runnable {
    private static final long serialVersionUID = 1000L;
    Thread thisThread;
    String[][] signalDB = new String[100][100];
    private double time = 0.0;
    private double surroundingTemperature = 288.15;
    private int timeStepNumber = 0;
    private ArrayList<ProcessEquipmentInterface> unitOperations = new ArrayList(0);
    ArrayList<MeasurementDeviceInterface> measurementDevices = new ArrayList(0);
    RecycleController recycleController = new RecycleController();
    private double timeStep = 1.0;
    private String name = "process name";
    private SystemMechanicalDesign systemMechanicalDesign = new SystemMechanicalDesign(this);
    private CostEstimateBaseClass costEstimator = new CostEstimateBaseClass(this);
    static Logger logger = LogManager.getLogger(ProcessSystem.class);

    public void add(ProcessEquipmentInterface operation) {
        ArrayList<ProcessEquipmentInterface> units = this.getUnitOperations();
        for (ProcessEquipmentInterface unit : units) {
            if (unit != operation) continue;
            return;
        }
        if (this.getAllUnitNames().contains(operation.getName())) {
            String currClass = operation.getClass().getSimpleName();
            int num = 1;
            for (ProcessEquipmentInterface unit : units) {
                if (!unit.getClass().getSimpleName().equals(currClass)) continue;
                ++num;
            }
            operation.setName(String.valueOf(currClass) + Integer.toString(num));
        }
        this.getUnitOperations().add(operation);
        if (operation instanceof ModuleInterface) {
            ((ModuleInterface)operation).initializeModule();
        }
    }

    public void add(MeasurementDeviceInterface measurementDevice) {
        this.measurementDevices.add(measurementDevice);
    }

    public void add(ProcessEquipmentInterface[] operations) {
        this.getUnitOperations().addAll(Arrays.asList(operations));
    }

    public Object getUnit(String name) {
        int i = 0;
        while (i < this.getUnitOperations().size()) {
            if (this.getUnitOperations().get(i) instanceof ModuleInterface) {
                int j = 0;
                while (j < ((ModuleInterface)this.getUnitOperations().get(i)).getOperations().getUnitOperations().size()) {
                    if (((ModuleInterface)this.getUnitOperations().get(i)).getOperations().getUnitOperations().get(j).getName().equals(name)) {
                        return ((ModuleInterface)this.getUnitOperations().get(i)).getOperations().getUnitOperations().get(j);
                    }
                    ++j;
                }
            } else if (this.getUnitOperations().get(i).getName().equals(name)) {
                return this.getUnitOperations().get(i);
            }
            ++i;
        }
        return null;
    }

    public boolean hasUnitName(String name) {
        return this.getUnit(name) != null;
    }

    public Object getMeasurementDevice(String name) {
        int i = 0;
        while (i < this.measurementDevices.size()) {
            if (this.measurementDevices.get(i).getName().equals(name)) {
                return this.measurementDevices.get(i);
            }
            ++i;
        }
        return null;
    }

    public int getUnitNumber(String name) {
        int i = 0;
        while (i < this.getUnitOperations().size()) {
            if (this.getUnitOperations().get(i) instanceof ModuleInterface) {
                int j = 0;
                while (j < ((ModuleInterface)this.getUnitOperations().get(i)).getOperations().getUnitOperations().size()) {
                    if (((ModuleInterface)this.getUnitOperations().get(i)).getOperations().getUnitOperations().get(j).getName().equals(name)) {
                        return j;
                    }
                    ++j;
                }
            } else if (this.getUnitOperations().get(i).getName().equals(name)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public void replaceObject(String unitName, ProcessEquipmentBaseClass operation) {
        this.unitOperations.set(this.getUnitNumber(this.name), operation);
    }

    public ArrayList<String> getAllUnitNames() {
        ArrayList<String> unitNames = new ArrayList<String>();
        int i = 0;
        while (i < this.getUnitOperations().size()) {
            if (this.getUnitOperations().get(i) instanceof ModuleInterface) {
                int j = 0;
                while (j < ((ModuleInterface)this.getUnitOperations().get(i)).getOperations().getUnitOperations().size()) {
                    unitNames.add(((ModuleInterface)this.getUnitOperations().get(i)).getOperations().getUnitOperations().get(j).getName());
                    ++j;
                }
            }
            unitNames.add(this.unitOperations.get(i).getName());
            ++i;
        }
        return unitNames;
    }

    public ArrayList<ProcessEquipmentInterface> getUnitOperations() {
        return this.unitOperations;
    }

    public void removeUnit(String name) {
        int i = 0;
        while (i < this.unitOperations.size()) {
            if (this.unitOperations.get(i).getName().equals(name)) {
                this.unitOperations.remove(i);
            }
            ++i;
        }
    }

    public void clearAll() {
        this.unitOperations = new ArrayList(0);
    }

    public void clear() {
        this.unitOperations = new ArrayList(0);
    }

    public void setFluid(SystemInterface fluid1, SystemInterface fluid2, boolean addNewComponents) {
        fluid1.setEmptyFluid();
        boolean addedComps = false;
        int i = 0;
        while (i < fluid2.getNumberOfComponents()) {
            if (fluid1.getPhase(0).hasComponent(fluid2.getComponent(i).getName())) {
                fluid1.addComponent(fluid2.getComponent(i).getName(), fluid2.getComponent(i).getNumberOfmoles());
            } else if (addNewComponents) {
                addedComps = true;
                if (fluid2.getComponent(i).isIsTBPfraction() || fluid2.getComponent(i).isIsPlusFraction()) {
                    fluid1.addTBPfraction(fluid2.getComponent(i).getName(), fluid2.getComponent(i).getNumberOfmoles(), fluid2.getComponent(i).getMolarMass(), fluid2.getComponent(i).getNormalLiquidDensity());
                } else {
                    fluid1.addComponent(fluid2.getComponent(i).getName(), fluid2.getComponent(i).getNumberOfmoles());
                }
            }
            ++i;
        }
        if (addedComps) {
            fluid1.createDatabase(true);
        }
        fluid1.init(0);
        fluid1.setTemperature(fluid2.getTemperature());
        fluid1.setPressure(fluid2.getPressure());
    }

    public void setFluid(SystemInterface fluid1, SystemInterface fluid2) {
        fluid1.setEmptyFluid();
        boolean addedComps = false;
        int i = 0;
        while (i < fluid2.getNumberOfComponents()) {
            if (fluid1.getPhase(0).hasComponent(fluid2.getComponent(i).getName())) {
                fluid1.addComponent(fluid2.getComponent(i).getName(), fluid2.getComponent(i).getNumberOfmoles());
            } else {
                addedComps = true;
                if (fluid2.getComponent(i).isIsTBPfraction() || fluid2.getComponent(i).isIsPlusFraction()) {
                    fluid1.addTBPfraction(fluid2.getComponent(i).getName(), fluid2.getComponent(i).getNumberOfmoles(), fluid2.getComponent(i).getMolarMass(), fluid2.getComponent(i).getNormalLiquidDensity());
                } else {
                    fluid1.addComponent(fluid2.getComponent(i).getName(), fluid2.getComponent(i).getNumberOfmoles());
                }
            }
            ++i;
        }
        if (addedComps) {
            fluid1.createDatabase(true);
        }
        fluid1.init(0);
        fluid1.setTemperature(fluid2.getTemperature());
        fluid1.setPressure(fluid2.getPressure());
    }

    public Thread runAsThread() {
        Thread processThread = new Thread(this);
        processThread.start();
        return processThread;
    }

    @Override
    public void run() {
        boolean isConverged = true;
        boolean hasResycle = false;
        int iter = 0;
        this.recycleController.clear();
        int i = 0;
        while (i < this.unitOperations.size()) {
            if (this.unitOperations.get(i).getClass().getSimpleName().equals("Recycle")) {
                hasResycle = true;
                this.recycleController.addRecycle((Recycle)this.unitOperations.get(i));
            }
            this.unitOperations.get(i).getClass().getSimpleName().equals("Adjuster");
            ++i;
        }
        this.recycleController.init();
        do {
            ++iter;
            isConverged = true;
            i = 0;
            while (i < this.unitOperations.size()) {
                if (!this.unitOperations.get(i).getClass().getSimpleName().equals("Recycle")) {
                    try {
                        ((Runnable)this.unitOperations.get(i)).run();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (this.unitOperations.get(i).getClass().getSimpleName().equals("Recycle") && this.recycleController.doSolveRecycle((Recycle)this.unitOperations.get(i))) {
                    try {
                        ((Runnable)this.unitOperations.get(i)).run();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ++i;
            }
            if (!this.recycleController.solvedAll() || this.recycleController.hasHigherPriorityLevel()) {
                isConverged = false;
            }
            if (this.recycleController.solvedCurrentPriorityLevel()) {
                this.recycleController.nextPriorityLevel();
            } else if (this.recycleController.hasLoverPriorityLevel() && !this.recycleController.solvedAll()) {
                this.recycleController.resetPriorityLevel();
            }
            i = 0;
            while (i < this.unitOperations.size()) {
                if (this.unitOperations.get(i).getClass().getSimpleName().equals("Adjuster") && !((Adjuster)this.unitOperations.get(i)).solved()) {
                    isConverged = false;
                }
                ++i;
            }
        } while ((!isConverged || iter < 2 && hasResycle) && iter < 100);
        i = 0;
        while (i < this.unitOperations.size()) {
            if (this.unitOperations.get(i).getClass().getSimpleName().equals("Adjuster") && !((Adjuster)this.unitOperations.get(i)).solved()) {
                isConverged = false;
            }
            ++i;
        }
    }

    public void runTransient(double deltat) {
        this.timeStep = deltat;
        this.runTransient();
    }

    public double getTime() {
        return this.time;
    }

    public double getTime(String unit) {
        if (unit.equals("sec")) {
            return this.time;
        }
        if (unit.equals("hr")) {
            return this.time / 3600.0;
        }
        if (unit.equals("day")) {
            return this.time / 86400.0;
        }
        if (unit.equals("year")) {
            return this.time / 3.1536E7;
        }
        return this.time;
    }

    public void runTransient() {
        this.time += this.getTimeStep();
        int i = 0;
        while (i < this.unitOperations.size()) {
            this.unitOperations.get(i).runTransient(this.getTimeStep());
            ++i;
        }
        ++this.timeStepNumber;
        this.signalDB[this.timeStepNumber] = new String[1 + 3 * this.measurementDevices.size()];
        i = 0;
        while (i < this.measurementDevices.size()) {
            this.signalDB[this.timeStepNumber][0] = Double.toString(this.time);
            this.signalDB[this.timeStepNumber][3 * i + 1] = this.measurementDevices.get(i).getName();
            this.signalDB[this.timeStepNumber][3 * i + 2] = Double.toString(this.measurementDevices.get(i).getMeasuredValue());
            this.signalDB[this.timeStepNumber][3 * i + 3] = this.measurementDevices.get(i).getUnit();
            ++i;
        }
    }

    public int size() {
        return this.unitOperations.size();
    }

    public void view() {
        this.displayResult();
    }

    public void displayResult() {
        try {
            this.thisThread.join();
        }
        catch (Exception e) {
            System.out.println("Thread did not finish");
        }
        int i = 0;
        while (i < this.unitOperations.size()) {
            this.unitOperations.get(i).displayResult();
            ++i;
        }
    }

    public void reportMeasuredValues() {
        try {
            this.thisThread.join();
        }
        catch (Exception e) {
            System.out.println("Thread did not finish");
        }
        int i = 0;
        while (i < this.measurementDevices.size()) {
            System.out.println("Measurements Device Name: " + this.measurementDevices.get(i).getName());
            System.out.println("Value: " + this.measurementDevices.get(i).getMeasuredValue() + " " + this.measurementDevices.get(i).getUnit());
            if (this.measurementDevices.get(i).isOnlineSignal()) {
                System.out.println("Online value: " + this.measurementDevices.get(i).getOnlineSignal().getValue() + " " + this.measurementDevices.get(i).getOnlineSignal().getUnit());
            }
            ++i;
        }
    }

    public void save(String filePath) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(filePath, false));){
                out.writeObject(this);
                logger.info("process file saved to:  " + filePath);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            logger.error(e.toString());
            e.printStackTrace();
        }
    }

    public static ProcessSystem open(String filePath) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (ObjectInputStream objectinputstream = new ObjectInputStream(new FileInputStream(filePath));){
                return (ProcessSystem)objectinputstream.readObject();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String[][] reportResults() {
        String[][] text = new String[200][];
        int numb = 0;
        int i = 0;
        while (i < this.unitOperations.size()) {
            int k = 0;
            while (k < this.unitOperations.get(i).reportResults().length) {
                text[numb++] = this.unitOperations.get(i).reportResults()[k];
                ++k;
            }
            ++i;
        }
        return text;
    }

    public void printLogFile(String filename) {
        TextFile tempFile = new TextFile();
        tempFile.setOutputFileName(filename);
        tempFile.setValues(this.signalDB);
        tempFile.createFile();
    }

    public double getTimeStep() {
        return this.timeStep;
    }

    public void setTimeStep(double timeStep) {
        this.timeStep = timeStep;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SystemMechanicalDesign getSystemMechanicalDesign() {
        return this.systemMechanicalDesign;
    }

    public void setSystemMechanicalDesign(SystemMechanicalDesign systemMechanicalDesign) {
        this.systemMechanicalDesign = systemMechanicalDesign;
    }

    public CostEstimateBaseClass getCostEstimator() {
        return this.costEstimator;
    }

    public double getEntropyProduction(String unit) {
        double entropyProduction = 0.0;
        int i = 0;
        while (i < this.unitOperations.size()) {
            entropyProduction += this.unitOperations.get(i).getEntropyProduction(unit);
            System.out.println("unit " + this.unitOperations.get(i).getName() + " entropy production " + this.unitOperations.get(i).getEntropyProduction(unit));
            ++i;
        }
        return entropyProduction;
    }

    public double getExergyChange(String unit) {
        double exergyChange = 0.0;
        int i = 0;
        while (i < this.unitOperations.size()) {
            exergyChange += this.unitOperations.get(i).getExergyChange("J", this.getSurroundingTemperature());
            System.out.println("unit " + this.unitOperations.get(i).getName() + " exergy change  " + this.unitOperations.get(i).getExergyChange("J", this.getSurroundingTemperature()));
            ++i;
        }
        return exergyChange;
    }

    public double getPower(String unit) {
        double power = 0.0;
        int i = 0;
        while (i < this.unitOperations.size()) {
            if (this.unitOperations.get(i).getClass().getSimpleName().equals("Compressor")) {
                power += ((Compressor)this.unitOperations.get(i)).getPower();
            } else if (this.unitOperations.get(i).getClass().getSimpleName().equals("Pump")) {
                power += ((Pump)this.unitOperations.get(i)).getPower();
            }
            ++i;
        }
        if (unit.equals("MW")) {
            return power / 1000000.0;
        }
        if (unit.equals("kW")) {
            return power / 1000.0;
        }
        return power;
    }

    public double getCoolerDuty(String unit) {
        double heat = 0.0;
        int i = 0;
        while (i < this.unitOperations.size()) {
            if (this.unitOperations.get(i).getClass().getSimpleName().equals("Cooler")) {
                heat += ((Cooler)this.unitOperations.get(i)).getDuty();
            }
            ++i;
        }
        return heat;
    }

    public double getHeaterDuty(String unit) {
        double heat = 0.0;
        int i = 0;
        while (i < this.unitOperations.size()) {
            if (this.unitOperations.get(i).getClass().getSimpleName().equals("Heater")) {
                heat += ((Heater)this.unitOperations.get(i)).getDuty();
            }
            ++i;
        }
        return heat;
    }

    public double getMechanicalWeight(String unit) {
        double weight = 0.0;
        int i = 0;
        while (i < this.unitOperations.size()) {
            this.unitOperations.get(i).getMechanicalDesign().calcDesign();
            System.out.println("Name " + this.unitOperations.get(i).getName() + "  weight " + this.unitOperations.get(i).getMechanicalDesign().getWeightTotal());
            weight += this.unitOperations.get(i).getMechanicalDesign().getWeightTotal();
            ++i;
        }
        return weight;
    }

    public double getSurroundingTemperature() {
        return this.surroundingTemperature;
    }

    public void setSurroundingTemperature(double surroundingTemperature) {
        this.surroundingTemperature = surroundingTemperature;
    }

    public ProcessSystem copy() {
        byte[] bytes = SerializationUtils.serialize(this);
        ProcessSystem copyOperation = (ProcessSystem)SerializationUtils.deserialize(bytes);
        return copyOperation;
    }

    public ConditionMonitor getConditionMonitor() {
        return new ConditionMonitor(this);
    }
}

