/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.processEquipment.valve;

import neqsim.processSimulation.processEquipment.ProcessEquipmentBaseClass;
import neqsim.processSimulation.processEquipment.stream.Stream;
import neqsim.processSimulation.processEquipment.stream.StreamInterface;
import neqsim.processSimulation.processEquipment.valve.ValveInterface;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.ThermodynamicOperations;

public class ThrottlingValve
extends ProcessEquipmentBaseClass
implements ValveInterface {
    private static final long serialVersionUID = 1000L;
    protected String name = new String();
    private boolean valveCvSet = false;
    private boolean isoThermal = false;
    SystemInterface thermoSystem;
    StreamInterface inletStream;
    StreamInterface outStream;
    double pressure = 0.0;
    private double Cv = 1.0;
    private double maxMolarFlow = 1000.0;
    private double minMolarFlow = 0.0;
    private double percentValveOpening = 100.0;
    double molarFlow = 0.0;
    private String pressureUnit = "bara";
    private boolean acceptNegativeDP = true;

    public ThrottlingValve() {
    }

    public ThrottlingValve(StreamInterface inletStream) {
        this.setInletStream(inletStream);
    }

    public double getDeltaPressure(String unit) {
        return this.inletStream.getFluid().getPressure(unit) - this.thermoSystem.getPressure(unit);
    }

    public ThrottlingValve(String name, StreamInterface inletStream) {
        this.name = name;
        this.setInletStream(inletStream);
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setInletStream(StreamInterface inletStream) {
        this.inletStream = inletStream;
        this.thermoSystem = inletStream.getThermoSystem().clone();
        this.outStream = new Stream(this.thermoSystem);
    }

    @Override
    public double getOutletPressure() {
        return this.pressure;
    }

    @Override
    public SystemInterface getThermoSystem() {
        return this.thermoSystem;
    }

    @Override
    public double getInletPressure() {
        return this.inletStream.getThermoSystem().getPressure();
    }

    @Override
    public void setPressure(double pressure) {
        this.setOutletPressure(pressure);
    }

    public void setPressure(double pressure, String unit) {
        this.setOutletPressure(pressure, unit);
    }

    @Override
    public void setOutletPressure(double pressure) {
        this.pressure = pressure;
        this.getOutStream().getThermoSystem().setPressure(pressure, this.pressureUnit);
    }

    public void setOutletPressure(double pressure, String unit) {
        this.pressureUnit = unit;
        this.pressure = pressure;
        this.getOutStream().getThermoSystem().setPressure(pressure, this.pressureUnit);
    }

    @Override
    public StreamInterface getOutStream() {
        return this.outStream;
    }

    @Override
    public void run() {
        this.thermoSystem = this.inletStream.getThermoSystem().clone();
        ThermodynamicOperations thermoOps = new ThermodynamicOperations(this.thermoSystem);
        this.thermoSystem.init(3);
        double enthalpy = this.thermoSystem.getEnthalpy();
        if (this.thermoSystem.getPressure(this.pressureUnit) - this.pressure < 0.0) {
            if (this.isAcceptNegativeDP()) {
                this.thermoSystem.setPressure(this.pressure, this.pressureUnit);
            }
        } else {
            this.thermoSystem.setPressure(this.pressure, this.pressureUnit);
        }
        if (this.getSpecification().equals("out stream")) {
            this.thermoSystem.setPressure(this.outStream.getPressure(), this.pressureUnit);
        }
        if (this.isIsoThermal() || Math.abs(this.pressure - this.inletStream.getThermoSystem().getPressure()) < 1.0E-6) {
            thermoOps.TPflash();
        } else {
            thermoOps.PHflash(enthalpy, 0);
        }
        this.outStream.setThermoSystem(this.thermoSystem);
        if (!this.valveCvSet) {
            this.Cv = this.inletStream.getThermoSystem().getTotalNumberOfMoles() / (this.getPercentValveOpening() / 100.0 * Math.sqrt((this.inletStream.getThermoSystem().getPressure() - this.outStream.getThermoSystem().getPressure()) / this.thermoSystem.getDensity()));
        }
        this.molarFlow = this.getCv() * this.getPercentValveOpening() / 100.0 * Math.sqrt((this.inletStream.getThermoSystem().getPressure() - this.outStream.getThermoSystem().getPressure()) / this.thermoSystem.getDensity());
        if (Math.abs(this.pressure - this.inletStream.getThermoSystem().getPressure()) < 1.0E-6) {
            this.molarFlow = this.inletStream.getThermoSystem().getTotalNumberOfMoles();
        }
        this.inletStream.getThermoSystem().setTotalNumberOfMoles(this.molarFlow);
        this.inletStream.getThermoSystem().init(3);
        this.outStream.setThermoSystem(this.thermoSystem.clone());
        this.outStream.getThermoSystem().setTotalNumberOfMoles(this.molarFlow);
        this.outStream.getThermoSystem().init(3);
    }

    @Override
    public void displayResult() {
        this.thermoSystem.display(this.getName());
    }

    @Override
    public String[][] getResultTable() {
        return this.thermoSystem.getResultTable();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void runTransient(double dt) {
        this.runController(dt);
        this.thermoSystem = this.inletStream.getThermoSystem().clone();
        ThermodynamicOperations thermoOps = new ThermodynamicOperations(this.thermoSystem);
        this.thermoSystem.init(3);
        double enthalpy = this.thermoSystem.getEnthalpy();
        this.thermoSystem.setPressure(this.getOutStream().getThermoSystem().getPressure());
        if (this.isIsoThermal()) {
            thermoOps.TPflash();
        } else {
            thermoOps.PHflash(enthalpy, 0);
        }
        this.outStream.setThermoSystem(this.thermoSystem);
        this.molarFlow = this.getCv() * this.getPercentValveOpening() / 100.0 * Math.sqrt((this.inletStream.getThermoSystem().getPressure() - this.outStream.getThermoSystem().getPressure()) / this.thermoSystem.getDensity());
        this.inletStream.getThermoSystem().setTotalNumberOfMoles(this.molarFlow);
        this.inletStream.getThermoSystem().init(1);
        this.inletStream.run();
        this.outStream.getThermoSystem().setTotalNumberOfMoles(this.molarFlow);
        this.outStream.getThermoSystem().init(1);
        this.outStream.run();
    }

    public void runController(double dt) {
        if (this.hasController) {
            this.getController().run(this.percentValveOpening, dt);
            this.percentValveOpening = this.getController().getResponse();
            if (this.percentValveOpening > 100.0) {
                this.percentValveOpening = 100.0;
            }
            if (this.percentValveOpening < 0.0) {
                this.percentValveOpening = 1.0E-10;
            }
            System.out.println("valve opening " + this.percentValveOpening + " %");
        }
    }

    @Override
    public double getCv() {
        return this.Cv;
    }

    @Override
    public void setCv(double Cv) {
        this.Cv = Cv;
        this.valveCvSet = true;
    }

    @Override
    public double getPercentValveOpening() {
        return this.percentValveOpening;
    }

    @Override
    public void setPercentValveOpening(double percentValveOpening) {
        this.percentValveOpening = percentValveOpening;
    }

    public boolean isValveCvSet() {
        return this.valveCvSet;
    }

    public void setValveCvSet(boolean valveCvSet) {
        this.valveCvSet = valveCvSet;
    }

    @Override
    public boolean isIsoThermal() {
        return this.isoThermal;
    }

    @Override
    public void setIsoThermal(boolean isoThermal) {
        this.isoThermal = isoThermal;
    }

    @Override
    public double getEntropyProduction(String unit) {
        this.outStream.getThermoSystem().init(3);
        this.inletStream.getThermoSystem().init(3);
        return this.outStream.getThermoSystem().getEntropy(unit) - this.inletStream.getThermoSystem().getEntropy(unit);
    }

    @Override
    public double getExergyChange(String unit, double sourrondingTemperature) {
        this.outStream.getThermoSystem().init(3);
        this.inletStream.getThermoSystem().init(3);
        return this.outStream.getThermoSystem().getExergy(sourrondingTemperature, unit) - this.inletStream.getThermoSystem().getExergy(sourrondingTemperature, unit);
    }

    public boolean isAcceptNegativeDP() {
        return this.acceptNegativeDP;
    }

    public void setAcceptNegativeDP(boolean acceptNegativeDP) {
        this.acceptNegativeDP = acceptNegativeDP;
    }
}

