/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.processEquipment.util;

import neqsim.processSimulation.processEquipment.ProcessEquipmentBaseClass;
import neqsim.processSimulation.processEquipment.stream.StreamInterface;
import neqsim.processSimulation.processSystem.ProcessSystem;
import neqsim.thermo.system.SystemInterface;

public class StreamTransition
extends ProcessEquipmentBaseClass {
    private static final long serialVersionUID = 1L;
    private StreamInterface outletStream = null;
    private StreamInterface inletStream = null;

    public StreamTransition() {
    }

    public StreamTransition(StreamInterface inletStream, StreamInterface outletStream) {
        this.inletStream = inletStream;
        this.outletStream = outletStream;
    }

    public StreamInterface getInletStream() {
        return this.inletStream;
    }

    public void setInletStream(StreamInterface inletStream) {
        this.inletStream = inletStream;
    }

    public StreamInterface getOutletStream() {
        return this.outletStream;
    }

    public void setOutletStream(StreamInterface outletStream) {
        this.outletStream = outletStream;
    }

    @Override
    public void run() {
        SystemInterface outThermoSystem = null;
        outThermoSystem = this.outletStream != null ? this.outletStream.getFluid().clone() : this.inletStream.getFluid().clone();
        outThermoSystem.setEmptyFluid();
        int i = 0;
        while (i < this.inletStream.getFluid().getNumberOfComponents()) {
            if (outThermoSystem.getPhase(0).hasComponent(this.inletStream.getFluid().getComponent(i).getName())) {
                outThermoSystem.addComponent(this.inletStream.getFluid().getComponent(i).getName(), this.inletStream.getFluid().getComponent(i).getNumberOfmoles());
            }
            ++i;
        }
        this.outletStream.setThermoSystem(outThermoSystem);
        this.outletStream.run();
    }

    @Override
    public void displayResult() {
        this.outletStream.getFluid().display();
    }

    public static void main(String[] args) {
        ProcessSystem offshoreProcessoperations = ProcessSystem.open("c:/temp/offshorePro.neqsim");
        ProcessSystem TEGprocess = ProcessSystem.open("c:/temp//TEGprocessHX.neqsim");
        StreamTransition trans = new StreamTransition((StreamInterface)offshoreProcessoperations.getUnit("rich gas"), (StreamInterface)TEGprocess.getUnit("dry feed gas"));
        offshoreProcessoperations.run();
        trans.run();
        ((StreamInterface)offshoreProcessoperations.getUnit("rich gas")).displayResult();
        trans.displayResult();
        TEGprocess.run();
        ((StreamInterface)TEGprocess.getUnit("dry feed gas")).displayResult();
    }
}

