/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.processEquipment.util;

import java.util.ArrayList;
import neqsim.processSimulation.processEquipment.ProcessEquipmentBaseClass;
import neqsim.processSimulation.processEquipment.mixer.MixerInterface;
import neqsim.processSimulation.processEquipment.stream.Stream;
import neqsim.processSimulation.processEquipment.stream.StreamInterface;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.ThermodynamicOperations;

public class Recycle
extends ProcessEquipmentBaseClass
implements MixerInterface {
    private static final long serialVersionUID = 1000L;
    protected ArrayList<StreamInterface> streams = new ArrayList(0);
    private ArrayList<String> downstreamProperty = new ArrayList(0);
    protected int numberOfInputStreams = 0;
    protected StreamInterface mixedStream;
    StreamInterface lastIterationStream = null;
    private StreamInterface outletStream = null;
    private double tolerance = 1.0E-4;
    private double error = 1000000.0;
    private int priority = 100;
    boolean firstTime = true;
    int iterations = 0;
    int maxIterations = 10;

    public Recycle() {
    }

    public Recycle(String name) {
        super(name);
    }

    @Override
    public SystemInterface getThermoSystem() {
        return this.mixedStream.getThermoSystem();
    }

    public void setDownstreamProperty(String property) {
        this.downstreamProperty.add(property);
    }

    @Override
    public void replaceStream(int i, StreamInterface newStream) {
        this.streams.set(i, newStream);
    }

    @Override
    public void addStream(StreamInterface newStream) {
        this.streams.add(newStream);
        if (this.numberOfInputStreams == 0) {
            this.mixedStream = this.streams.get(0).clone();
        }
        this.mixedStream.setEmptyThermoSystem(this.streams.get(0).getThermoSystem());
        ++this.numberOfInputStreams;
        this.lastIterationStream = this.mixedStream.clone();
    }

    public StreamInterface getStream(int i) {
        return this.streams.get(i);
    }

    public void mixStream() {
        int index = 0;
        int k = 1;
        while (k < this.streams.size()) {
            int i = 0;
            while (i < this.streams.get(k).getThermoSystem().getPhase(0).getNumberOfComponents()) {
                boolean gotComponent = false;
                String componentName = this.streams.get(k).getThermoSystem().getPhase(0).getComponent(i).getName();
                double moles = this.streams.get(k).getThermoSystem().getPhase(0).getComponent(i).getNumberOfmoles();
                int p = 0;
                while (p < this.mixedStream.getThermoSystem().getPhase(0).getNumberOfComponents()) {
                    if (this.mixedStream.getThermoSystem().getPhase(0).getComponent(p).getName().equals(componentName)) {
                        gotComponent = true;
                        index = this.streams.get(0).getThermoSystem().getPhase(0).getComponent(p).getComponentNumber();
                    }
                    ++p;
                }
                if (gotComponent) {
                    this.mixedStream.getThermoSystem().addComponent(index, moles);
                } else {
                    System.out.println("ikke gaa hit");
                    this.mixedStream.getThermoSystem().addComponent(index, moles);
                }
                ++i;
            }
            ++k;
        }
    }

    public double guessTemperature() {
        double gtemp = 0.0;
        int k = 0;
        while (k < this.streams.size()) {
            gtemp += this.streams.get(k).getThermoSystem().getTemperature() * this.streams.get(k).getThermoSystem().getNumberOfMoles() / this.mixedStream.getThermoSystem().getNumberOfMoles();
            ++k;
        }
        return gtemp;
    }

    public double calcMixStreamEnthalpy() {
        double enthalpy = 0.0;
        int k = 0;
        while (k < this.streams.size()) {
            this.streams.get(k).getThermoSystem().init(3);
            enthalpy += this.streams.get(k).getThermoSystem().getEnthalpy();
            ++k;
        }
        return enthalpy;
    }

    @Override
    public Stream getOutStream() {
        return (Stream)this.mixedStream;
    }

    @Override
    public void runTransient() {
        this.run();
    }

    public void initiateDownstreamProperties(Stream outstream) {
        this.lastIterationStream = outstream.clone();
    }

    public void setDownstreamProperties() {
        if (this.downstreamProperty.size() > 0) {
            int i = 0;
            while (i < this.downstreamProperty.size()) {
                if (this.downstreamProperty.get(i).equals("flow rate")) {
                    this.mixedStream.setFlowRate(this.outletStream.getFlowRate("kg/hr"), "kg/hr");
                }
                ++i;
            }
        }
    }

    @Override
    public void run() {
        ++this.iterations;
        double enthalpy = 0.0;
        SystemInterface thermoSystem2 = this.streams.get(0).getThermoSystem().clone();
        this.mixedStream.setThermoSystem(thermoSystem2);
        ThermodynamicOperations testOps = new ThermodynamicOperations(thermoSystem2);
        if (this.streams.size() > 1) {
            this.mixedStream.getThermoSystem().setNumberOfPhases(2);
            this.mixedStream.getThermoSystem().reInitPhaseType();
            this.mixedStream.getThermoSystem().init(0);
            this.mixStream();
            this.setDownstreamProperties();
            try {
                enthalpy = this.calcMixStreamEnthalpy();
            }
            catch (Exception e) {
                return;
            }
            this.mixedStream.getThermoSystem().setTemperature(this.guessTemperature());
            testOps.PHflash(enthalpy, 0);
        } else {
            this.setDownstreamProperties();
            testOps.TPflash();
        }
        this.setError(this.massBalanceCheck());
        System.out.println(String.valueOf(this.name) + " recycle error: " + this.getError());
        this.lastIterationStream = (Stream)this.mixedStream.clone();
        this.outletStream.setThermoSystem(this.mixedStream.getThermoSystem());
    }

    public double massBalanceCheck() {
        double error = 0.0;
        if (this.lastIterationStream.getFluid().getNumberOfComponents() != this.mixedStream.getFluid().getNumberOfComponents()) {
            return 10.0;
        }
        int i = 0;
        while (i < this.mixedStream.getThermoSystem().getPhase(0).getNumberOfComponents()) {
            error += Math.abs(this.mixedStream.getThermoSystem().getPhase(0).getComponent(i).getx() - this.lastIterationStream.getThermoSystem().getPhase(0).getComponent(i).getx());
            ++i;
        }
        return Math.abs(error);
    }

    @Override
    public void displayResult() {
    }

    @Override
    public void setPressure(double pres) {
        int k = 0;
        while (k < this.streams.size()) {
            this.streams.get(k).getThermoSystem().setPressure(pres);
            ++k;
        }
        this.mixedStream.getThermoSystem().setPressure(pres);
    }

    public void setTemperature(double temp) {
        int k = 0;
        while (k < this.streams.size()) {
            this.streams.get(k).getThermoSystem().setTemperature(temp);
            ++k;
        }
        this.mixedStream.getThermoSystem().setTemperature(temp);
    }

    public double getTolerance() {
        return this.tolerance;
    }

    public void setTolerance(double tolerance) {
        this.tolerance = tolerance;
    }

    public double getError() {
        return this.error;
    }

    public void setError(double error) {
        this.error = error;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public boolean solved() {
        return this.error < this.tolerance;
    }

    public ArrayList<String> getDownstreamProperty() {
        return this.downstreamProperty;
    }

    public void setDownstreamProperty(ArrayList<String> upstreamProperty) {
        this.downstreamProperty = upstreamProperty;
    }

    public StreamInterface getOutletStream() {
        return this.outletStream;
    }

    public void setOutletStream(StreamInterface outletStream) {
        this.outletStream = outletStream;
        this.lastIterationStream = this.outletStream.clone();
    }
}

