/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.processEquipment.stream;

import neqsim.processSimulation.processEquipment.stream.Stream;
import neqsim.processSimulation.processEquipment.stream.StreamInterface;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.ThermodynamicOperations;

public class IronIonSaturationStream
extends Stream {
    private static final long serialVersionUID = 1000L;
    protected SystemInterface reactiveThermoSystem;

    public IronIonSaturationStream() {
    }

    public IronIonSaturationStream(SystemInterface thermoSystem) {
        super(thermoSystem);
    }

    public IronIonSaturationStream(StreamInterface stream) {
        super(stream);
    }

    public IronIonSaturationStream(String name, SystemInterface thermoSystem) {
        super(name, thermoSystem);
    }

    @Override
    public IronIonSaturationStream clone() {
        IronIonSaturationStream clonedSystem = null;
        try {
            clonedSystem = (IronIonSaturationStream)super.clone();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return clonedSystem;
    }

    @Override
    public void run() {
        System.out.println("start flashing stream... " + this.streamNumber);
        if (this.stream != null) {
            this.thermoSystem = this.stream.getThermoSystem().clone();
        }
        if (this.stream != null) {
            this.reactiveThermoSystem = this.stream.getThermoSystem().setModel("Electrolyte-CPA-EOS-statoil");
        }
        this.reactiveThermoSystem.addComponent("Fe++", 1.0E-6);
        ThermodynamicOperations thermoOps = new ThermodynamicOperations(this.reactiveThermoSystem);
        thermoOps.TPflash();
        this.reactiveThermoSystem.display();
        try {
            System.out.println("aqueous phase number " + this.reactiveThermoSystem.getPhaseNumberOfPhase("aqueous"));
            thermoOps.addIonToScaleSaturation(this.reactiveThermoSystem.getPhaseNumberOfPhase("aqueous"), "FeCO3", "Fe++");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.reactiveThermoSystem.display();
        System.out.println("number of phases: " + this.reactiveThermoSystem.getNumberOfPhases());
        System.out.println("beta: " + this.reactiveThermoSystem.getBeta());
    }

    @Override
    public void displayResult() {
        this.reactiveThermoSystem.display(this.name);
    }
}

