/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.processEquipment.separator;

import java.util.ArrayList;
import neqsim.processSimulation.mechanicalDesign.separator.GasScrubberMechanicalDesign;
import neqsim.processSimulation.processEquipment.separator.Separator;
import neqsim.processSimulation.processEquipment.separator.sectionType.SeparatorSection;
import neqsim.processSimulation.processEquipment.stream.Stream;
import neqsim.thermo.system.SystemInterface;

public class NeqGasScrubber
extends Separator {
    private static final long serialVersionUID = 1000L;
    SystemInterface thermoSystem;
    SystemInterface gasSystem;
    SystemInterface waterSystem;
    SystemInterface liquidSystem;
    SystemInterface thermoSystemCloned;
    ArrayList<SeparatorSection> scrubberSection = null;
    Stream inletStream;
    Stream gasOutStream;
    Stream liquidOutStream;
    String name = new String();

    public NeqGasScrubber() {
        this.mechanicalDesign = new GasScrubberMechanicalDesign(this);
        this.setOrientation("vertical");
    }

    public NeqGasScrubber(Stream inletStream) {
        this();
        this.setInletStream(inletStream);
    }

    public NeqGasScrubber(String name, Stream inletStream) {
        this();
        this.name = name;
        this.setInletStream(inletStream);
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public void setInletStream(Stream inletStream) {
        this.inletStream = inletStream;
        this.thermoSystem = inletStream.getThermoSystem().clone();
        this.gasSystem = this.thermoSystem.phaseToSystem(this.thermoSystem.getPhases()[0]);
        this.gasOutStream = new Stream(this.gasSystem);
        this.thermoSystem = inletStream.getThermoSystem().clone();
        this.liquidSystem = this.thermoSystem.phaseToSystem(this.thermoSystem.getPhases()[1]);
        this.liquidOutStream = new Stream(this.liquidSystem);
    }

    public void addScrubberSection(String type) {
        this.scrubberSection.add(new SeparatorSection(type, this));
    }

    @Override
    public Stream getLiquidOutStream() {
        return this.liquidOutStream;
    }

    @Override
    public Stream getGasOutStream() {
        return this.gasOutStream;
    }

    @Override
    public Stream getGas() {
        return this.getGasOutStream();
    }

    @Override
    public Stream getLiquid() {
        return this.getLiquidOutStream();
    }

    @Override
    public void run() {
        this.thermoSystem = this.inletStream.getThermoSystem().clone();
        this.gasSystem = this.thermoSystem.phaseToSystem(this.thermoSystem.getPhases()[0]);
        this.gasSystem.setNumberOfPhases(1);
        this.gasOutStream.setThermoSystem(this.gasSystem);
        this.thermoSystem = this.inletStream.getThermoSystem().clone();
        this.liquidSystem = this.thermoSystem.phaseToSystem(this.thermoSystem.getPhases()[1]);
        this.liquidSystem.setNumberOfPhases(1);
        this.liquidOutStream.setThermoSystem(this.liquidSystem);
    }

    @Override
    public void displayResult() {
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void runTransient() {
    }
}

