/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.processEquipment.separator;

import neqsim.processSimulation.mechanicalDesign.separator.GasScrubberMechanicalDesign;
import neqsim.processSimulation.processEquipment.separator.Separator;
import neqsim.processSimulation.processEquipment.separator.sectionType.SeparatorSection;
import neqsim.processSimulation.processEquipment.stream.Stream;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.ThermodynamicOperations;

public class GasScrubberSimple
extends Separator {
    private static final long serialVersionUID = 1000L;
    SystemInterface gasSystem;
    SystemInterface waterSystem;
    SystemInterface liquidSystem;
    SystemInterface thermoSystemCloned;
    Stream inletStream;
    Stream gasOutStream;
    Stream liquidOutStream;
    String name = new String();

    public GasScrubberSimple() {
        this.mechanicalDesign = new GasScrubberMechanicalDesign(this);
        this.setOrientation("vertical");
    }

    public GasScrubberSimple(Stream inletStream) {
        this();
        this.setInletStream(inletStream);
    }

    public GasScrubberSimple(String name, Stream inletStream) {
        this();
        this.name = name;
        this.setInletStream(inletStream);
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public void setInletStream(Stream inletStream) {
        this.inletStream = inletStream;
        this.thermoSystem = inletStream.getThermoSystem().clone();
        this.gasSystem = this.thermoSystem.phaseToSystem(0);
        this.gasOutStream = new Stream(this.gasSystem);
        this.thermoSystem = inletStream.getThermoSystem().clone();
        this.liquidSystem = this.thermoSystem.phaseToSystem(1);
        this.liquidOutStream = new Stream(this.liquidSystem);
    }

    @Override
    public Stream getLiquidOutStream() {
        return this.liquidOutStream;
    }

    @Override
    public Stream getGasOutStream() {
        return this.gasOutStream;
    }

    @Override
    public Stream getGas() {
        return this.getGasOutStream();
    }

    @Override
    public Stream getLiquid() {
        return this.getLiquidOutStream();
    }

    @Override
    public void run() {
        this.thermoSystem = this.inletStream.getThermoSystem().clone();
        ThermodynamicOperations thermoOps = new ThermodynamicOperations(this.thermoSystem);
        thermoOps.TPflash();
        if (this.separatorSection.size() > 0) {
            this.calcLiquidCarryoverFraction();
            this.thermoSystem.addLiquidToGas(this.getLiquidCarryoverFraction());
        }
        this.gasSystem = this.thermoSystem.phaseToSystem(0);
        this.gasSystem.setNumberOfPhases(1);
        this.gasOutStream.setThermoSystem(this.gasSystem);
        this.thermoSystem = this.inletStream.getThermoSystem().clone();
        if (this.separatorSection.size() > 0) {
            this.thermoSystem.addGasToLiquid(this.getGasCarryunderFraction());
            this.liquidSystem = this.thermoSystem.phaseToSystem(1);
        }
        this.liquidSystem.setNumberOfPhases(1);
        this.liquidOutStream.setThermoSystem(this.liquidSystem);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public double calcLiquidCarryoverFraction() {
        double Ktot = 1.0;
        int i = 0;
        while (i < this.separatorSection.size()) {
            Ktot *= 1.0 - ((SeparatorSection)this.separatorSection.get(i)).getEfficiency();
            ++i;
        }
        System.out.println("Ktot " + (1.0 - Ktot));
        double area = this.getInternalDiameter() * this.getInternalDiameter() / 4.0 * 3.14;
        double gasVel = this.thermoSystem.getTotalNumberOfMoles() * this.thermoSystem.getMolarVolume() / 100000.0 / area;
        this.setLiquidCarryoverFraction(Ktot);
        return gasVel;
    }

    public void runTransient() {
    }
}

