/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.processEquipment.pipeline;

import neqsim.fluidMechanics.flowSystem.FlowSystemInterface;
import neqsim.processSimulation.processEquipment.pipeline.Pipeline;
import neqsim.processSimulation.processEquipment.stream.Stream;
import neqsim.processSimulation.processEquipment.stream.StreamInterface;
import neqsim.thermodynamicOperations.ThermodynamicOperations;

public class SimpleTPoutPipeline
extends Pipeline {
    private static final long serialVersionUID = 1000L;
    boolean setTemperature = false;
    protected double temperatureOut = 0.0;
    protected double pressureOut = 0.0;
    double dH = 0.0;

    public SimpleTPoutPipeline() {
    }

    public SimpleTPoutPipeline(StreamInterface inStream) {
        this.inStream = inStream;
        this.outStream = (Stream)inStream.clone();
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public StreamInterface getOutStream() {
        return this.outStream;
    }

    public void setOutTemperature(double temperature) {
        this.temperatureOut = temperature;
    }

    public void setOutPressure(double pressure) {
        this.pressureOut = pressure;
    }

    @Override
    public void run() {
        this.system = this.inStream.getThermoSystem().clone();
        this.system.setTemperature(this.temperatureOut);
        this.system.setPressure(this.pressureOut);
        ThermodynamicOperations testOps = new ThermodynamicOperations(this.system);
        testOps.TPflash();
        this.outStream.setThermoSystem(this.system);
    }

    @Override
    public void displayResult() {
        this.outStream.getThermoSystem().display(this.name);
        this.outStream.getThermoSystem().initPhysicalProperties();
        System.out.println("Superficial velocity out gas : " + this.getSuperficialVelocity(0, 1));
        System.out.println("Superficial velocity out condensate : " + this.getSuperficialVelocity(1, 1));
        System.out.println("Superficial velocity out MEG/water : " + this.getSuperficialVelocity(2, 1));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void runTransient() {
    }

    @Override
    public FlowSystemInterface getPipe() {
        return null;
    }

    @Override
    public void setInitialFlowPattern(String flowPattern) {
    }
}

