/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.processEquipment.pipeline;

import neqsim.fluidMechanics.flowSystem.FlowSystemInterface;
import neqsim.processSimulation.mechanicalDesign.pipeline.PipelineMechanicalDeisgn;
import neqsim.processSimulation.processEquipment.pipeline.Pipeline;
import neqsim.processSimulation.processEquipment.stream.Stream;
import neqsim.processSimulation.processEquipment.stream.StreamInterface;
import neqsim.processSimulation.processSystem.ProcessSystem;
import neqsim.thermo.system.SystemSrkEos;
import neqsim.thermodynamicOperations.ThermodynamicOperations;

public class AdiabaticPipe
extends Pipeline {
    private static final long serialVersionUID = 1000L;
    double inletPressure = 0.0;
    boolean setTemperature = false;
    boolean setPressureOut = false;
    protected double temperatureOut = 270.0;
    protected double pressureOut = 0.0;
    double length = 100.0;
    double insideDiameter = 0.1;
    double velocity = 1.0;
    double pipeWallRoughness = 1.0E-5;
    private double inletElevation = 0.0;
    private double outletElevation = 0.0;
    double dH = 0.0;
    String flowPattern = "unknown";
    String pipeSpecification = "AP02";

    public AdiabaticPipe() {
        this.mechanicalDesign = new PipelineMechanicalDeisgn(this);
    }

    public void setPipeSpecification(double nominalDiameter, String pipeSec) {
        this.pipeSpecification = pipeSec;
        this.insideDiameter = nominalDiameter / 1000.0;
    }

    public AdiabaticPipe(StreamInterface inStream) {
        this.inStream = inStream;
        this.outStream = (Stream)inStream.clone();
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public StreamInterface getOutStream() {
        return this.outStream;
    }

    public void setOutTemperature(double temperature) {
        this.setTemperature = true;
        this.temperatureOut = temperature;
    }

    public void setOutPressure(double pressure) {
        this.setPressureOut = true;
        this.pressureOut = pressure;
    }

    public double calcWallFrictionFactor(double reynoldsNumber) {
        double relativeRoughnes = this.getPipeWallRoughness() / this.insideDiameter;
        if (Math.abs(reynoldsNumber) < 2000.0) {
            this.flowPattern = "laminar";
            return 64.0 / reynoldsNumber;
        }
        this.flowPattern = "turbulent";
        return Math.pow(1.0 / (-1.8 * Math.log10(6.9 / reynoldsNumber + Math.pow(relativeRoughnes / 3.7, 1.11))), 2.0);
    }

    public double calcPressureOut() {
        double area = 0.7853981633974483 * Math.pow(this.insideDiameter, 2.0);
        this.velocity = this.system.getPhase(0).getTotalVolume() / area / 100000.0;
        double reynoldsNumber = this.velocity * this.insideDiameter / this.system.getPhase(0).getPhysicalProperties().getKinematicViscosity();
        double frictionFactor = this.calcWallFrictionFactor(reynoldsNumber);
        double dp = Math.pow(4.0 * this.system.getPhase(0).getNumberOfMolesInPhase() * this.system.getPhase(0).getMolarMass() / 3.14159265, 2.0) * frictionFactor * this.length * this.system.getPhase(0).getZ() * 8.3144621 / this.system.getPhase(0).getMolarMass() * this.system.getTemperature() / Math.pow(this.insideDiameter, 5.0);
        System.out.println("dp gravity " + this.system.getDensity("kg/m3") * 9.80665 * (this.inletElevation - this.outletElevation) / 100000.0);
        double dp_gravity = this.system.getDensity("kg/m3") * 9.80665 * (this.inletElevation - this.outletElevation);
        return Math.sqrt(Math.pow(this.inletPressure * 100000.0, 2.0) - dp) / 100000.0 + dp_gravity / 100000.0;
    }

    public double calcFlow() {
        double averagePressue = (this.inletPressure + this.pressureOut) / 2.0;
        this.system.setPressure(averagePressue);
        this.system.init(1);
        this.system.initPhysicalProperties();
        double area = 0.7853981633974483 * Math.pow(this.insideDiameter, 2.0);
        double presdrop2 = Math.pow(this.inletPressure * 100.0, 2.0) - Math.pow(this.pressureOut * 100.0, 2.0);
        double gasGravity = this.system.getMolarMass() / 0.028;
        double oldReynold = 0.0;
        double reynoldsNumber = -1000.0;
        double flow = 0.0;
        do {
            oldReynold = reynoldsNumber;
            this.velocity = this.system.getPhase(0).getTotalVolume() / area / 100000.0;
            reynoldsNumber = this.velocity * this.insideDiameter / this.system.getPhase(0).getPhysicalProperties().getKinematicViscosity();
            double frictionFactor = this.calcWallFrictionFactor(reynoldsNumber) * 4.0;
            double temp = Math.sqrt(presdrop2 * Math.pow(this.insideDiameter * 1000.0, 5.0) / (gasGravity * this.system.getPhase(0).getZ() * this.system.getTemperature() * frictionFactor * this.length / 1000.0));
            flow = 0.33119961 / (this.system.getPressure() * 100.0) * temp;
            this.system.setTotalFlowRate(flow / 1000000.0, "MSm^3/day");
            this.system.init(1);
        } while (Math.abs(reynoldsNumber - oldReynold) / reynoldsNumber > 0.001);
        return flow;
    }

    @Override
    public void run() {
        this.system = this.inStream.getThermoSystem().clone();
        this.inletPressure = this.system.getPressure();
        if (this.setTemperature) {
            this.system.setTemperature(this.temperatureOut);
        }
        double oldPressure = 0.0;
        int iter = 0;
        if (!this.setPressureOut) {
            do {
                oldPressure = this.system.getPressure();
                this.system.init(3);
                this.system.initPhysicalProperties();
                this.system.setPressure(this.calcPressureOut());
            } while (Math.abs(this.system.getPressure() - oldPressure) > 0.01 && ++iter < 25);
        } else {
            this.calcFlow();
            this.system.setPressure(this.pressureOut);
            this.system.init(3);
        }
        ThermodynamicOperations testOps = new ThermodynamicOperations(this.system);
        testOps.TPflash();
        if (this.setPressureOut) {
            this.inStream.getThermoSystem().setTotalFlowRate(this.system.getFlowRate("kg/sec"), "kg/sec");
        }
        this.outStream.setThermoSystem(this.system);
    }

    @Override
    public void displayResult() {
        this.system.display();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void runTransient() {
        this.run();
    }

    @Override
    public FlowSystemInterface getPipe() {
        return null;
    }

    @Override
    public void setInitialFlowPattern(String flowPattern) {
    }

    public double getLength() {
        return this.length;
    }

    public void setLength(double length) {
        this.length = length;
    }

    public double getDiameter() {
        return this.insideDiameter;
    }

    public void setDiameter(double diameter) {
        this.insideDiameter = diameter;
    }

    public double getPipeWallRoughness() {
        return this.pipeWallRoughness;
    }

    public void setPipeWallRoughness(double pipeWallRoughness) {
        this.pipeWallRoughness = pipeWallRoughness;
    }

    public double getInletElevation() {
        return this.inletElevation;
    }

    public void setInletElevation(double inletElevation) {
        this.inletElevation = inletElevation;
    }

    public double getOutletElevation() {
        return this.outletElevation;
    }

    public void setOutletElevation(double outletElevation) {
        this.outletElevation = outletElevation;
    }

    public static void main(String[] name) {
        SystemSrkEos testSystem = new SystemSrkEos(278.15, 220.0);
        testSystem.addComponent("methane", 24.0, "MSm^3/day");
        testSystem.createDatabase(true);
        testSystem.setMixingRule(2);
        testSystem.init(0);
        Stream stream_1 = new Stream("Stream1", testSystem);
        AdiabaticPipe pipe = new AdiabaticPipe(stream_1);
        pipe.setLength(700000.0);
        pipe.setDiameter(0.7112);
        pipe.setPipeWallRoughness(5.0E-6);
        pipe.setOutPressure(112.0);
        ProcessSystem operations = new ProcessSystem();
        operations.add(stream_1);
        operations.add(pipe);
        operations.run();
        pipe.displayResult();
    }
}

