/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.processEquipment.mixer;

import neqsim.processSimulation.processEquipment.mixer.StaticMixer;
import neqsim.processSimulation.processEquipment.stream.StreamInterface;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.ThermodynamicOperations;

public class StaticNeqMixer
extends StaticMixer {
    private static final long serialVersionUID = 1000L;

    public StaticNeqMixer() {
    }

    public StaticNeqMixer(String name) {
        super(name);
    }

    @Override
    public void mixStream() {
        int index = 0;
        String compName = new String();
        int k = 1;
        while (k < this.streams.size()) {
            int i = 0;
            while (i < ((StreamInterface)this.streams.get(k)).getThermoSystem().getPhases()[0].getNumberOfComponents()) {
                boolean gotComponent = false;
                String componentName = ((StreamInterface)this.streams.get(k)).getThermoSystem().getPhases()[0].getComponents()[i].getName();
                System.out.println("adding: " + componentName);
                int numberOfPhases = ((StreamInterface)this.streams.get(k)).getThermoSystem().getNumberOfPhases();
                double[] moles = new double[numberOfPhases];
                int p = 0;
                while (p < numberOfPhases) {
                    moles[p] = ((StreamInterface)this.streams.get(k)).getThermoSystem().getPhases()[p].getComponents()[i].getNumberOfMolesInPhase();
                    ++p;
                }
                p = 0;
                while (p < this.mixedStream.getThermoSystem().getPhases()[0].getNumberOfComponents()) {
                    if (this.mixedStream.getThermoSystem().getPhases()[0].getComponents()[p].getName().equals(componentName)) {
                        gotComponent = true;
                        index = ((StreamInterface)this.streams.get(0)).getThermoSystem().getPhases()[0].getComponents()[p].getComponentNumber();
                        compName = ((StreamInterface)this.streams.get(0)).getThermoSystem().getPhases()[0].getComponents()[p].getComponentName();
                    }
                    ++p;
                }
                if (gotComponent) {
                    System.out.println("adding moles starting....");
                    p = 0;
                    while (p < numberOfPhases) {
                        this.mixedStream.getThermoSystem().addComponent(index, moles[p], p);
                        ++p;
                    }
                    System.out.println("adding moles finished");
                } else {
                    System.out.println("ikke gaa hit");
                    p = 0;
                    while (p < numberOfPhases) {
                        this.mixedStream.getThermoSystem().addComponent(compName, moles[p], p);
                        ++p;
                    }
                }
                ++i;
            }
            ++k;
        }
        this.mixedStream.getThermoSystem().init_x_y();
        this.mixedStream.getThermoSystem().initBeta();
        this.mixedStream.getThermoSystem().init(2);
    }

    @Override
    public void run() {
        double enthalpy = 0.0;
        int k = 0;
        while (k < this.streams.size()) {
            ((StreamInterface)this.streams.get(k)).getThermoSystem().init(3);
            enthalpy += ((StreamInterface)this.streams.get(k)).getThermoSystem().getEnthalpy();
            ++k;
        }
        this.mixedStream.setThermoSystem(((StreamInterface)this.streams.get(0)).getThermoSystem().clone());
        this.mixedStream.getThermoSystem().setNumberOfPhases(2);
        this.mixedStream.getThermoSystem().reInitPhaseType();
        this.mixStream();
        SystemInterface syst = this.mixedStream.getThermoSystem().clone();
        syst.setTemperature(((StreamInterface)this.streams.get(0)).getThermoSystem().getTemperature());
        syst.setPressure(((StreamInterface)this.streams.get(0)).getThermoSystem().getPressure());
        ThermodynamicOperations testOps = new ThermodynamicOperations(syst);
        testOps.PHflash(enthalpy, 0);
        System.out.println("temp " + syst.getTemperature());
        this.mixedStream.getThermoSystem().setTemperature(syst.getTemperature());
        this.mixedStream.getThermoSystem().init(3);
    }

    @Override
    public String getName() {
        return this.name;
    }
}

