/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.processEquipment.mixer;

import neqsim.processSimulation.processEquipment.mixer.Mixer;
import neqsim.processSimulation.processEquipment.stream.StreamInterface;
import neqsim.thermodynamicOperations.ThermodynamicOperations;

public class StaticMixer
extends Mixer {
    private static final long serialVersionUID = 1000L;

    public StaticMixer() {
    }

    public StaticMixer(String name) {
        super(name);
    }

    @Override
    public void mixStream() {
        int index = 0;
        String compName = new String();
        int k = 1;
        while (k < this.streams.size()) {
            int i = 0;
            while (i < ((StreamInterface)this.streams.get(k)).getThermoSystem().getPhases()[0].getNumberOfComponents()) {
                boolean gotComponent = false;
                String componentName = ((StreamInterface)this.streams.get(k)).getThermoSystem().getPhases()[0].getComponents()[i].getName();
                double moles = ((StreamInterface)this.streams.get(k)).getThermoSystem().getPhases()[0].getComponents()[i].getNumberOfmoles();
                int p = 0;
                while (p < this.mixedStream.getThermoSystem().getPhases()[0].getNumberOfComponents()) {
                    if (this.mixedStream.getThermoSystem().getPhases()[0].getComponents()[p].getName().equals(componentName)) {
                        gotComponent = true;
                        index = ((StreamInterface)this.streams.get(0)).getThermoSystem().getPhases()[0].getComponents()[p].getComponentNumber();
                        compName = ((StreamInterface)this.streams.get(0)).getThermoSystem().getPhases()[0].getComponents()[p].getComponentName();
                    }
                    ++p;
                }
                if (gotComponent) {
                    this.mixedStream.getThermoSystem().addComponent(index, moles, 0);
                } else {
                    this.mixedStream.getThermoSystem().addComponent(compName, moles, 0);
                }
                ++i;
            }
            ++k;
        }
    }

    @Override
    public double guessTemperature() {
        double gtemp = 0.0;
        int k = 0;
        while (k < this.streams.size()) {
            gtemp += ((StreamInterface)this.streams.get(k)).getThermoSystem().getTemperature() * ((StreamInterface)this.streams.get(k)).getThermoSystem().getNumberOfMoles() / this.mixedStream.getThermoSystem().getNumberOfMoles();
            ++k;
        }
        return gtemp;
    }

    @Override
    public double calcMixStreamEnthalpy() {
        double enthalpy = 0.0;
        int k = 0;
        while (k < this.streams.size()) {
            ((StreamInterface)this.streams.get(k)).getThermoSystem().init(3);
            enthalpy += ((StreamInterface)this.streams.get(k)).getThermoSystem().getEnthalpy();
            System.out.println("total enthalpy k : " + ((StreamInterface)this.streams.get(k)).getThermoSystem().getEnthalpy());
            ++k;
        }
        System.out.println("total enthalpy of streams: " + enthalpy);
        return enthalpy;
    }

    @Override
    public void run() {
        double enthalpy = 0.0;
        int k = 0;
        while (k < this.streams.size()) {
            ((StreamInterface)this.streams.get(k)).getThermoSystem().init(3);
            enthalpy += ((StreamInterface)this.streams.get(k)).getThermoSystem().getEnthalpy();
            ++k;
        }
        this.mixedStream.setThermoSystem(((StreamInterface)this.streams.get(0)).getThermoSystem().clone());
        this.mixedStream.getThermoSystem().setNumberOfPhases(2);
        this.mixedStream.getThermoSystem().reInitPhaseType();
        this.mixStream();
        ThermodynamicOperations testOps = new ThermodynamicOperations(this.mixedStream.getThermoSystem());
        testOps.PHflash(enthalpy, 0);
        this.mixedStream.getThermoSystem().init(3);
    }

    @Override
    public void runTransient() {
    }
}

