/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.processEquipment.mixer;

import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.util.ArrayList;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import neqsim.processSimulation.processEquipment.ProcessEquipmentBaseClass;
import neqsim.processSimulation.processEquipment.mixer.MixerInterface;
import neqsim.processSimulation.processEquipment.stream.Stream;
import neqsim.processSimulation.processEquipment.stream.StreamInterface;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.ThermodynamicOperations;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Mixer
extends ProcessEquipmentBaseClass
implements MixerInterface {
    private static final long serialVersionUID = 1000L;
    protected ArrayList<StreamInterface> streams = new ArrayList(0);
    private int numberOfInputStreams = 0;
    protected Stream mixedStream;
    private boolean isSetOutTemperature = false;
    private double outTemperature = Double.NaN;
    static Logger logger = LogManager.getLogger(Mixer.class);

    public Mixer() {
    }

    public Mixer(String name) {
        super(name);
    }

    @Override
    public SystemInterface getThermoSystem() {
        return this.mixedStream.getThermoSystem();
    }

    @Override
    public void replaceStream(int i, StreamInterface newStream) {
        this.streams.set(i, newStream);
    }

    @Override
    public void addStream(StreamInterface newStream) {
        this.streams.add(newStream);
        try {
            if (this.getNumberOfInputStreams() == 0) {
                this.mixedStream = (Stream)this.streams.get(0).clone();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ++this.numberOfInputStreams;
    }

    public StreamInterface getStream(int i) {
        return this.streams.get(i);
    }

    public void mixStream() {
        int index = 0;
        String compName = new String();
        double lowestPressure = this.mixedStream.getThermoSystem().getPhase(0).getPressure();
        boolean hasAddedNewComponent = false;
        int k = 1;
        while (k < this.streams.size()) {
            if (this.streams.get(k).getThermoSystem().getPhase(0).getPressure() < lowestPressure) {
                lowestPressure = this.streams.get(k).getThermoSystem().getPhase(0).getPressure();
                this.mixedStream.getThermoSystem().getPhase(0).setPressure(lowestPressure);
            }
            int i = 0;
            while (i < this.streams.get(k).getThermoSystem().getPhase(0).getNumberOfComponents()) {
                boolean gotComponent = false;
                String componentName = this.streams.get(k).getThermoSystem().getPhase(0).getComponent(i).getName();
                double moles = this.streams.get(k).getThermoSystem().getPhase(0).getComponent(i).getNumberOfmoles();
                int p = 0;
                while (p < this.mixedStream.getThermoSystem().getPhase(0).getNumberOfComponents()) {
                    if (this.mixedStream.getThermoSystem().getPhase(0).getComponent(p).getName().equals(componentName)) {
                        gotComponent = true;
                        index = this.streams.get(0).getThermoSystem().getPhase(0).getComponent(p).getComponentNumber();
                        compName = this.streams.get(0).getThermoSystem().getPhase(0).getComponent(p).getComponentName();
                    }
                    ++p;
                }
                if (gotComponent) {
                    this.mixedStream.getThermoSystem().addComponent(index, moles);
                } else {
                    hasAddedNewComponent = true;
                    this.mixedStream.getThermoSystem().addComponent(compName, moles);
                }
                ++i;
            }
            ++k;
        }
        if (hasAddedNewComponent) {
            this.mixedStream.getThermoSystem().setMixingRule(this.mixedStream.getThermoSystem().getMixingRule());
        }
    }

    public double guessTemperature() {
        double gtemp = 0.0;
        int k = 0;
        while (k < this.streams.size()) {
            gtemp += this.streams.get(k).getThermoSystem().getTemperature() * this.streams.get(k).getThermoSystem().getNumberOfMoles() / this.mixedStream.getThermoSystem().getNumberOfMoles();
            ++k;
        }
        return gtemp;
    }

    public double calcMixStreamEnthalpy() {
        double enthalpy = 0.0;
        int k = 0;
        while (k < this.streams.size()) {
            this.streams.get(k).getThermoSystem().init(3);
            enthalpy += this.streams.get(k).getThermoSystem().getEnthalpy();
            ++k;
        }
        return enthalpy;
    }

    @Override
    public Stream getOutStream() {
        return this.mixedStream;
    }

    @Override
    public void runTransient() {
        this.run();
    }

    @Override
    public void run() {
        double enthalpy = 0.0;
        SystemInterface thermoSystem2 = this.streams.get(0).getThermoSystem().clone();
        this.mixedStream.setThermoSystem(thermoSystem2);
        ThermodynamicOperations testOps = new ThermodynamicOperations(thermoSystem2);
        if (this.streams.size() > 0) {
            this.mixedStream.getThermoSystem().setNumberOfPhases(2);
            this.mixedStream.getThermoSystem().reInitPhaseType();
            this.mixedStream.getThermoSystem().init(0);
            this.mixStream();
            enthalpy = this.calcMixStreamEnthalpy();
            if (!this.isSetOutTemperature) {
                this.mixedStream.getThermoSystem().setTemperature(this.guessTemperature());
            } else {
                this.mixedStream.setTemperature(this.outTemperature, "K");
            }
        }
        if (this.isSetOutTemperature) {
            if (!Double.isNaN(this.getOutTemperature())) {
                this.mixedStream.getThermoSystem().setTemperature(this.getOutTemperature());
            }
            testOps.TPflash();
            this.mixedStream.getThermoSystem().init(2);
        } else {
            try {
                testOps.PHflash(enthalpy, 0);
            }
            catch (Exception e) {
                logger.error(e.getMessage());
                if (!Double.isNaN(this.getOutTemperature())) {
                    this.mixedStream.getThermoSystem().setTemperature(this.getOutTemperature());
                }
                testOps.TPflash();
            }
        }
    }

    @Override
    public void displayResult() {
        SystemInterface thermoSystem = this.mixedStream.getThermoSystem();
        DecimalFormat nf = new DecimalFormat();
        nf.setMaximumFractionDigits(5);
        nf.applyPattern("#.#####E0");
        JDialog dialog = new JDialog((Frame)new JFrame(), "Results from TPflash");
        Container dialogContentPane = dialog.getContentPane();
        dialogContentPane.setLayout(new FlowLayout());
        thermoSystem.initPhysicalProperties();
        Object[][] table = new String[50][5];
        Object[] names = new String[]{"", "Phase 1", "Phase 2", "Phase 3", "Unit"};
        table[0][0] = "";
        table[0][1] = "";
        table[0][2] = "";
        table[0][3] = "";
        StringBuffer buf = new StringBuffer();
        FieldPosition test2 = new FieldPosition(0);
        int i = 0;
        while (i < thermoSystem.getNumberOfPhases()) {
            int j = 0;
            while (j < thermoSystem.getPhases()[0].getNumberOfComponents()) {
                table[j + 1][0] = thermoSystem.getPhases()[0].getComponents()[j].getName();
                buf = new StringBuffer();
                table[j + 1][i + 1] = nf.format(thermoSystem.getPhases()[i].getComponents()[j].getx(), buf, test2).toString();
                table[j + 1][4] = "[-]";
                ++j;
            }
            buf = new StringBuffer();
            table[thermoSystem.getPhases()[0].getNumberOfComponents() + 2][0] = "Density";
            table[thermoSystem.getPhases()[0].getNumberOfComponents() + 2][i + 1] = nf.format(thermoSystem.getPhases()[i].getPhysicalProperties().getDensity(), buf, test2).toString();
            table[thermoSystem.getPhases()[0].getNumberOfComponents() + 2][4] = "[kg/m^3]";
            buf = new StringBuffer();
            table[thermoSystem.getPhases()[0].getNumberOfComponents() + 3][0] = "PhaseFraction";
            table[thermoSystem.getPhases()[0].getNumberOfComponents() + 3][i + 1] = nf.format(thermoSystem.getPhases()[i].getBeta(), buf, test2).toString();
            table[thermoSystem.getPhases()[0].getNumberOfComponents() + 3][4] = "[-]";
            buf = new StringBuffer();
            table[thermoSystem.getPhases()[0].getNumberOfComponents() + 4][0] = "MolarMass";
            table[thermoSystem.getPhases()[0].getNumberOfComponents() + 4][i + 1] = nf.format(thermoSystem.getPhases()[i].getMolarMass() * 1000.0, buf, test2).toString();
            table[thermoSystem.getPhases()[0].getNumberOfComponents() + 4][4] = "[kg/kmol]";
            buf = new StringBuffer();
            table[thermoSystem.getPhases()[0].getNumberOfComponents() + 5][0] = "Cp";
            table[thermoSystem.getPhases()[0].getNumberOfComponents() + 5][i + 1] = nf.format(thermoSystem.getPhases()[i].getCp() / (thermoSystem.getPhases()[i].getNumberOfMolesInPhase() * thermoSystem.getPhases()[i].getMolarMass() * 1000.0), buf, test2).toString();
            table[thermoSystem.getPhases()[0].getNumberOfComponents() + 5][4] = "[kJ/kg*K]";
            buf = new StringBuffer();
            table[thermoSystem.getPhases()[0].getNumberOfComponents() + 7][0] = "Viscosity";
            table[thermoSystem.getPhases()[0].getNumberOfComponents() + 7][i + 1] = nf.format(thermoSystem.getPhases()[i].getPhysicalProperties().getViscosity(), buf, test2).toString();
            table[thermoSystem.getPhases()[0].getNumberOfComponents() + 7][4] = "[kg/m*sec]";
            buf = new StringBuffer();
            table[thermoSystem.getPhases()[0].getNumberOfComponents() + 8][0] = "Conductivity";
            table[thermoSystem.getPhases()[0].getNumberOfComponents() + 8][i + 1] = nf.format(thermoSystem.getPhases()[i].getPhysicalProperties().getConductivity(), buf, test2).toString();
            table[thermoSystem.getPhases()[0].getNumberOfComponents() + 8][4] = "[W/m*K]";
            buf = new StringBuffer();
            table[thermoSystem.getPhases()[0].getNumberOfComponents() + 10][0] = "Pressure";
            table[thermoSystem.getPhases()[0].getNumberOfComponents() + 10][i + 1] = Double.toString(thermoSystem.getPhases()[i].getPressure());
            table[thermoSystem.getPhases()[0].getNumberOfComponents() + 10][4] = "[bar]";
            buf = new StringBuffer();
            table[thermoSystem.getPhases()[0].getNumberOfComponents() + 11][0] = "Temperature";
            table[thermoSystem.getPhases()[0].getNumberOfComponents() + 11][i + 1] = Double.toString(thermoSystem.getPhases()[i].getTemperature());
            table[thermoSystem.getPhases()[0].getNumberOfComponents() + 11][4] = "[K]";
            Double.toString(thermoSystem.getPhases()[i].getTemperature());
            buf = new StringBuffer();
            table[thermoSystem.getPhases()[0].getNumberOfComponents() + 13][0] = "Stream";
            table[thermoSystem.getPhases()[0].getNumberOfComponents() + 13][i + 1] = this.name;
            table[thermoSystem.getPhases()[0].getNumberOfComponents() + 13][4] = "-";
            ++i;
        }
        JTable Jtab = new JTable(table, names);
        JScrollPane scrollpane = new JScrollPane(Jtab);
        dialogContentPane.add(scrollpane);
        dialog.pack();
        dialog.setVisible(true);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setPressure(double pres) {
        int k = 0;
        while (k < this.streams.size()) {
            this.streams.get(k).getThermoSystem().setPressure(pres);
            ++k;
        }
        this.mixedStream.getThermoSystem().setPressure(pres);
    }

    public void setTemperature(double temp) {
        int k = 0;
        while (k < this.streams.size()) {
            this.streams.get(k).getThermoSystem().setTemperature(temp);
            ++k;
        }
        this.mixedStream.getThermoSystem().setTemperature(temp);
    }

    public double getOutTemperature() {
        return this.outTemperature;
    }

    public void setOutTemperature(double outTemperature) {
        this.isSetOutTemperature(true);
        this.outTemperature = outTemperature;
    }

    public boolean isSetOutTemperature() {
        return this.isSetOutTemperature;
    }

    public void isSetOutTemperature(boolean isSetOutTemperature) {
        this.isSetOutTemperature = isSetOutTemperature;
    }

    public int getNumberOfInputStreams() {
        return this.numberOfInputStreams;
    }

    @Override
    public double getEntropyProduction(String unit) {
        this.getOutStream().run();
        double entrop = 0.0;
        int i = 0;
        while (i < this.numberOfInputStreams) {
            this.getStream(i).getFluid().init(3);
            entrop += this.getStream(i).getFluid().getEntropy(unit);
            ++i;
        }
        this.getOutStream().getThermoSystem().init(3);
        return this.getOutStream().getThermoSystem().getEntropy(unit) - entrop;
    }
}

