/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.processEquipment.heatExchanger;

import neqsim.processSimulation.processEquipment.heatExchanger.Heater;
import neqsim.processSimulation.processEquipment.stream.Stream;
import neqsim.processSimulation.processEquipment.stream.StreamInterface;
import neqsim.thermo.system.SystemInterface;

public class NeqHeater
extends Heater {
    private static final long serialVersionUID = 1000L;
    StreamInterface outStream;
    StreamInterface inStream;
    SystemInterface system;
    double dH = 0.0;

    public NeqHeater() {
    }

    public NeqHeater(Stream inStream) {
        this.inStream = inStream;
        this.outStream = inStream.clone();
    }

    @Override
    public StreamInterface getOutStream() {
        return this.outStream;
    }

    @Override
    public void setOutTemperature(double temperature) {
        this.setTemperature = true;
        this.temperatureOut = temperature;
    }

    @Override
    public void run() {
        this.system = this.inStream.getThermoSystem().clone();
        double oldH = this.system.getEnthalpy();
        if (this.setTemperature) {
            this.system.setTemperature(this.temperatureOut);
        } else {
            this.system.setTemperature(this.system.getTemperature() + this.dT);
        }
        this.system.init(3);
        double newH = this.system.getEnthalpy();
        this.dH = newH - oldH;
        this.outStream.setThermoSystem(this.system);
    }

    @Override
    public void displayResult() {
        System.out.println("heater dH: " + this.dH);
    }
}

