/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.processEquipment.heatExchanger;

import neqsim.processSimulation.processEquipment.ProcessEquipmentBaseClass;
import neqsim.processSimulation.processEquipment.heatExchanger.HeaterInterface;
import neqsim.processSimulation.processEquipment.stream.Stream;
import neqsim.processSimulation.processEquipment.stream.StreamInterface;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.ThermodynamicOperations;

public class Heater
extends ProcessEquipmentBaseClass
implements HeaterInterface {
    private static final long serialVersionUID = 1000L;
    boolean setTemperature = false;
    boolean setOutPressure = false;
    private StreamInterface outStream;
    StreamInterface inStream;
    SystemInterface system;
    protected double temperatureOut = 0.0;
    protected double dT = 0.0;
    protected double pressureOut = 0.0;
    private boolean setEnergyInput = false;
    private double energyInput = 0.0;
    private double pressureDrop = 0.0;
    private String temperatureUnit = "K";
    private String pressureUnit = "bara";
    double coolingMediumTemperature = 278.15;

    public Heater() {
    }

    public Heater(StreamInterface inStream) {
        this.inStream = inStream;
        this.system = inStream.getThermoSystem().clone();
        this.outStream = new Stream(this.system);
    }

    public Heater(String name, StreamInterface inStream) {
        super(name);
        this.inStream = inStream;
        this.system = inStream.getThermoSystem().clone();
        this.outStream = new Stream(this.system);
    }

    public StreamInterface getInStream() {
        return this.inStream;
    }

    @Override
    public void setdT(double dT) {
        this.dT = dT;
    }

    public StreamInterface getOutStream() {
        return this.outStream;
    }

    public void setOutPressure(double pressure) {
        this.setOutPressure = true;
        this.pressureOut = pressure;
    }

    @Override
    public void setOutPressure(double pressure, String unit) {
        this.setOutPressure = true;
        this.pressureOut = pressure;
        this.pressureUnit = unit;
    }

    public void setOutTemperature(double temperature) {
        this.setTemperature = true;
        this.setEnergyInput = false;
        this.temperatureOut = temperature;
    }

    @Override
    public void setOutTemperature(double temperature, String unit) {
        this.setTemperature = true;
        this.setEnergyInput = false;
        this.temperatureUnit = unit;
        this.temperatureOut = temperature;
    }

    @Override
    public void setOutTP(double temperature, double pressure) {
        this.setTemperature = true;
        this.setEnergyInput = false;
        this.temperatureOut = temperature;
        this.setOutPressure = true;
        this.pressureOut = pressure;
    }

    @Override
    public void run() {
        this.system = this.inStream.getThermoSystem().clone();
        this.system.init(3);
        double oldH = this.system.getEnthalpy();
        if (this.isSetEnergyStream()) {
            this.energyInput = -this.energyStream.getDuty();
        }
        double newEnthalpy = this.energyInput + oldH;
        this.system.setPressure(this.system.getPressure() - this.pressureDrop, this.pressureUnit);
        if (this.setOutPressure) {
            this.system.setPressure(this.pressureOut, this.pressureUnit);
        }
        ThermodynamicOperations testOps = new ThermodynamicOperations(this.system);
        if (this.getSpecification().equals("out stream")) {
            this.getOutStream().setFlowRate(this.getInStream().getFlowRate("kg/sec"), "kg/sec");
            this.getOutStream().run();
            this.temperatureOut = this.getOutStream().getTemperature();
            this.system = this.getOutStream().getThermoSystem().clone();
        } else if (this.setTemperature) {
            this.system.setTemperature(this.temperatureOut, this.temperatureUnit);
            testOps.TPflash();
        } else if (this.setEnergyInput || this.isSetEnergyStream()) {
            testOps.PHflash(newEnthalpy, 0);
        } else {
            this.system.setTemperature(this.inStream.getTemperature() + this.dT, this.temperatureUnit);
            testOps.TPflash();
        }
        this.system.init(3);
        double newH = this.system.getEnthalpy();
        this.energyInput = newH - oldH;
        if (!this.isSetEnergyStream()) {
            this.getEnergyStream().setDuty(this.energyInput);
        }
        this.getOutStream().setThermoSystem(this.system);
    }

    @Override
    public void displayResult() {
        this.getOutStream().displayResult();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void runTransient() {
        this.run();
    }

    public double getEnergyInput() {
        return this.energyInput;
    }

    public double getDuty() {
        return this.energyInput;
    }

    public void setEnergyInput(double energyInput) {
        this.energyInput = energyInput;
        this.setTemperature = false;
        this.setEnergyInput = true;
    }

    public void setDuty(double energyInput) {
        this.setEnergyInput(energyInput);
    }

    public boolean isSetEnergyInput() {
        return this.setEnergyInput;
    }

    public void setSetEnergyInput(boolean setEnergyInput) {
        this.setEnergyInput = setEnergyInput;
    }

    public double getPressureDrop() {
        return this.pressureDrop;
    }

    public void setPressureDrop(double pressureDrop) {
        this.pressureDrop = pressureDrop;
    }

    public void setOutStream(Stream outStream) {
        this.outStream = outStream;
    }

    @Override
    public double getEntropyProduction(String unit) {
        double entrop = 0.0;
        this.inStream.run();
        this.inStream.getFluid().init(3);
        this.outStream.run();
        this.outStream.getFluid().init(3);
        return entrop += this.outStream.getThermoSystem().getEntropy(unit) - this.inStream.getThermoSystem().getEntropy(unit);
    }

    @Override
    public double getExergyChange(String unit, double sourrondingTemperature) {
        double entrop = 0.0;
        this.inStream.run();
        this.inStream.getFluid().init(3);
        this.outStream.run();
        this.outStream.getFluid().init(3);
        return entrop += this.outStream.getThermoSystem().getExergy(sourrondingTemperature, unit) - this.inStream.getThermoSystem().getExergy(sourrondingTemperature, unit);
    }
}

