/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.processEquipment.distillation;

import neqsim.processSimulation.processEquipment.distillation.SimpleTray;
import neqsim.processSimulation.processEquipment.stream.Stream;
import neqsim.processSimulation.processEquipment.stream.StreamInterface;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.ThermodynamicOperations;

public class VLSolidTray
extends SimpleTray {
    private static final long serialVersionUID = 1000L;
    double heatInput = 0.0;
    private double temperature = 273.15;

    @Override
    public void init() {
        int pp = 0;
        if (this.streams.size() == 3) {
            pp = 1;
        }
        int k = pp;
        while (k < this.streams.size()) {
            ((StreamInterface)this.streams.get(k)).getThermoSystem().setTemperature(this.temperature);
            ++k;
        }
    }

    @Override
    public void setHeatInput(double heatinp) {
        this.heatInput = heatinp;
    }

    @Override
    public double calcMixStreamEnthalpy() {
        double enthalpy = this.heatInput;
        int k = 0;
        while (k < this.streams.size()) {
            ((StreamInterface)this.streams.get(k)).getThermoSystem().init(3);
            enthalpy += ((StreamInterface)this.streams.get(k)).getThermoSystem().getEnthalpy();
            System.out.println("total enthalpy k : " + ((StreamInterface)this.streams.get(k)).getThermoSystem().getEnthalpy());
            ++k;
        }
        System.out.println("total enthalpy of streams: " + enthalpy);
        return enthalpy;
    }

    @Override
    public void run() {
        double enthalpy = 0.0;
        SystemInterface thermoSystem2 = ((StreamInterface)this.streams.get(0)).getThermoSystem().clone();
        this.mixedStream.setThermoSystem(thermoSystem2);
        ThermodynamicOperations testOps = new ThermodynamicOperations(thermoSystem2);
        if (this.streams.size() > 0) {
            this.mixedStream.getThermoSystem().setNumberOfPhases(2);
            this.mixedStream.getThermoSystem().reInitPhaseType();
            this.mixedStream.getThermoSystem().init(0);
            this.mixStream();
            enthalpy = this.calcMixStreamEnthalpy();
            this.mixedStream.getThermoSystem().setSolidPhaseCheck("CO2");
            this.mixedStream.getThermoSystem().setTemperature(this.guessTemperature());
            testOps.PHsolidFlash(enthalpy);
            this.mixedStream.getThermoSystem().display();
        } else {
            testOps.TPflash();
        }
        this.mixedStream.getThermoSystem().setSolidPhaseCheck(false);
    }

    @Override
    public void runTransient() {
    }

    @Override
    public Stream getGasOutStream() {
        return new Stream("", this.mixedStream.getThermoSystem().phaseToSystem(0));
    }

    @Override
    public Stream getLiquidOutStream() {
        return new Stream("", this.mixedStream.getThermoSystem().phaseToSystem(1));
    }

    @Override
    public double getTemperature() {
        return this.temperature;
    }

    @Override
    public void setTemperature(double temperature) {
        this.temperature = temperature;
    }
}

