/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.processEquipment.absorber;

import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.util.ArrayList;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import neqsim.processSimulation.mechanicalDesign.absorber.AbsorberMechanicalDesign;
import neqsim.processSimulation.processEquipment.ProcessEquipmentInterface;
import neqsim.processSimulation.processEquipment.absorber.SimpleAbsorber;
import neqsim.processSimulation.processEquipment.stream.Stream;
import neqsim.processSimulation.processEquipment.stream.StreamInterface;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.ThermodynamicOperations;

public class SimpleTEGAbsorber
extends SimpleAbsorber {
    private static final long serialVersionUID = 1000L;
    protected ArrayList<StreamInterface> streams = new ArrayList(0);
    protected double pressure = 0.0;
    protected int numberOfInputStreams = 0;
    protected Stream mixedStream;
    protected Stream gasInStream;
    protected Stream solventInStream;
    private Stream gasOutStream;
    private Stream solventOutStream;
    protected Stream outStream;
    private double kwater = 1.0E-4;
    int solventStreamNumber = 0;

    public SimpleTEGAbsorber() {
        this.mechanicalDesign = new AbsorberMechanicalDesign(this);
    }

    public SimpleTEGAbsorber(String name) {
        this.setName(name);
        this.mechanicalDesign = new AbsorberMechanicalDesign(this);
    }

    @Override
    public void addStream(StreamInterface newStream) {
        this.streams.add(newStream);
        if (this.numberOfInputStreams == 0) {
            this.mixedStream = (Stream)this.streams.get(0).clone();
            this.mixedStream.getThermoSystem().setNumberOfPhases(2);
            this.mixedStream.getThermoSystem().reInitPhaseType();
            this.mixedStream.getThermoSystem().init(0);
            this.mixedStream.getThermoSystem().init(3);
        }
        ++this.numberOfInputStreams;
    }

    public void addGasInStream(StreamInterface newStream) {
        this.gasInStream = (Stream)newStream;
        this.gasOutStream = (Stream)newStream.clone();
        this.addStream(newStream);
    }

    public void addSolventInStream(StreamInterface newStream) {
        this.solventInStream = (Stream)newStream;
        this.solventOutStream = (Stream)newStream.clone();
        this.addStream(newStream);
        this.solventStreamNumber = this.streams.size() - 1;
    }

    public void replaceSolventInStream(StreamInterface newStream) {
        this.solventInStream = (Stream)newStream;
        this.streams.set(this.solventStreamNumber, this.solventInStream);
    }

    @Override
    public void setPressure(double pressure) {
        this.pressure = pressure;
    }

    public void mixStream() {
        String compName = new String();
        int k = 1;
        while (k < this.streams.size()) {
            int i = 0;
            while (i < this.streams.get(k).getThermoSystem().getPhases()[0].getNumberOfComponents()) {
                boolean gotComponent = false;
                String componentName = this.streams.get(k).getThermoSystem().getPhases()[0].getComponents()[i].getName();
                double moles = this.streams.get(k).getThermoSystem().getPhases()[0].getComponents()[i].getNumberOfmoles();
                int p = 0;
                while (p < this.mixedStream.getThermoSystem().getPhases()[0].getNumberOfComponents()) {
                    if (this.mixedStream.getThermoSystem().getPhases()[0].getComponents()[p].getName().equals(componentName)) {
                        gotComponent = true;
                        compName = this.streams.get(0).getThermoSystem().getPhases()[0].getComponents()[p].getComponentName();
                    }
                    ++p;
                }
                if (gotComponent) {
                    this.mixedStream.getThermoSystem().addComponent(compName, moles);
                } else {
                    this.mixedStream.getThermoSystem().addComponent(compName, moles);
                }
                ++i;
            }
            ++k;
        }
        this.mixedStream.getThermoSystem().init_x_y();
        this.mixedStream.getThermoSystem().initBeta();
        this.mixedStream.getThermoSystem().init(2);
    }

    public double guessTemperature() {
        double gtemp = 0.0;
        int k = 0;
        while (k < this.streams.size()) {
            gtemp += this.streams.get(k).getThermoSystem().getTemperature() * this.streams.get(k).getThermoSystem().getNumberOfMoles() / this.mixedStream.getThermoSystem().getNumberOfMoles();
            ++k;
        }
        return gtemp;
    }

    public double calcMixStreamEnthalpy() {
        double enthalpy = 0.0;
        int k = 0;
        while (k < this.streams.size()) {
            this.streams.get(k).getThermoSystem().init(3);
            enthalpy += this.streams.get(k).getThermoSystem().getEnthalpy();
            ++k;
        }
        return enthalpy;
    }

    @Override
    public Stream getOutStream() {
        return this.mixedStream;
    }

    public Stream getInStream() {
        return this.gasInStream;
    }

    @Override
    public Stream getGasOutStream() {
        return this.gasOutStream;
    }

    public Stream getGasInStream() {
        return this.gasInStream;
    }

    @Override
    public Stream getLiquidOutStream() {
        return this.solventOutStream;
    }

    @Override
    public Stream getSolventInStream() {
        return this.solventInStream;
    }

    @Override
    public void runTransient() {
    }

    public double calcEa() {
        double A = this.mixedStream.getThermoSystem().getPhase(1).getNumberOfMolesInPhase() / this.mixedStream.getThermoSystem().getPhase(0).getNumberOfMolesInPhase() / this.kwater;
        this.absorptionEfficiency = (Math.pow(A, this.getNumberOfTheoreticalStages() + 1.0) - A) / (Math.pow(A, this.getNumberOfTheoreticalStages() + 1.0) - 1.0);
        return this.absorptionEfficiency;
    }

    public double calcY0() {
        double fugCoefRef = this.mixedStream.getThermoSystem().getPhase(1).getComponent("water").getFugacityCoefficient();
        double y0 = this.solventInStream.getFluid().getPhase(0).getComponent("water").getx() * fugCoefRef / this.mixedStream.getThermoSystem().getPhase(0).getComponent("water").getFugacityCoefficient();
        return y0;
    }

    public double calcNumberOfTheoreticalStages() {
        this.setNumberOfTheoreticalStages(this.getStageEfficiency() * (double)this.getNumberOfStages());
        return this.getNumberOfTheoreticalStages();
    }

    public double calcNTU(double y0, double y1, double yb, double ymix) {
        double NTU = Math.log((yb - ymix) / (y1 - y0));
        return NTU;
    }

    @Override
    public void run() {
        try {
            double y0 = 0.0;
            double y1 = 0.0;
            double absorptionEffiency = 0.0;
            this.mixedStream.setThermoSystem(this.streams.get(0).getThermoSystem().clone());
            this.mixedStream.getThermoSystem().setNumberOfPhases(2);
            this.mixedStream.getThermoSystem().reInitPhaseType();
            this.mixedStream.getThermoSystem().init(0);
            this.mixStream();
            double enthalpy = this.calcMixStreamEnthalpy();
            this.mixedStream.getThermoSystem().setTemperature(this.guessTemperature());
            ThermodynamicOperations testOps = new ThermodynamicOperations(this.mixedStream.getThermoSystem());
            testOps.TPflash();
            testOps.PHflash(enthalpy, 0);
            this.kwater = this.mixedStream.getThermoSystem().getPhase(0).getComponent("water").getx() / this.mixedStream.getThermoSystem().getPhase(1).getComponent("water").getx();
            this.calcNumberOfTheoreticalStages();
            absorptionEffiency = this.calcEa();
            y0 = this.calcY0();
            y1 = this.gasInStream.getThermoSystem().getPhase(0).getComponent("water").getx() - absorptionEffiency * (this.gasInStream.getThermoSystem().getPhase(0).getComponent("water").getx() - y0);
            double yMean = this.mixedStream.getThermoSystem().getPhase(0).getComponent("water").getx();
            double molesWaterToMove = (yMean - y1) * this.mixedStream.getThermoSystem().getPhase(0).getNumberOfMolesInPhase();
            Stream stream = this.mixedStream.clone();
            stream.setName("test");
            stream.getThermoSystem().addComponent("water", -molesWaterToMove, 0);
            stream.getThermoSystem().addComponent("water", molesWaterToMove, 1);
            stream.getThermoSystem().initBeta();
            stream.getThermoSystem().init_x_y();
            stream.getThermoSystem().init(2);
            this.mixedStream = stream;
            SystemInterface tempSystem = this.mixedStream.getThermoSystem().clone();
            SystemInterface gasTemp = tempSystem.phaseToSystem(tempSystem.getPhases()[0]);
            gasTemp.init(2);
            this.gasOutStream.setThermoSystem(gasTemp);
            tempSystem = this.mixedStream.getThermoSystem().clone();
            SystemInterface liqTemp = tempSystem.phaseToSystem(tempSystem.getPhases()[1]);
            liqTemp.init(2);
            this.solventOutStream.setThermoSystem(liqTemp);
            this.setNTU(this.calcNTU(y0, y1, this.gasInStream.getThermoSystem().getPhase(0).getComponent("water").getx(), yMean));
            this.getSolventOutStream().getThermoSystem().initPhysicalProperties();
            this.getGasOutStream().getThermoSystem().initPhysicalProperties();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public double getGasLoadFactor() {
        double intArea = 3.14 * this.getInternalDiameter() * this.getInternalDiameter() / 4.0;
        double vs = this.getGasOutStream().getThermoSystem().getFlowRate("m3/sec") / intArea;
        return vs / Math.sqrt((this.getSolventOutStream().getThermoSystem().getPhase(0).getPhysicalProperties().getDensity() - this.getGasOutStream().getThermoSystem().getPhase(0).getPhysicalProperties().getDensity()) / this.getSolventOutStream().getThermoSystem().getPhase(0).getPhysicalProperties().getDensity());
    }

    @Override
    public void displayResult() {
        SystemInterface thermoSystem = this.mixedStream.getThermoSystem();
        DecimalFormat nf = new DecimalFormat();
        nf.setMaximumFractionDigits(5);
        nf.applyPattern("#.#####E0");
        JDialog dialog = new JDialog((Frame)new JFrame(), "Results from TPflash");
        Container dialogContentPane = dialog.getContentPane();
        dialogContentPane.setLayout(new FlowLayout());
        thermoSystem.initPhysicalProperties();
        Object[][] table = new String[50][5];
        Object[] names = new String[]{"", "Phase 1", "Phase 2", "Phase 3", "Unit"};
        table[0][0] = "";
        table[0][1] = "";
        table[0][2] = "";
        table[0][3] = "";
        StringBuffer buf = new StringBuffer();
        FieldPosition test2 = new FieldPosition(0);
        int i = 0;
        while (i < thermoSystem.getNumberOfPhases()) {
            int j = 0;
            while (j < thermoSystem.getPhases()[0].getNumberOfComponents()) {
                table[j + 1][0] = thermoSystem.getPhases()[0].getComponents()[j].getName();
                buf = new StringBuffer();
                table[j + 1][i + 1] = nf.format(thermoSystem.getPhases()[i].getComponents()[j].getx(), buf, test2).toString();
                table[j + 1][4] = "[-]";
                ++j;
            }
            buf = new StringBuffer();
            table[thermoSystem.getPhases()[0].getNumberOfComponents() + 2][0] = "Density";
            table[thermoSystem.getPhases()[0].getNumberOfComponents() + 2][i + 1] = nf.format(thermoSystem.getPhases()[i].getPhysicalProperties().getDensity(), buf, test2).toString();
            table[thermoSystem.getPhases()[0].getNumberOfComponents() + 2][4] = "[kg/m^3]";
            buf = new StringBuffer();
            table[thermoSystem.getPhases()[0].getNumberOfComponents() + 3][0] = "PhaseFraction";
            table[thermoSystem.getPhases()[0].getNumberOfComponents() + 3][i + 1] = nf.format(thermoSystem.getPhases()[i].getBeta(), buf, test2).toString();
            table[thermoSystem.getPhases()[0].getNumberOfComponents() + 3][4] = "[-]";
            buf = new StringBuffer();
            table[thermoSystem.getPhases()[0].getNumberOfComponents() + 4][0] = "MolarMass";
            table[thermoSystem.getPhases()[0].getNumberOfComponents() + 4][i + 1] = nf.format(thermoSystem.getPhases()[i].getMolarMass() * 1000.0, buf, test2).toString();
            table[thermoSystem.getPhases()[0].getNumberOfComponents() + 4][4] = "[kg/kmol]";
            buf = new StringBuffer();
            table[thermoSystem.getPhases()[0].getNumberOfComponents() + 5][0] = "Cp";
            table[thermoSystem.getPhases()[0].getNumberOfComponents() + 5][i + 1] = nf.format(thermoSystem.getPhases()[i].getCp() / (thermoSystem.getPhases()[i].getNumberOfMolesInPhase() * thermoSystem.getPhases()[i].getMolarMass() * 1000.0), buf, test2).toString();
            table[thermoSystem.getPhases()[0].getNumberOfComponents() + 5][4] = "[kJ/kg*K]";
            buf = new StringBuffer();
            table[thermoSystem.getPhases()[0].getNumberOfComponents() + 7][0] = "Viscosity";
            table[thermoSystem.getPhases()[0].getNumberOfComponents() + 7][i + 1] = nf.format(thermoSystem.getPhases()[i].getPhysicalProperties().getViscosity(), buf, test2).toString();
            table[thermoSystem.getPhases()[0].getNumberOfComponents() + 7][4] = "[kg/m*sec]";
            buf = new StringBuffer();
            table[thermoSystem.getPhases()[0].getNumberOfComponents() + 8][0] = "Conductivity";
            table[thermoSystem.getPhases()[0].getNumberOfComponents() + 8][i + 1] = nf.format(thermoSystem.getPhases()[i].getPhysicalProperties().getConductivity(), buf, test2).toString();
            table[thermoSystem.getPhases()[0].getNumberOfComponents() + 8][4] = "[W/m*K]";
            buf = new StringBuffer();
            table[thermoSystem.getPhases()[0].getNumberOfComponents() + 10][0] = "Pressure";
            table[thermoSystem.getPhases()[0].getNumberOfComponents() + 10][i + 1] = Double.toString(thermoSystem.getPhases()[i].getPressure());
            table[thermoSystem.getPhases()[0].getNumberOfComponents() + 10][4] = "[bar]";
            buf = new StringBuffer();
            table[thermoSystem.getPhases()[0].getNumberOfComponents() + 11][0] = "Temperature";
            table[thermoSystem.getPhases()[0].getNumberOfComponents() + 11][i + 1] = Double.toString(thermoSystem.getPhases()[i].getTemperature());
            table[thermoSystem.getPhases()[0].getNumberOfComponents() + 11][4] = "[K]";
            Double.toString(thermoSystem.getPhases()[i].getTemperature());
            buf = new StringBuffer();
            table[thermoSystem.getPhases()[0].getNumberOfComponents() + 13][0] = "Stream";
            table[thermoSystem.getPhases()[0].getNumberOfComponents() + 13][i + 1] = this.getName();
            table[thermoSystem.getPhases()[0].getNumberOfComponents() + 13][4] = "-";
            ++i;
        }
        JTable Jtab = new JTable(table, names);
        JScrollPane scrollpane = new JScrollPane(Jtab);
        dialogContentPane.add(scrollpane);
        dialog.pack();
        dialog.setVisible(true);
    }

    public void setGasOutStream(Stream gasOutStream) {
        this.gasOutStream = gasOutStream;
    }

    public Stream getSolventOutStream() {
        return this.solventOutStream;
    }

    public void setSolventOutStream(Stream solventOutStream) {
        this.solventOutStream = solventOutStream;
    }

    @Override
    public void runConditionAnalysis(ProcessEquipmentInterface refTEGabsorberloc) {
        double yin = this.getGasInStream().getFluid().getPhase("gas").getComponent("water").getx();
        double yout = this.getGasOutStream().getFluid().getPhase("gas").getComponent("water").getx();
        double y0 = this.calcY0();
        double A = this.mixedStream.getThermoSystem().getPhase(1).getNumberOfMolesInPhase() / this.mixedStream.getThermoSystem().getPhase(0).getNumberOfMolesInPhase() / this.kwater;
        double N = Math.log((A - 1.0) / A * ((yin - y0) / (yout - y0)) + 1.0 / A) / Math.log(A);
        this.setNumberOfTheoreticalStages(N);
    }
}

