/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.mechanicalDesign.pipeline;

import neqsim.processSimulation.mechanicalDesign.MechanicalDesign;
import neqsim.processSimulation.mechanicalDesign.designStandards.MaterialPipeDesignStandard;
import neqsim.processSimulation.mechanicalDesign.designStandards.PipelineDesignStandard;
import neqsim.processSimulation.processEquipment.ProcessEquipmentInterface;
import neqsim.processSimulation.processEquipment.pipeline.AdiabaticPipe;
import neqsim.processSimulation.processEquipment.stream.Stream;
import neqsim.processSimulation.processSystem.ProcessSystem;
import neqsim.thermo.system.SystemSrkEos;

public class PipelineMechanicalDeisgn
extends MechanicalDesign {
    private static final long serialVersionUID = 1000L;
    double innerDiameter = 1.0;
    String designStandardCode = "ANSI/ASME Standard B31.8";

    public PipelineMechanicalDeisgn(ProcessEquipmentInterface equipment) {
        super(equipment);
    }

    @Override
    public void readDesignSpecifications() {
        super.readDesignSpecifications();
        if (this.getDesignStandard().containsKey("material pipe design codes")) {
            ((MaterialPipeDesignStandard)this.getDesignStandard().get("material pipe design codes")).getDesignFactor();
        }
        if (this.getDesignStandard().containsKey("pipeline design codes")) {
            System.out.println("pressure vessel code standard: " + this.getDesignStandard().get("pipeline design codes").getStandardName());
            this.wallThickness = ((PipelineDesignStandard)this.getDesignStandard().get("pipeline design codes")).calcPipelineWallThickness();
        } else {
            System.out.println("no pressure vessel code standard specified......");
        }
    }

    @Override
    public void calcDesign() {
        super.calcDesign();
        if (this.designStandardCode.equals("ANSI/ASME Standard B31.8")) {
            this.wallThickness = ((AdiabaticPipe)this.getProcessEquipment()).getMechanicalDesign().getMaxOperationPressure() * this.innerDiameter / (2.0 * ((AdiabaticPipe)this.getProcessEquipment()).getMechanicalDesign().getMaterialPipeDesignStandard().getDesignFactor() * ((AdiabaticPipe)this.getProcessEquipment()).getMechanicalDesign().getMaterialPipeDesignStandard().getEfactor() * ((AdiabaticPipe)this.getProcessEquipment()).getMechanicalDesign().getMaterialPipeDesignStandard().getTemperatureDeratingFactor() * ((AdiabaticPipe)this.getProcessEquipment()).getMechanicalDesign().getMaterialPipeDesignStandard().getMinimumYeildStrength());
        } else if (this.designStandardCode.equals("ANSI/ASME Standard B31.3")) {
            this.wallThickness = 1.0E-4;
        }
    }

    public static void main(String[] args) {
        SystemSrkEos testSystem = new SystemSrkEos(293.15, 90.0);
        testSystem.addComponent("methane", 600000.0, "kg/hr");
        testSystem.addComponent("ethane", 7000.0, "kg/hr");
        testSystem.addComponent("propane", 12000.0, "kg/hr");
        testSystem.createDatabase(true);
        testSystem.setMultiPhaseCheck(true);
        testSystem.setMixingRule(2);
        Stream stream_1 = new Stream("Stream1", testSystem);
        AdiabaticPipe pipe = new AdiabaticPipe(stream_1);
        pipe.setDiameter(1.0);
        pipe.setLength(1000.0);
        pipe.getMechanicalDesign().setMaxOperationPressure(100.0);
        pipe.getMechanicalDesign().setMaxOperationTemperature(333.155);
        pipe.getMechanicalDesign().setMinOperationPressure(50.0);
        pipe.getMechanicalDesign().setMaxDesignGassVolumeFlow(100.0);
        ProcessSystem operations = new ProcessSystem();
        operations.add(stream_1);
        operations.add(pipe);
        operations.getSystemMechanicalDesign().setCompanySpecificDesignStandards("Statoil");
        operations.getSystemMechanicalDesign().runDesignCalculation();
        operations.getSystemMechanicalDesign().setDesign();
        operations.run();
    }
}

