/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.mechanicalDesign.designStandards;

import java.sql.ResultSet;
import neqsim.processSimulation.mechanicalDesign.MechanicalDesign;
import neqsim.processSimulation.mechanicalDesign.designStandards.DesignStandard;
import neqsim.util.database.NeqSimTechnicalDesignDatabase;

public class GasScrubberDesignStandard
extends DesignStandard {
    private static final long serialVersionUID = 1000L;
    double gasLoadFactor = 0.11;
    double designFactorVolumeFlow = 1.1;
    double lengthGasInletToMeshpad = 550.0;
    double lengthGasInetToHHLL = 550.0;
    double lengthMeshPadToDemistingCyclone = 550.0;

    public GasScrubberDesignStandard(String name, MechanicalDesign equipmentInn) {
        super(name, equipmentInn);
        NeqSimTechnicalDesignDatabase database = new NeqSimTechnicalDesignDatabase();
        ResultSet dataSet = null;
        try {
            try {
                try {
                    dataSet = database.getResultSet("SELECT * FROM technicalrequirements_process WHERE EQUIPMENTTYPE='Gas scrubber' AND Company='" + this.standardName + "'");
                    while (dataSet.next()) {
                        String specName = dataSet.getString("SPECIFICATION");
                        if (specName.equals("GasLoadFactor")) {
                            this.gasLoadFactor = Double.parseDouble(dataSet.getString("MAXVALUE"));
                        }
                        if (specName.equals("FlowDesignFactor")) {
                            this.designFactorVolumeFlow = Double.parseDouble(dataSet.getString("MAXVALUE"));
                        }
                        if (specName.equals("LengthGasInetToHHLL")) {
                            this.designFactorVolumeFlow = Double.parseDouble(dataSet.getString("MINVALUE"));
                        }
                        if (!specName.equals("LengthMeshPadToDemistingCyclone")) continue;
                        this.designFactorVolumeFlow = Double.parseDouble(dataSet.getString("MINVALUE"));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (dataSet != null) {
                        dataSet.close();
                    }
                }
                catch (Exception e2) {
                    System.out.println("error closing database.....GasScrubberDesignStandard");
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (dataSet != null) {
                    dataSet.close();
                }
            }
            catch (Exception e) {
                System.out.println("error closing database.....GasScrubberDesignStandard");
                e.printStackTrace();
            }
        }
    }

    public double getGasLoadFactor() {
        return this.gasLoadFactor;
    }

    public double getVolumetricDesignFactor() {
        return this.designFactorVolumeFlow;
    }
}

