/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.mechanicalDesign;

import java.io.Serializable;
import java.util.ArrayList;
import neqsim.processSimulation.processEquipment.ProcessEquipmentInterface;
import neqsim.processSimulation.processSystem.ProcessSystem;

public class SystemMechanicalDesign
implements Serializable {
    private static final long serialVersionUID = 1000L;
    ProcessSystem processSystem = null;
    double totalPlotSpace = 0.0;
    double totalVolume = 0.0;
    double totalWeight = 0.0;
    int numberOfModules = 0;

    public SystemMechanicalDesign(ProcessSystem processSystem) {
        this.processSystem = processSystem;
    }

    public void setCompanySpecificDesignStandards(String name) {
        int i = 0;
        while (i < this.processSystem.getUnitOperations().size()) {
            this.processSystem.getUnitOperations().get(i).getMechanicalDesign().setCompanySpecificDesignStandards(name);
            ++i;
        }
    }

    public void runDesignCalculation() {
        ArrayList<String> names = this.processSystem.getAllUnitNames();
        int i = 0;
        while (i < names.size()) {
            try {
                if ((ProcessEquipmentInterface)this.processSystem.getUnit(names.get(i)) != null) {
                    ((ProcessEquipmentInterface)this.processSystem.getUnit(names.get(i))).getMechanicalDesign().calcDesign();
                    this.totalPlotSpace += ((ProcessEquipmentInterface)this.processSystem.getUnit(names.get(i))).getMechanicalDesign().getModuleHeight() * ((ProcessEquipmentInterface)this.processSystem.getUnit(names.get(i))).getMechanicalDesign().getModuleLength();
                    this.totalVolume += ((ProcessEquipmentInterface)this.processSystem.getUnit(names.get(i))).getMechanicalDesign().getVolumeTotal();
                    this.totalWeight += ((ProcessEquipmentInterface)this.processSystem.getUnit(names.get(i))).getMechanicalDesign().getWeightTotal();
                    ++this.numberOfModules;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    public void setDesign() {
        int i = 0;
        while (i < this.processSystem.getUnitOperations().size()) {
            this.processSystem.getUnitOperations().get(i).getMechanicalDesign().setDesign();
            ++i;
        }
    }

    public double getTotalPlotSpace() {
        return this.totalPlotSpace;
    }

    public double getTotalVolume() {
        return this.totalVolume;
    }

    public double getTotalWeight() {
        return this.totalWeight;
    }

    public int getTotalNumberOfModules() {
        return this.numberOfModules;
    }
}

