/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.costEstimation;

import java.io.Serializable;
import java.util.ArrayList;
import neqsim.processSimulation.processEquipment.ProcessEquipmentInterface;
import neqsim.processSimulation.processSystem.ProcessSystem;

public class CostEstimateBaseClass
implements Serializable {
    private static final long serialVersionUID = 1000L;
    ProcessSystem procesSystem = null;
    private double CAPEXperWeight = 1000.0;

    public CostEstimateBaseClass() {
    }

    public CostEstimateBaseClass(ProcessSystem procesSystem) {
        this.procesSystem = procesSystem;
    }

    public double getWeightBasedCAPEXEstimate() {
        return this.procesSystem.getSystemMechanicalDesign().getTotalWeight() * this.CAPEXperWeight;
    }

    public double getCAPEXestimate() {
        double cost = 0.0;
        ArrayList<String> names = this.procesSystem.getAllUnitNames();
        int i = 0;
        while (i < names.size()) {
            try {
                if ((ProcessEquipmentInterface)this.procesSystem.getUnit(names.get(i)) != null) {
                    cost += ((ProcessEquipmentInterface)this.procesSystem.getUnit(names.get(i))).getMechanicalDesign().getCostEstimate().getTotaltCost();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        return cost;
    }

    public double getCAPEXperWeight() {
        return this.CAPEXperWeight;
    }
}

