/*
 * Decompiled with CFR 0.152.
 */
package neqsim.physicalProperties.physicalPropertyMethods.solidPhysicalProperties.density;

import neqsim.physicalProperties.physicalPropertyMethods.methodInterface.DensityInterface;
import neqsim.physicalProperties.physicalPropertyMethods.solidPhysicalProperties.SolidPhysicalPropertyMethod;
import neqsim.physicalProperties.physicalPropertySystem.PhysicalPropertiesInterface;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Density
extends SolidPhysicalPropertyMethod
implements DensityInterface {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(Density.class);

    public Density() {
    }

    public Density(PhysicalPropertiesInterface liquidPhase) {
        this.solidPhase = liquidPhase;
    }

    @Override
    public Density clone() {
        Density properties = null;
        try {
            properties = (Density)super.clone();
        }
        catch (Exception e) {
            logger.error("Cloning failed.", (Throwable)e);
        }
        return properties;
    }

    @Override
    public double calcDensity() {
        double tempVar = 0.0;
        if (this.solidPhase.getPhase().useVolumeCorrection()) {
            int i = 0;
            while (i < this.solidPhase.getPhase().getNumberOfComponents()) {
                tempVar += this.solidPhase.getPhase().getComponents()[i].getx() * (this.solidPhase.getPhase().getComponents()[i].getVolumeCorrection() + this.solidPhase.getPhase().getComponents()[i].getVolumeCorrectionT() * (this.solidPhase.getPhase().getTemperature() - 288.15));
                ++i;
            }
        }
        return 1.0 / (this.solidPhase.getPhase().getMolarVolume() - tempVar) * this.solidPhase.getPhase().getMolarMass() * 100000.0;
    }
}

