/*
 * Decompiled with CFR 0.152.
 */
package neqsim.physicalProperties.physicalPropertyMethods.gasPhysicalProperties.viscosity;

import neqsim.physicalProperties.physicalPropertyMethods.gasPhysicalProperties.viscosity.Viscosity;
import neqsim.physicalProperties.physicalPropertySystem.PhysicalPropertiesInterface;

public class ChungViscosityMethod
extends Viscosity {
    private static final long serialVersionUID = 1000L;
    public double[] pureComponentViscosity;
    public double[] relativeViscosity;
    public double[] Fc;
    public double[] omegaVisc;
    protected double[] chungE = new double[10];
    protected double[][] chungHPcoefs = new double[][]{{6.324, 50.412, -51.68, 1189.0}, {0.00121, -0.001154, -0.006257, 0.03728}, {5.283, 254.209, -168.48, 3898.0}, {6.623, 38.096, -8.464, 31.42}, {19.745, 7.63, -14.354, 31.53}, {-1.9, -12.537, 4.985, -18.15}, {24.275, 3.45, -11.291, 69.35}, {0.7972, 1.117, 0.01235, -4.117}, {-0.2382, 0.0677, -0.8163, 4.025}, {0.06863, 0.3479, 0.5926, -0.727}};

    public ChungViscosityMethod() {
    }

    public ChungViscosityMethod(PhysicalPropertiesInterface gasPhase) {
        super(gasPhase);
        this.pureComponentViscosity = new double[gasPhase.getPhase().getNumberOfComponents()];
        this.relativeViscosity = new double[gasPhase.getPhase().getNumberOfComponents()];
        this.Fc = new double[gasPhase.getPhase().getNumberOfComponents()];
        this.omegaVisc = new double[gasPhase.getPhase().getNumberOfComponents()];
    }

    @Override
    public double calcViscosity() {
        this.initChungPureComponentViscosity();
        double tempVar = 0.0;
        double tempVar2 = 0.0;
        double viscosity = 0.0;
        int i = 0;
        while (i < this.gasPhase.getPhase().getNumberOfComponents()) {
            tempVar = 0.0;
            int j = 0;
            while (j < this.gasPhase.getPhase().getNumberOfComponents()) {
                tempVar2 = Math.pow(1.0 + Math.sqrt(this.pureComponentViscosity[i] / this.pureComponentViscosity[j]) * Math.pow(this.gasPhase.getPhase().getComponents()[j].getMolarMass() / this.gasPhase.getPhase().getComponents()[i].getMolarMass(), 0.25), 2.0) / Math.pow(8.0 * (1.0 + this.gasPhase.getPhase().getComponents()[i].getMolarMass() / this.gasPhase.getPhase().getComponents()[j].getMolarMass()), 0.5);
                tempVar += this.gasPhase.getPhase().getComponents()[j].getx() * tempVar2;
                ++j;
            }
            viscosity += this.gasPhase.getPhase().getComponents()[i].getx() * this.pureComponentViscosity[i] / tempVar;
            ++i;
        }
        return viscosity *= 1.0E-7;
    }

    @Override
    public double getPureComponentViscosity(int i) {
        return this.pureComponentViscosity[i];
    }

    public void initChungPureComponentViscosity() {
        double tempVar = 0.0;
        double A = 1.16145;
        double B = 0.14874;
        double C = 0.52487;
        double D = 0.7732;
        double E = 2.16178;
        double F = 2.43787;
        double A2 = 1.06036;
        double B2 = 0.1561;
        double C2 = 0.193;
        double D2 = 0.47635;
        double E2 = 1.03587;
        double F2 = 1.52996;
        double G2 = 1.76474;
        double H2 = 3.89411;
        double chungy = 0.0;
        double chungG1 = 0.0;
        double chungG2 = 0.0;
        double chungviskstartstar = 0.0;
        double chungviskstar = 0.0;
        int i = 0;
        while (i < this.gasPhase.getPhase().getNumberOfComponents()) {
            this.relativeViscosity[i] = 131.3 * this.gasPhase.getPhase().getComponents()[i].getDebyeDipoleMoment() / Math.sqrt(this.gasPhase.getPhase().getComponents()[i].getCriticalVolume() * this.gasPhase.getPhase().getComponents()[i].getTC());
            this.Fc[i] = 1.0 - 0.2756 * this.gasPhase.getPhase().getComponents()[i].getAcentricFactor() + 0.059035 * Math.pow(this.relativeViscosity[i], 4.0) + this.gasPhase.getPhase().getComponents()[i].getViscosityCorrectionFactor();
            int j = 0;
            while (j < 10) {
                this.chungE[j] = this.chungHPcoefs[j][0] + this.chungHPcoefs[j][1] * this.gasPhase.getPhase().getComponents()[i].getAcentricFactor() + this.chungHPcoefs[j][2] * Math.pow(this.relativeViscosity[i], 4.0) + this.chungHPcoefs[j][3] * this.gasPhase.getPhase().getComponents()[i].getViscosityCorrectionFactor();
                ++j;
            }
            tempVar = 1.2593 * this.gasPhase.getPhase().getTemperature() / this.gasPhase.getPhase().getComponents()[i].getTC();
            this.omegaVisc[i] = A * Math.pow(tempVar, -B) + C * Math.exp(-D * tempVar) + E * Math.exp(-F * tempVar);
            chungy = 0.1 / this.gasPhase.getPhase().getMolarVolume() * this.gasPhase.getPhase().getComponents()[i].getCriticalVolume() / 6.0;
            chungG1 = (1.0 - 0.5 * chungy) / Math.pow(1.0 - chungy, 3.0);
            chungG2 = (this.chungE[0] * ((1.0 - Math.exp(-this.chungE[3] * chungy)) / chungy) + this.chungE[1] * chungG1 * Math.exp(this.chungE[4] * chungy) + this.chungE[2] * chungG1) / (this.chungE[0] * this.chungE[3] + this.chungE[1] + this.chungE[2]);
            chungviskstartstar = this.chungE[6] * chungy * chungy * chungG2 * Math.exp(this.chungE[7] + this.chungE[8] / tempVar + this.chungE[9] * Math.pow(tempVar, -2.0));
            chungviskstar = Math.sqrt(tempVar) / this.omegaVisc[i] * (this.Fc[i] * (1.0 / chungG2 + this.chungE[5] * chungy)) + chungviskstartstar;
            this.pureComponentViscosity[i] = chungviskstar * 36.344 * Math.pow(this.gasPhase.getPhase().getComponents()[i].getMolarMass() * 1000.0 * this.gasPhase.getPhase().getComponents()[i].getTC(), 0.5) / Math.pow(this.gasPhase.getPhase().getPhase().getComponents()[i].getCriticalVolume(), 0.6666666666666666);
            ++i;
        }
    }
}

