/*
 * Decompiled with CFR 0.152.
 */
package neqsim.physicalProperties.physicalPropertyMethods.gasPhysicalProperties;

import neqsim.physicalProperties.physicalPropertyMethods.PhysicalPropertyMethod;
import neqsim.physicalProperties.physicalPropertySystem.PhysicalPropertiesInterface;

public class GasPhysicalPropertyMethod
extends PhysicalPropertyMethod {
    private static final long serialVersionUID = 1000L;
    protected PhysicalPropertiesInterface gasPhase;
    public double[][] binaryMolecularDiameter;
    public double[][] binaryEnergyParameter;
    public double[][] binaryMolecularMass;

    public GasPhysicalPropertyMethod() {
    }

    public GasPhysicalPropertyMethod(PhysicalPropertiesInterface gasPhase) {
        this.gasPhase = gasPhase;
        this.binaryMolecularDiameter = new double[gasPhase.getPhase().getNumberOfComponents()][gasPhase.getPhase().getNumberOfComponents()];
        this.binaryMolecularMass = new double[gasPhase.getPhase().getNumberOfComponents()][gasPhase.getPhase().getNumberOfComponents()];
        this.binaryEnergyParameter = new double[gasPhase.getPhase().getNumberOfComponents()][gasPhase.getPhase().getNumberOfComponents()];
        int i = 0;
        while (i < gasPhase.getPhase().getNumberOfComponents()) {
            int j = 0;
            while (j < gasPhase.getPhase().getNumberOfComponents()) {
                this.binaryMolecularMass[i][j] = 2.0 * Math.pow(1.0 / gasPhase.getPhase().getComponents()[i].getMolarMass() / 1000.0 + 1.0 / gasPhase.getPhase().getComponents()[j].getMolarMass() / 1000.0, -1.0);
                this.binaryMolecularDiameter[i][j] = (gasPhase.getPhase().getComponents()[i].getLennardJonesMolecularDiameter() + gasPhase.getPhase().getComponents()[j].getLennardJonesMolecularDiameter()) / 2.0;
                this.binaryEnergyParameter[i][j] = Math.pow(gasPhase.getPhase().getComponents()[i].getLennardJonesEnergyParameter() * gasPhase.getPhase().getComponents()[j].getLennardJonesEnergyParameter(), 0.5);
                ++j;
            }
            ++i;
        }
    }

    @Override
    public void setPhase(PhysicalPropertiesInterface phase) {
        this.gasPhase = phase;
    }
}

