/*
 * Decompiled with CFR 0.152.
 */
package neqsim.physicalProperties.physicalPropertyMethods.commonPhasePhysicalProperties.viscosity;

import neqsim.physicalProperties.physicalPropertyMethods.commonPhasePhysicalProperties.viscosity.Viscosity;
import neqsim.physicalProperties.physicalPropertySystem.PhysicalPropertiesInterface;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LBCViscosityMethod
extends Viscosity {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(LBCViscosityMethod.class);
    double[] a = new double[]{0.1023, 0.023364, 0.058533, -0.040758, 0.0093324};

    public LBCViscosityMethod() {
    }

    public LBCViscosityMethod(PhysicalPropertiesInterface phase) {
        super(phase);
    }

    @Override
    public double calcViscosity() {
        double viscosity = 0.0;
        double lowPresVisc = 0.0;
        double temp = 0.0;
        double temp2 = 0.0;
        double temp3 = 0.0;
        double temp4 = 0.0;
        double eps = 0.0;
        double critDens = 0.0;
        double par1 = 0.0;
        double par2 = 0.0;
        double par3 = 0.0;
        double par4 = 0.0;
        int i = 0;
        while (i < this.phase.getPhase().getNumberOfComponents()) {
            par1 += this.phase.getPhase().getComponent(i).getx() * this.phase.getPhase().getComponent(i).getTC();
            par2 += this.phase.getPhase().getComponent(i).getx() * this.phase.getPhase().getComponent(i).getMolarMass() * 1000.0;
            par3 += this.phase.getPhase().getComponent(i).getx() * this.phase.getPhase().getComponent(i).getPC();
            par4 += this.phase.getPhase().getComponent(i).getx() * this.phase.getPhase().getComponent(i).getCriticalVolume();
            double TR = this.phase.getPhase().getTemperature() / this.phase.getPhase().getComponent(i).getTC();
            temp2 = Math.pow(this.phase.getPhase().getComponent(i).getTC(), 0.16666666666666666) / (Math.pow(this.phase.getPhase().getComponent(i).getMolarMass() * 1000.0, 0.5) * Math.pow(this.phase.getPhase().getComponent(i).getPC(), 0.6666666666666666));
            temp = TR < 1.5 ? 3.4E-4 / temp2 * Math.pow(TR, 0.94) : 1.778E-4 / temp2 * Math.pow(4.58 * TR - 1.67, 0.625);
            temp3 += this.phase.getPhase().getComponent(i).getx() * temp * Math.pow(this.phase.getPhase().getComponent(i).getMolarMass() * 1000.0, 0.5);
            temp4 += this.phase.getPhase().getComponent(i).getx() * Math.pow(this.phase.getPhase().getComponent(i).getMolarMass() * 1000.0, 0.5);
            ++i;
        }
        lowPresVisc = temp3 / temp4;
        critDens = 1.0 / par4;
        eps = Math.pow(par1, 0.16666666666666666) * Math.pow(par2, -0.5) * Math.pow(par3, -0.6666666666666666);
        double reducedDensity = this.phase.getPhase().getPhysicalProperties().getDensity() / this.phase.getPhase().getMolarMass() / critDens / 1000000.0;
        double numb = this.a[0] + this.a[1] * reducedDensity + this.a[2] * Math.pow(reducedDensity, 2.0) + this.a[3] * Math.pow(reducedDensity, 3.0) + this.a[4] * Math.pow(reducedDensity, 4.0);
        viscosity = (-Math.pow(10.0, -4.0) + Math.pow(numb, 4.0)) / eps + lowPresVisc;
        return viscosity /= 1000.0;
    }

    @Override
    public double getPureComponentViscosity(int i) {
        return 0.0;
    }
}

