/*
 * Decompiled with CFR 0.152.
 */
package neqsim.physicalProperties.interfaceProperties;

import java.io.Serializable;
import neqsim.physicalProperties.interfaceProperties.InterphasePropertiesInterface;
import neqsim.physicalProperties.interfaceProperties.solidAdsorption.AdsorptionInterface;
import neqsim.physicalProperties.interfaceProperties.solidAdsorption.PotentialTheoryAdsorption;
import neqsim.physicalProperties.interfaceProperties.surfaceTension.FirozabadiRamleyInterfaceTension;
import neqsim.physicalProperties.interfaceProperties.surfaceTension.GTSurfaceTension;
import neqsim.physicalProperties.interfaceProperties.surfaceTension.GTSurfaceTensionSimple;
import neqsim.physicalProperties.interfaceProperties.surfaceTension.LGTSurfaceTension;
import neqsim.physicalProperties.interfaceProperties.surfaceTension.ParachorSurfaceTension;
import neqsim.physicalProperties.interfaceProperties.surfaceTension.SurfaceTension;
import neqsim.physicalProperties.interfaceProperties.surfaceTension.SurfaceTensionInterface;
import neqsim.thermo.system.SystemInterface;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InterfaceProperties
implements InterphasePropertiesInterface,
Serializable {
    private static final long serialVersionUID = 1000L;
    SystemInterface system;
    SurfaceTensionInterface gasLiquidSurfaceTensionCalc = null;
    SurfaceTensionInterface gasAqueousSurfaceTensionCalc = null;
    SurfaceTensionInterface liquidLiquidSurfaceTensionCalc = null;
    private AdsorptionInterface[] adsorptionCalc;
    double[] surfaceTension;
    int numberOfInterfaces = 1;
    private int interfacialTensionModel = 0;
    static Logger logger = LogManager.getLogger(InterfaceProperties.class);

    public InterfaceProperties() {
    }

    public InterfaceProperties(SystemInterface system) {
        this.numberOfInterfaces = system.getNumberOfPhases() - 1;
        this.system = system;
    }

    @Override
    public InterfaceProperties clone() {
        InterfaceProperties clonedSystem = null;
        return clonedSystem;
    }

    @Override
    public void init(SystemInterface system) {
        this.system = system;
        this.init();
    }

    @Override
    public void init() {
        this.numberOfInterfaces = this.system.getNumberOfPhases() - 1;
        this.surfaceTension = new double[this.numberOfInterfaces + 1];
        if (this.gasLiquidSurfaceTensionCalc == null || this.gasAqueousSurfaceTensionCalc == null || this.liquidLiquidSurfaceTensionCalc == null) {
            this.setInterfacialTensionModel(this.interfacialTensionModel);
        }
    }

    @Override
    public void initAdsorption() {
        this.setAdsorptionCalc(new AdsorptionInterface[this.system.getNumberOfPhases()]);
        int i = 0;
        while (i < this.system.getNumberOfPhases()) {
            this.getAdsorptionCalc()[i] = new PotentialTheoryAdsorption(this.system);
            ++i;
        }
    }

    @Override
    public void setSolidAdsorbentMaterial(String material) {
        int i = 0;
        while (i < this.system.getNumberOfPhases()) {
            this.getAdsorptionCalc()[i].setSolidMaterial(material);
            ++i;
        }
    }

    @Override
    public void calcAdsorption() {
        int i = 0;
        while (i < this.system.getNumberOfPhases()) {
            this.getAdsorptionCalc()[i].calcAdorption(i);
            ++i;
        }
    }

    @Override
    public double getSurfaceTension(int numb1, int numb2) {
        if (this.system.getPhase(numb1).getPhaseTypeName().equals("gas") && this.system.getPhase(numb2).getPhaseTypeName().equals("oil")) {
            return this.gasLiquidSurfaceTensionCalc.calcSurfaceTension(numb1, numb2);
        }
        if (this.system.getPhase(numb1).getPhaseTypeName().equals("gas") && this.system.getPhase(numb2).getPhaseTypeName().equals("aqueous")) {
            return this.gasAqueousSurfaceTensionCalc.calcSurfaceTension(numb1, numb2);
        }
        return this.liquidLiquidSurfaceTensionCalc.calcSurfaceTension(numb1, numb2);
    }

    @Override
    public double getSurfaceTension(int numb1, int numb2, String unit) {
        double val = this.getSurfaceTension(numb1, numb2);
        return val;
    }

    @Override
    public SurfaceTensionInterface getSurfaceTensionModel(int i) {
        if (this.system.getPhase(i).getPhaseTypeName().equals("gas")) {
            return this.gasLiquidSurfaceTensionCalc;
        }
        return this.gasLiquidSurfaceTensionCalc;
    }

    @Override
    public int getInterfacialTensionModel() {
        return this.interfacialTensionModel;
    }

    @Override
    public void setInterfacialTensionModel(String phase1, String phase2, String model) {
        SurfaceTension surfTensModel = null;
        surfTensModel = "Linear Gradient Theory".equals(model) ? new LGTSurfaceTension(this.system) : ("Simple Gradient Theory".equals(model) ? new GTSurfaceTensionSimple(this.system) : ("Full Gradient Theory".equals(model) ? new GTSurfaceTension(this.system) : ("Firozabadi Ramley".equals(model) ? new FirozabadiRamleyInterfaceTension(this.system) : ("Parachor".equals(model) || "Weinaug-Katz".equals(model) ? new ParachorSurfaceTension(this.system) : new ParachorSurfaceTension(this.system)))));
        if (phase1.equals("gas") && phase2.equals("oil")) {
            this.gasLiquidSurfaceTensionCalc = surfTensModel;
        } else if (phase1.equals("gas") && phase2.equals("aqueous")) {
            this.gasAqueousSurfaceTensionCalc = surfTensModel;
        } else if (phase1.equals("oil") && phase2.equals("aqueous")) {
            this.liquidLiquidSurfaceTensionCalc = surfTensModel;
        }
    }

    @Override
    public void setInterfacialTensionModel(int interfacialTensionModel) {
        this.interfacialTensionModel = interfacialTensionModel;
        if (interfacialTensionModel == 0) {
            this.gasLiquidSurfaceTensionCalc = new ParachorSurfaceTension(this.system);
            this.gasAqueousSurfaceTensionCalc = new ParachorSurfaceTension(this.system);
            this.liquidLiquidSurfaceTensionCalc = new FirozabadiRamleyInterfaceTension(this.system);
        } else if (interfacialTensionModel == 1) {
            this.gasLiquidSurfaceTensionCalc = new GTSurfaceTension(this.system);
            this.gasAqueousSurfaceTensionCalc = new GTSurfaceTensionSimple(this.system);
            this.liquidLiquidSurfaceTensionCalc = new GTSurfaceTensionSimple(this.system);
        } else if (interfacialTensionModel == 2) {
            this.gasLiquidSurfaceTensionCalc = new LGTSurfaceTension(this.system);
            this.liquidLiquidSurfaceTensionCalc = new LGTSurfaceTension(this.system);
            this.gasAqueousSurfaceTensionCalc = new LGTSurfaceTension(this.system);
        } else if (interfacialTensionModel == 3) {
            this.gasLiquidSurfaceTensionCalc = new ParachorSurfaceTension(this.system);
            this.gasAqueousSurfaceTensionCalc = new ParachorSurfaceTension(this.system);
            this.liquidLiquidSurfaceTensionCalc = new FirozabadiRamleyInterfaceTension(this.system);
        } else if (interfacialTensionModel == 4) {
            this.gasLiquidSurfaceTensionCalc = new GTSurfaceTensionSimple(this.system);
            this.liquidLiquidSurfaceTensionCalc = new LGTSurfaceTension(this.system);
            this.gasAqueousSurfaceTensionCalc = new ParachorSurfaceTension(this.system);
        } else if (interfacialTensionModel == 5) {
            this.gasLiquidSurfaceTensionCalc = new ParachorSurfaceTension(this.system);
            this.gasAqueousSurfaceTensionCalc = new ParachorSurfaceTension(this.system);
            this.liquidLiquidSurfaceTensionCalc = new FirozabadiRamleyInterfaceTension(this.system);
        } else {
            this.gasLiquidSurfaceTensionCalc = new ParachorSurfaceTension(this.system);
            this.gasAqueousSurfaceTensionCalc = new ParachorSurfaceTension(this.system);
            this.liquidLiquidSurfaceTensionCalc = new ParachorSurfaceTension(this.system);
        }
    }

    @Override
    public AdsorptionInterface[] getAdsorptionCalc() {
        return this.adsorptionCalc;
    }

    @Override
    public AdsorptionInterface getAdsorptionCalc(String phaseName) {
        return this.adsorptionCalc[this.system.getPhaseNumberOfPhase(phaseName)];
    }

    @Override
    public void setAdsorptionCalc(AdsorptionInterface[] adsorptionCalc) {
        this.adsorptionCalc = adsorptionCalc;
    }
}

