/*
 * Decompiled with CFR 0.152.
 */
package neqsim.fluidMechanics.util.fluidMechanicsVisualization.flowSystemVisualization;

import neqsim.fluidMechanics.flowSystem.FlowSystemInterface;
import neqsim.fluidMechanics.util.fluidMechanicsVisualization.flowNodeVisualization.FlowNodeVisualization;
import neqsim.fluidMechanics.util.fluidMechanicsVisualization.flowNodeVisualization.FlowNodeVisualizationInterface;
import neqsim.fluidMechanics.util.fluidMechanicsVisualization.flowSystemVisualization.FlowSystemVisualizationInterface;

public class FlowSystemVisualization
implements FlowSystemVisualizationInterface {
    protected FlowNodeVisualizationInterface[][] flowNodes;
    protected FlowSystemInterface[] flowSystem;
    protected int time = 0;
    protected double[] absTime;

    public FlowSystemVisualization() {
    }

    public FlowSystemVisualization(int nodes, int timeSteps) {
        this.flowNodes = new FlowNodeVisualization[timeSteps][nodes];
        this.flowSystem = new FlowSystemInterface[timeSteps];
        this.absTime = new double[timeSteps];
        int i = 0;
        while (i < timeSteps) {
            int j = 0;
            while (j < nodes) {
                this.flowNodes[i][j] = new FlowNodeVisualization();
                ++j;
            }
            ++i;
        }
    }

    @Override
    public void setNextData(FlowSystemInterface system) {
        this.flowSystem[this.time] = system;
        this.absTime[this.time] = 0.0;
        int i = 0;
        while (i < this.flowNodes[this.time].length) {
            this.flowNodes[this.time][i].setData(system.getNode(i));
            ++i;
        }
        ++this.time;
    }

    @Override
    public void setNextData(FlowSystemInterface system, double abstime) {
        this.flowSystem[this.time] = system;
        this.absTime[this.time] = abstime;
        int i = 0;
        while (i < this.flowNodes[this.time].length) {
            this.flowNodes[this.time][i].setData(system.getNode(i));
            ++i;
        }
        ++this.time;
    }

    @Override
    public void createNetCdfFile(String name) {
        System.out.println("ok...");
        int j = 0;
        while (j < this.time) {
            int i = 0;
            while (i < this.flowNodes[j].length) {
                System.out.println("time " + this.time + " pres " + this.flowNodes[j][i].getPressure(0));
                ++i;
            }
            ++j;
        }
    }

    @Override
    public void setPoints() {
    }

    @Override
    public void displayResult(String name) {
    }
}

