/*
 * Decompiled with CFR 0.152.
 */
package neqsim.fluidMechanics.flowNode.twoPhaseNode.twoPhaseReactorFlowNode;

import neqsim.fluidMechanics.flowNode.FlowNodeInterface;
import neqsim.fluidMechanics.flowNode.fluidBoundary.heatMassTransferCalc.nonEquilibriumFluidBoundary.filmModelBoundary.KrishnaStandartFilmModel;
import neqsim.fluidMechanics.flowNode.fluidBoundary.interphaseTransportCoefficient.interphaseTwoPhase.interphasePipeFlow.InterphaseStratifiedFlow;
import neqsim.fluidMechanics.flowNode.twoPhaseNode.TwoPhaseFlowNode;
import neqsim.fluidMechanics.geometryDefinitions.GeometryDefinitionInterface;
import neqsim.fluidMechanics.geometryDefinitions.pipe.PipeData;
import neqsim.thermo.system.SystemFurstElectrolyteEos;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.ThermodynamicOperations;

public class TwoPhaseTrayTowerFlowNode
extends TwoPhaseFlowNode {
    private static final long serialVersionUID = 1000L;

    public TwoPhaseTrayTowerFlowNode() {
        this.flowNodeType = "stratified";
    }

    public TwoPhaseTrayTowerFlowNode(SystemInterface system, GeometryDefinitionInterface pipe) {
        super(system, pipe);
        this.flowNodeType = "stratified";
        this.interphaseTransportCoefficient = new InterphaseStratifiedFlow(this);
        this.fluidBoundary = new KrishnaStandartFilmModel(this);
    }

    public TwoPhaseTrayTowerFlowNode(SystemInterface system, SystemInterface interphaseSystem, GeometryDefinitionInterface pipe) {
        super(system, pipe);
        this.flowNodeType = "stratified";
        this.interphaseTransportCoefficient = new InterphaseStratifiedFlow(this);
        this.fluidBoundary = new KrishnaStandartFilmModel(this);
    }

    @Override
    public TwoPhaseTrayTowerFlowNode clone() {
        TwoPhaseTrayTowerFlowNode clonedSystem = null;
        try {
            clonedSystem = (TwoPhaseTrayTowerFlowNode)super.clone();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return clonedSystem;
    }

    @Override
    public void init() {
        this.inclination = 0.0;
        this.calcContactLength();
        super.init();
    }

    @Override
    public double calcContactLength() {
        double phaseAngel = 3.14159265 * this.phaseFraction[1] + Math.pow(4.7123889750000005, 0.3333333333333333) * (1.0 - 2.0 * this.phaseFraction[1] + Math.pow(this.phaseFraction[1], 0.3333333333333333) - Math.pow(this.phaseFraction[0], 0.3333333333333333));
        this.wallContactLength[1] = phaseAngel * this.pipe.getDiameter();
        this.wallContactLength[0] = 3.14159265 * this.pipe.getDiameter() - this.wallContactLength[1];
        this.interphaseContactLength[0] = this.pipe.getDiameter() * Math.sin(phaseAngel);
        this.interphaseContactLength[1] = this.pipe.getDiameter() * Math.sin(phaseAngel);
        return this.wallContactLength[0];
    }

    @Override
    public FlowNodeInterface getNextNode() {
        TwoPhaseTrayTowerFlowNode newNode = this.clone();
        int i = 0;
        while (i < this.getBulkSystem().getPhases()[0].getNumberOfComponents()) {
            ++i;
        }
        return newNode;
    }

    public static void main(String[] args) {
        SystemFurstElectrolyteEos testSystem = new SystemFurstElectrolyteEos(275.3, 1.01325);
        ThermodynamicOperations testOps = new ThermodynamicOperations(testSystem);
        PipeData pipe1 = new PipeData(10.0, 0.025);
        testSystem.addComponent("methane", 0.061152181, 0);
        testSystem.addComponent("water", 0.1862204876, 1);
        testSystem.setMixingRule(2);
        testSystem.init_x_y();
        TwoPhaseTrayTowerFlowNode test2 = new TwoPhaseTrayTowerFlowNode(testSystem, pipe1);
        test2.setInterphaseModelType(1);
        test2.initFlowCalc();
        test2.calcFluxes();
    }
}

