/*
 * Decompiled with CFR 0.152.
 */
package neqsim.fluidMechanics.flowNode.multiPhaseNode.waxNode;

import neqsim.fluidMechanics.flowNode.FlowNodeInterface;
import neqsim.fluidMechanics.flowNode.fluidBoundary.heatMassTransferCalc.nonEquilibriumFluidBoundary.filmModelBoundary.KrishnaStandartFilmModel;
import neqsim.fluidMechanics.flowNode.fluidBoundary.interphaseTransportCoefficient.interphaseTwoPhase.interphasePipeFlow.InterphaseStratifiedFlow;
import neqsim.fluidMechanics.flowNode.multiPhaseNode.MultiPhaseFlowNode;
import neqsim.fluidMechanics.flowNode.twoPhaseNode.twoPhasePipeFlowNode.StratifiedFlowNode;
import neqsim.fluidMechanics.geometryDefinitions.GeometryDefinitionInterface;
import neqsim.fluidMechanics.geometryDefinitions.pipe.PipeData;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermo.system.SystemSrkEos;
import neqsim.thermodynamicOperations.ThermodynamicOperations;

public class WaxDepositionFlowNode
extends MultiPhaseFlowNode {
    private static final long serialVersionUID = 1000L;

    public WaxDepositionFlowNode() {
        this.flowNodeType = "wax deposition node";
    }

    public WaxDepositionFlowNode(SystemInterface system, GeometryDefinitionInterface pipe) {
        super(system, pipe);
        this.flowNodeType = "wax deposition node";
        this.interphaseTransportCoefficient = new InterphaseStratifiedFlow(this);
        this.fluidBoundary = new KrishnaStandartFilmModel(this);
    }

    public WaxDepositionFlowNode(SystemInterface system, SystemInterface interphaseSystem, GeometryDefinitionInterface pipe) {
        super(system, pipe);
        this.flowNodeType = "wax deposition node";
        this.interphaseTransportCoefficient = new InterphaseStratifiedFlow(this);
        this.fluidBoundary = new KrishnaStandartFilmModel(this);
    }

    @Override
    public StratifiedFlowNode clone() {
        StratifiedFlowNode clonedSystem = null;
        try {
            clonedSystem = (StratifiedFlowNode)super.clone();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return clonedSystem;
    }

    @Override
    public void init() {
        this.inclination = 0.0;
        this.calcContactLength();
        super.init();
    }

    @Override
    public double calcContactLength() {
        double phaseAngel = 3.14159265 * this.phaseFraction[1] + Math.pow(4.7123889750000005, 0.3333333333333333) * (1.0 - 2.0 * this.phaseFraction[1] + Math.pow(this.phaseFraction[1], 0.3333333333333333) - Math.pow(this.phaseFraction[0], 0.3333333333333333));
        this.wallContactLength[1] = phaseAngel * this.pipe.getDiameter();
        this.wallContactLength[0] = 3.14159265 * this.pipe.getDiameter() - this.wallContactLength[1];
        this.interphaseContactLength[0] = this.pipe.getDiameter() * Math.sin(phaseAngel);
        this.interphaseContactLength[1] = this.pipe.getDiameter() * Math.sin(phaseAngel);
        return this.wallContactLength[0];
    }

    @Override
    public FlowNodeInterface getNextNode() {
        StratifiedFlowNode newNode = this.clone();
        int i = 0;
        while (i < this.getBulkSystem().getPhases()[0].getNumberOfComponents()) {
            ++i;
        }
        return newNode;
    }

    public static void main(String[] args) {
        SystemSrkEos testSystem = new SystemSrkEos(313.15, 10.0);
        ThermodynamicOperations testOps = new ThermodynamicOperations(testSystem);
        PipeData pipe1 = new PipeData(0.203, 2.5E-4);
        testSystem.addComponent("methane", 25.0, 0);
        testSystem.addComponent("nC16", 1.5, 1);
        testSystem.createDatabase(true);
        testSystem.setMixingRule(2);
        testSystem.init_x_y();
        testSystem.initBeta();
        testSystem.display();
        StratifiedFlowNode test2 = new StratifiedFlowNode(testSystem, pipe1);
        test2.setInterphaseModelType(1);
        test2.setLengthOfNode(0.005);
        test2.getGeometry().getSurroundingEnvironment().setTemperature(313.15);
        test2.getFluidBoundary().setHeatTransferCalc(true);
        test2.getFluidBoundary().setMassTransferCalc(true);
        test2.initFlowCalc();
        test2.calcFluxes();
        test2.update();
        test2.getInterphaseSystem().display();
        test2.getFluidBoundary().display("");
        test2.getFluidBoundary().getInterphaseSystem().display();
        int i = 0;
        while (i < 5) {
            test2.initFlowCalc();
            test2.calcFluxes();
            test2.update();
            ++i;
        }
        test2.getBulkSystem().display();
    }
}

