/*
 * Decompiled with CFR 0.152.
 */
package neqsim.dataPresentation.visAD.visAd3D;

import java.rmi.RemoteException;
import javax.swing.JFrame;
import neqsim.dataPresentation.visAD.visAdBaseClass;
import visad.Data;
import visad.DataReferenceImpl;
import visad.Display;
import visad.DisplayImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.GraphicsModeControl;
import visad.Linear2DSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.ScalarType;
import visad.Set;
import visad.ThingReference;
import visad.VisADException;
import visad.java3d.DisplayImplJ3D;
import visad.util.ContourWidget;

public class visAd3DPlot
extends visAdBaseClass {
    private static final long serialVersionUID = 1000L;
    private RealType longitude;
    private RealType latitude;
    private RealType temperature;
    private RealType isotemperature;
    private RealTupleType domain_tuple;
    JFrame jframe;
    private FunctionType func_domain_range;
    private FunctionType func_domain_iso_range;
    private Set domain_set;
    private FlatField vals_ff;
    private FlatField iso_vals_ff;
    private DataReferenceImpl data_ref;
    private DataReferenceImpl iso_data_ref;
    private DisplayImpl display;
    private ScalarMap latMap;
    private ScalarMap lonMap;
    private ScalarMap tempIsoMap;
    private ScalarMap tempRGBMap;
    private ScalarMap tempIsoMapIso;
    private ScalarMap tempRGBMap2;
    private ScalarMap tempIsoMap2;
    int NCOLS = 0;
    int NROWS = 0;
    float[][] set_samples;
    double[][] z_samples;
    private ContourWidget contourWid;

    public visAd3DPlot(String firstax, String secax, String zax) throws RemoteException, VisADException {
        this.latitude = RealType.getRealType((String)firstax);
        this.longitude = RealType.getRealType((String)secax);
        this.domain_tuple = new RealTupleType(this.latitude, this.longitude);
        this.temperature = RealType.getRealType((String)zax);
        this.isotemperature = RealType.getRealType((String)"isoTemperature");
        this.func_domain_range = new FunctionType((MathType)this.domain_tuple, (MathType)this.temperature);
        this.func_domain_iso_range = new FunctionType((MathType)this.domain_tuple, (MathType)this.isotemperature);
    }

    public void setXYvals(double xMin, double xMax, int Nrows, double yMin, double yMax, int NCols) throws RemoteException, VisADException {
        this.NCOLS = NCols;
        this.NROWS = Nrows;
        this.domain_set = new Linear2DSet((MathType)this.domain_tuple, xMin, xMax, this.NROWS, yMin, yMax, this.NCOLS);
        this.set_samples = this.domain_set.getSamples(true);
    }

    public void setXYvals(double[] xvals, double[] yvals) throws RemoteException, VisADException {
    }

    public void setZvals(double[][] vals) throws RemoteException, VisADException {
        this.z_samples = vals;
    }

    @Override
    public void init() throws RemoteException, VisADException {
        float[][] flat_samples = new float[1][this.NCOLS * this.NROWS];
        int c = 0;
        while (c < this.NCOLS) {
            int r = 0;
            while (r < this.NROWS) {
                flat_samples[0][c * this.NROWS + r] = (float)this.z_samples[c][r];
                ++r;
            }
            ++c;
        }
        this.vals_ff = new FlatField(this.func_domain_range, this.domain_set);
        this.vals_ff.setSamples(flat_samples, false);
        this.iso_vals_ff = new FlatField(this.func_domain_iso_range, this.domain_set);
        this.display = new DisplayImplJ3D("display1");
        GraphicsModeControl dispGMC = this.display.getGraphicsModeControl();
        dispGMC.setScaleEnable(true);
        float[][] flat_isoVals = this.vals_ff.getFloats(false);
        this.iso_vals_ff.setSamples(flat_isoVals, false);
        this.latMap = new ScalarMap((ScalarType)this.latitude, Display.YAxis);
        this.lonMap = new ScalarMap((ScalarType)this.longitude, Display.XAxis);
        this.latMap.getAxisScale().createStandardLabels(10.0, 0.0, 0.0, 3.1);
        this.tempIsoMap = new ScalarMap((ScalarType)this.temperature, Display.ZAxis);
        this.tempRGBMap = new ScalarMap((ScalarType)this.temperature, Display.RGB);
        this.tempIsoMap2 = new ScalarMap((ScalarType)this.isotemperature, Display.ZAxis);
        this.tempIsoMapIso = new ScalarMap((ScalarType)this.isotemperature, Display.IsoContour);
        this.display.addMap(this.latMap);
        this.display.addMap(this.lonMap);
        this.display.addMap(this.tempIsoMap);
        this.display.addMap(this.tempRGBMap);
        this.display.addMap(this.tempIsoMapIso);
        this.display.addMap(this.tempIsoMap2);
        this.data_ref = new DataReferenceImpl("data_ref");
        this.iso_data_ref = new DataReferenceImpl("data_ref2");
        this.data_ref.setData((Data)this.vals_ff);
        this.iso_data_ref.setData((Data)this.iso_vals_ff);
        this.display.addReference((ThingReference)this.data_ref);
        this.display.addReference((ThingReference)this.iso_data_ref);
        this.jframe = new JFrame("NeqSim 3D-plot");
        this.jframe.getContentPane().add(this.display.getComponent());
        this.jframe.setSize(700, 700);
        this.jframe.setVisible(true);
    }

    public static void main(String[] args) throws RemoteException, VisADException {
        visAd3DPlot test2 = new visAd3DPlot("long", "alt", "height");
        test2.setXYvals(0.0, 10.0, 4, 0.0, 10.0, 4);
        double[][] z = new double[][]{{3.0, 2.0, 1.0, 3.0}, {2.0, 6.0, 4.0, 1.0}, {1.0, 3.0, 2.0, 1.0}, {3.0, 2.0, 1.0, 3.0}};
        test2.setZvals(z);
        test2.init();
    }
}

