/*
 * Decompiled with CFR 0.152.
 */
package neqsim.dataPresentation.fileHandeling.createNetCDF.netCDF3D;

import java.io.IOException;
import ucar.ma2.Array;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFileWriteable;

public class NetCdf3D {
    String fileName = "c:/temp/example.nc";
    double[] xvalues = new double[3];
    String xName = "xDefault";
    String yName = "yDefault";
    String zName = "zDefault";
    double[] yvalues = new double[4];
    double[][] zvalues = new double[4][4];
    double[][][] zvalues2 = new double[10][4][3];
    String[] zName2 = new String[10];
    NetcdfFileWriteable ncfile;
    int zLength = 0;

    public void setOutputFileName(String name) {
        this.fileName = name;
    }

    public void setXvalues(double[] x, String name, String unit) {
        this.xvalues = x;
        this.xName = name;
    }

    public void setYvalues(double[] y, String name, String unit) {
        this.yvalues = y;
        this.yName = name;
    }

    public void setZvalues(double[][] z, String name, String unit) {
        this.zvalues = z;
        this.zName = name;
        this.zName2[this.zLength] = name;
        this.zvalues2[this.zLength] = z;
        ++this.zLength;
    }

    public void createFile() {
        this.ncfile = new NetcdfFileWriteable();
        this.ncfile.setName(this.fileName);
        Dimension latD = this.ncfile.addDimension(this.xName, this.xvalues.length);
        Dimension lonD = this.ncfile.addDimension(this.yName, this.yvalues.length);
        Dimension[] dim2 = new Dimension[]{latD, lonD};
        int i = 0;
        while (i < this.zLength) {
            this.ncfile.addVariable(this.zName2[i], Double.TYPE, dim2);
            this.ncfile.addVariableAttribute(this.zName2[i], "long_name", "surface temperature");
            this.ncfile.addVariableAttribute(this.zName2[i], "units", "degC");
            ++i;
        }
        this.ncfile.addVariable(latD.getName(), Double.TYPE, new Dimension[]{latD});
        this.ncfile.addVariableAttribute(latD.getName(), "units", "degrees_north");
        this.ncfile.addVariable(lonD.getName(), Double.TYPE, new Dimension[]{lonD});
        this.ncfile.addVariableAttribute(lonD.getName(), "units", "degrees_east");
        this.ncfile.addGlobalAttribute("title", "Example Data");
        try {
            this.ncfile.create();
        }
        catch (IOException e) {
            System.err.println("ERROR creating file");
        }
        try {
            i = 0;
            while (i < this.zLength) {
                this.ncfile.write(this.zName2[i], Array.factory((Object)this.zvalues2[i]));
                ++i;
            }
            this.ncfile.write(latD.getName(), Array.factory((Object)this.xvalues));
            this.ncfile.write(lonD.getName(), Array.factory((Object)this.yvalues));
        }
        catch (Exception e) {
            System.err.println("ERROR writing file");
        }
        try {
            this.ncfile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.out.println("created " + this.fileName + " successfully");
    }
}

