/*
 * Decompiled with CFR 0.152.
 */
package neqsim.chemicalReactions.chemicalEquilibriaum;

import Jama.Matrix;
import java.io.Serializable;
import neqsim.thermo.component.ComponentInterface;
import neqsim.thermo.system.SystemInterface;

public class ChemicalEquilibrium
implements Serializable {
    private static final long serialVersionUID = 1000L;
    SystemInterface system;
    double[] nVector;
    double[] n_mol;
    double d_n_t = 0.0;
    int NSPEC = 2;
    int NELE = 2;
    double R = 8.314;
    Matrix x_solve;
    double y_solve;
    double n_t = 0.0;
    double agemo = 0.0;
    double kronDelt = 0.0;
    ComponentInterface[] components;
    double[][] M_matrix = new double[this.NSPEC][this.NSPEC];
    Matrix M_Jama_matrix;
    Matrix A_Jama_matrix;
    Matrix nmu;
    Matrix AMA_matrix;
    Matrix dn_matrix;
    Matrix AMU_matrix;
    Matrix Alambda_matrix;
    double[] d_n = new double[this.NSPEC];
    double[] logactivityVec = new double[this.NSPEC];
    double[] n0;
    double[][] A_matrix;
    double[] chem_ref;
    int waterNumb = 0;
    int upMoles = 0;
    double[] b_element;
    Matrix b_matrix;
    Matrix A_solve;
    Matrix b_solve;
    double[] chem_pot;
    Matrix chem_pot_Jama_Matrix;
    int phasenumb = 1;

    public ChemicalEquilibrium(double[][] A_matrix, double[] b_element, SystemInterface system, ComponentInterface[] components, int phase) {
        this.system = system;
        this.phasenumb = phase;
        this.A_matrix = A_matrix;
        this.b_element = b_element;
        this.components = components;
        this.NSPEC = components.length;
        this.NELE = b_element.length;
        this.n_mol = new double[components.length];
        this.logactivityVec = new double[this.NSPEC];
        this.chem_ref = new double[components.length];
        this.A_solve = new Matrix(this.NELE + 1, this.NELE + 1);
        this.b_solve = new Matrix(this.NELE + 1, 1);
        this.chem_ref = new double[this.NSPEC];
        this.chem_pot = new double[this.NSPEC];
        this.M_matrix = new double[this.NSPEC][this.NSPEC];
        this.d_n = new double[this.NSPEC];
        int i = 0;
        while (i < components.length) {
            if (components[i].getComponentName().equals("water")) {
                this.waterNumb = i;
                break;
            }
            ++i;
        }
        system.init(1, this.phasenumb);
        this.calcRefPot();
        int j = 0;
        while (j < this.NSPEC) {
            this.d_n[j] = 0.0;
            ++j;
        }
    }

    public void calcRefPot() {
        int i = 0;
        while (i < this.components.length) {
            this.chem_ref[i] = this.components[i].getReferencePotential() / (this.R * this.system.getPhase(this.phasenumb).getTemperature());
            this.logactivityVec[i] = 0.0;
            if (this.components[i].calcActivity()) {
                this.logactivityVec[i] = this.system.getPhase(this.phasenumb).getLogActivityCoefficient(this.components[i].getComponentNumber(), this.components[this.waterNumb].getComponentNumber());
            }
            ++i;
        }
    }

    public void chemSolve() {
        this.n_t = this.system.getPhase(this.phasenumb).getNumberOfMolesInPhase();
        int i = 0;
        while (i < this.NSPEC) {
            this.n_mol[i] = this.system.getPhase(this.phasenumb).getComponents()[this.components[i].getComponentNumber()].getNumberOfMolesInPhase();
            int k = 0;
            while (k < this.NSPEC) {
                this.kronDelt = k == i ? 1.0 : 0.0;
                this.M_matrix[i][k] = this.kronDelt / this.system.getPhase(this.phasenumb).getComponents()[this.components[i].getComponentNumber()].getNumberOfMolesInPhase();
                ++k;
            }
            ++i;
        }
        this.M_Jama_matrix = new Matrix(this.M_matrix);
        this.A_Jama_matrix = new Matrix(this.A_matrix);
        this.b_matrix = new Matrix(this.b_element, 1);
        double logactivity = 0.0;
        int i2 = 0;
        while (i2 < this.NSPEC) {
            logactivity = this.logactivityVec[i2];
            this.chem_pot[i2] = this.chem_ref[i2] + Math.log(this.system.getPhase(this.phasenumb).getComponents()[this.components[i2].getComponentNumber()].getNumberOfMolesInPhase()) - Math.log(this.n_t) + logactivity;
            ++i2;
        }
        this.chem_pot_Jama_Matrix = new Matrix(this.chem_pot, 1);
        this.AMA_matrix = this.A_Jama_matrix.times(this.M_Jama_matrix.inverse().times(this.A_Jama_matrix.transpose()));
        this.AMU_matrix = this.A_Jama_matrix.times(this.M_Jama_matrix.inverse().times(this.chem_pot_Jama_Matrix.transpose()));
        Matrix nmol = new Matrix(this.n_mol, 1);
        this.nmu = nmol.times(this.chem_pot_Jama_Matrix.transpose());
        this.A_solve.setMatrix(0, this.NELE - 1, 0, this.NELE - 1, this.AMA_matrix);
        this.A_solve.setMatrix(0, this.NELE - 1, this.NELE, this.NELE, this.b_matrix.transpose());
        this.A_solve.setMatrix(this.NELE, this.NELE, 0, this.NELE - 1, this.b_matrix);
        this.A_solve.set(this.NELE, this.NELE, 0.0);
        this.b_solve.setMatrix(0, this.NELE - 1, 0, 0, this.AMU_matrix);
        this.b_solve.setMatrix(this.NELE, this.NELE, 0, 0, this.nmu);
        this.y_solve = this.A_solve.det();
        if (this.y_solve < 1.0E-38 && this.y_solve > -1.0E-38 || this.y_solve < -1.0E70) {
            this.y_solve = this.AMA_matrix.det();
            this.y_solve = this.A_solve.rank();
        }
        try {
            this.x_solve = this.A_solve.solve(this.b_solve);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.dn_matrix = this.M_Jama_matrix.inverse().times(this.A_Jama_matrix.transpose().times(this.x_solve.getMatrix(0, this.NELE - 1, 0, 0)).minus(this.chem_pot_Jama_Matrix.transpose())).plus(new Matrix(this.n_mol, 1).transpose().times(this.x_solve.get(this.NELE, 0)));
        this.d_n = this.dn_matrix.transpose().getArray()[0];
    }

    public void updateMoles() {
        ++this.upMoles;
        int i = 0;
        while (i < this.components.length) {
            this.system.addComponent(this.components[i].getComponentNumber(), this.n_mol[i] - this.system.getPhase(this.phasenumb).getComponents()[this.components[i].getComponentNumber()].getNumberOfMolesInPhase(), this.phasenumb);
            ++i;
        }
        this.system.initBeta();
        this.system.init_x_y();
    }

    public boolean solve() {
        double error = 1.0E10;
        double errOld = 1.0E10;
        double thisError = 0.0;
        double p = 1.0;
        double maxError = 1.0E-8;
        this.upMoles = 0;
        try {
            do {
                p += 1.0;
                errOld = error;
                error = 0.0;
                this.chemSolve();
                double step1 = this.step();
                int i = 0;
                while (i < this.NSPEC) {
                    if (Math.abs(this.dn_matrix.get(i, 0)) / this.system.getPhase(this.phasenumb).getComponents()[this.components[i].getComponentNumber()].getNumberOfMolesInPhase() > 1.0E-15) {
                        thisError = Math.abs(this.dn_matrix.get(i, 0)) / this.system.getPhase(this.phasenumb).getComponent(this.components[i].getComponentNumber()).getNumberOfMolesInPhase();
                        error += Math.abs(thisError);
                        this.n_mol[i] = this.dn_matrix.get(i, 0) * step1 + this.system.getPhase(this.phasenumb).getComponent(this.components[i].getComponentNumber()).getNumberOfMolesInPhase();
                    }
                    ++i;
                }
                if (error <= errOld) {
                    this.updateMoles();
                    this.system.init(1, this.phasenumb);
                    this.calcRefPot();
                }
                if (!(p > 25.0)) continue;
                maxError *= 2.0;
            } while (errOld > maxError && Math.abs(error) > maxError && p < 350.0 || p < 2.0);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        if (p > 345.0) {
            System.out.println("iter " + p + " err " + error);
        }
        if (p >= 1000.0) {
            System.out.println("Too many iterations in chemical equilibrium " + error);
            System.out.println("P " + this.system.getPressure());
            System.out.println("T " + this.system.getTemperature());
        }
        if (Double.isNaN(error)) {
            System.out.println("error . NaN in chemSolve() ");
            System.out.println("pressure " + this.system.getPressure());
        }
        this.system.init(1, this.phasenumb);
        return error < maxError;
    }

    public void printComp() {
        int j = 0;
        while (j < this.NSPEC) {
            System.out.println(" SVAR : " + this.n_mol[j]);
            double activity = this.system.getPhase(this.phasenumb).getActivityCoefficient(this.components[j].getComponentNumber(), this.components[this.waterNumb].getComponentNumber());
            System.out.println("act " + activity + " comp " + this.components[j].getComponentName());
            ++j;
        }
    }

    public double[] getMoles() {
        return this.n_mol;
    }

    public double step() {
        double step = 1.0;
        int check = 0;
        double[] n_omega = new double[this.NSPEC];
        double[] chem_pot_omega = new double[this.NSPEC];
        double[] chem_pot = new double[this.NSPEC];
        double G_1 = 0.0;
        double G_0 = 0.0;
        int i = 0;
        while (i < this.NSPEC) {
            n_omega[i] = this.n_mol[i] + this.d_n[i];
            if (n_omega[i] < 0.0) {
                check = i;
                step = this.innerStep(i, n_omega, check, step, true);
                return step;
            }
            chem_pot[i] = this.system.getPhase(this.phasenumb).getComponents()[this.components[i].getComponentNumber()].getReferenceStateType().equals("solvent") ? this.R * this.system.getPhase(this.phasenumb).getTemperature() * (this.chem_ref[i] + Math.log(this.system.getPhase(this.phasenumb).getComponents()[this.components[i].getComponentNumber()].getNumberOfMolesInPhase()) - Math.log(this.n_t) + this.logactivityVec[i]) : this.R * this.system.getPhase(this.phasenumb).getTemperature() * (this.chem_ref[i] + Math.log(this.system.getPhase(this.phasenumb).getComponents()[this.components[i].getComponentNumber()].getNumberOfMolesInPhase()) - Math.log(this.n_t) + this.logactivityVec[i]);
            chem_pot_omega[i] = this.R * this.system.getPhase(this.phasenumb).getTemperature() * (this.chem_ref[i] + Math.log(n_omega[i]) - Math.log(this.n_t) + this.logactivityVec[i]);
            ++i;
        }
        this.Alambda_matrix = this.A_Jama_matrix.transpose().times(this.x_solve.getMatrix(0, this.NELE - 1, 0, 0));
        G_1 = 0.0;
        i = 0;
        while (i < this.NSPEC) {
            G_1 += (chem_pot_omega[i] - this.Alambda_matrix.get(i, 0)) * this.d_n[i] * (1.0 / n_omega[i] - 1.0 / this.n_t);
            ++i;
        }
        if (G_1 > 0.0) {
            G_0 = 0.0;
            i = 0;
            while (i < this.NSPEC) {
                G_0 += (chem_pot[i] - this.Alambda_matrix.get(i, 0)) * this.d_n[i] * (1.0 / this.system.getPhase(this.phasenumb).getComponents()[this.components[i].getComponentNumber()].getNumberOfMolesInPhase() - 1.0 / this.n_t);
                ++i;
            }
            step = G_0 / (G_0 - G_1);
        }
        step = this.innerStep(i, n_omega, check, step, false);
        return 1.0;
    }

    public double innerStep(int i, double[] n_omega, int check, double step, boolean test2) {
        if (test2) {
            this.agemo = -this.n_mol[i] / this.d_n[i] * 0.97;
            i = check;
            while (i < this.NSPEC) {
                n_omega[i] = this.n_mol[i] + this.d_n[i];
                if (n_omega[i] < 0.0 && (step = -this.n_mol[i] / this.d_n[i] * 0.97) < this.agemo) {
                    this.agemo = step;
                }
                ++i;
            }
            step = this.agemo;
            if (step > 1.0) {
                step = 1.0;
            }
        }
        return step;
    }
}

