/*
 * Decompiled with CFR 0.152.
 */
package neqsim.PVTsimulation.simulation;

import neqsim.PVTsimulation.simulation.BasePVTsimulation;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermo.system.SystemSrkEos;
import neqsim.thermodynamicOperations.ThermodynamicOperations;

public class SlimTubeSim
extends BasePVTsimulation {
    SystemInterface inectionGasSystem = null;
    private int numberOfSlimTubeNodes = 200;
    SystemInterface[] slimTubeNodeSystem = null;

    public SlimTubeSim(SystemInterface tempSystem, SystemInterface injectionGas) {
        super(tempSystem);
        this.inectionGasSystem = injectionGas;
    }

    @Override
    public void run() {
        this.slimTubeNodeSystem = new SystemInterface[this.numberOfSlimTubeNodes + 1];
        double totalReferenceNodeVolumeAtStadardConditions = 0.0;
        this.getThermoSystem().setPressure(1.01325);
        this.getThermoSystem().setTemperature(288.15);
        this.thermoOps.TPflash();
        totalReferenceNodeVolumeAtStadardConditions = this.getThermoSystem().getPhase(0).getVolume() * (double)this.numberOfSlimTubeNodes;
        if (this.getThermoSystem().getNumberOfPhases() > 1) {
            totalReferenceNodeVolumeAtStadardConditions = this.getThermoSystem().getPhase(1).getVolume() * (double)this.numberOfSlimTubeNodes;
        }
        this.getThermoSystem().setPressure(this.getPressure());
        this.getThermoSystem().setTemperature(this.getTemperature());
        this.thermoOps.TPflash();
        if (this.getThermoSystem().getNumberOfPhases() > 1) {
            System.out.println("more than one phase at initial pressure and temperature.....stopping slimtube simulation.");
            return;
        }
        double standardNodeVolume = this.getThermoSystem().getPhase(0).getVolume();
        this.inectionGasSystem.setPressure(this.getPressure());
        this.inectionGasSystem.setTemperature(this.getTemperature());
        this.inectionGasSystem.init(0);
        this.inectionGasSystem.init(1);
        int i = 0;
        while (i < this.numberOfSlimTubeNodes + 1) {
            this.slimTubeNodeSystem[i] = this.getThermoSystem().clone();
            ++i;
        }
        this.slimTubeNodeSystem[this.numberOfSlimTubeNodes].reset();
        this.slimTubeNodeSystem[this.numberOfSlimTubeNodes].init(1);
        ThermodynamicOperations slimOps0 = new ThermodynamicOperations(this.slimTubeNodeSystem[0]);
        ThermodynamicOperations slimOps1 = new ThermodynamicOperations(this.slimTubeNodeSystem[0]);
        int timeStep = 0;
        while (timeStep < 200) {
            this.slimTubeNodeSystem[0].addFluid(this.inectionGasSystem);
            slimOps0.setSystem(this.slimTubeNodeSystem[0]);
            slimOps0.TPflash();
            int i2 = 0;
            while (i2 < this.numberOfSlimTubeNodes) {
                double liquidExcessVolume;
                double totalVolume = this.slimTubeNodeSystem[i2].getVolume();
                double gasVolume = 0.0;
                int liquidPhaseNumber = 0;
                double excessVolume = totalVolume - standardNodeVolume;
                if (this.slimTubeNodeSystem[i2].getNumberOfPhases() > 1) {
                    gasVolume = this.slimTubeNodeSystem[i2].getPhase(0).getVolume();
                    liquidPhaseNumber = 1;
                }
                if ((liquidExcessVolume = totalVolume - standardNodeVolume - gasVolume) < 0.0) {
                    liquidExcessVolume = 0.0;
                }
                double gasExcessVolume = totalVolume - standardNodeVolume - liquidExcessVolume;
                double liquidVolume = this.slimTubeNodeSystem[i2].getPhase(liquidPhaseNumber).getVolume();
                double gasfactor = gasExcessVolume / excessVolume;
                if (gasExcessVolume < excessVolume) {
                    gasfactor = 1.0;
                }
                double[] removeMoles = new double[this.slimTubeNodeSystem[0].getPhase(0).getNumberOfComponents()];
                if (this.slimTubeNodeSystem[i2].getNumberOfPhases() > 1) {
                    int k = 0;
                    while (k < this.slimTubeNodeSystem[i2].getPhase(liquidPhaseNumber).getNumberOfComponents()) {
                        double moles = this.slimTubeNodeSystem[i2].getPhase(0).getComponent(k).getNumberOfMolesInPhase();
                        int n = k++;
                        removeMoles[n] = removeMoles[n] + gasfactor * moles;
                    }
                }
                double liqfactor = liquidExcessVolume / liquidVolume;
                if (liquidExcessVolume > 0.0) {
                    int k = 0;
                    while (k < this.slimTubeNodeSystem[i2].getPhase(liquidPhaseNumber).getNumberOfComponents()) {
                        double moles = this.slimTubeNodeSystem[i2].getPhase(liquidPhaseNumber).getComponent(k).getNumberOfMolesInPhase();
                        int n = k++;
                        removeMoles[n] = removeMoles[n] + moles * liqfactor;
                    }
                }
                double sum = 0.0;
                int comp = 0;
                while (comp < this.slimTubeNodeSystem[0].getPhase(liquidPhaseNumber).getNumberOfComponents()) {
                    sum += removeMoles[comp];
                    ++comp;
                }
                int k = 0;
                while (k < this.slimTubeNodeSystem[i2].getPhase(liquidPhaseNumber).getNumberOfComponents()) {
                    this.slimTubeNodeSystem[i2 + 1].addComponent(k, removeMoles[k]);
                    this.slimTubeNodeSystem[i2].addComponent(k, -removeMoles[k]);
                    ++k;
                }
                slimOps0.setSystem(this.slimTubeNodeSystem[i2]);
                slimOps0.TPflash();
                slimOps1.setSystem(this.slimTubeNodeSystem[i2 + 1]);
                slimOps1.TPflash();
                ++i2;
            }
            System.out.println("time " + timeStep + " node " + this.numberOfSlimTubeNodes + " volume " + this.slimTubeNodeSystem[this.numberOfSlimTubeNodes].getVolume() + " moles " + this.slimTubeNodeSystem[this.numberOfSlimTubeNodes].getNumberOfMoles());
            this.slimTubeNodeSystem[this.numberOfSlimTubeNodes].setTemperature(288.15);
            this.slimTubeNodeSystem[this.numberOfSlimTubeNodes].setPressure(1.01325);
            slimOps1.TPflash();
            double totalAccumulatedVolumeAtStadardConditions = this.slimTubeNodeSystem[this.numberOfSlimTubeNodes].getPhase(0).getVolume();
            if (this.slimTubeNodeSystem[this.numberOfSlimTubeNodes].getNumberOfPhases() > 1) {
                totalAccumulatedVolumeAtStadardConditions = this.slimTubeNodeSystem[this.numberOfSlimTubeNodes].getPhase(1).getVolume();
            }
            System.out.println("accumulated VOlume " + totalAccumulatedVolumeAtStadardConditions + " total reference volume " + totalReferenceNodeVolumeAtStadardConditions);
            System.out.println("oil recovery ratio" + totalAccumulatedVolumeAtStadardConditions / totalReferenceNodeVolumeAtStadardConditions);
            ++timeStep;
        }
        this.slimTubeNodeSystem[this.numberOfSlimTubeNodes].setTemperature(288.15);
        this.slimTubeNodeSystem[this.numberOfSlimTubeNodes].setPressure(1.01325);
        slimOps1.TPflash();
        double totalAccumulatedVolumeAtStadardConditions = this.slimTubeNodeSystem[this.numberOfSlimTubeNodes].getPhase(0).getVolume();
        if (this.slimTubeNodeSystem[this.numberOfSlimTubeNodes].getNumberOfPhases() > 1) {
            totalAccumulatedVolumeAtStadardConditions = this.slimTubeNodeSystem[this.numberOfSlimTubeNodes].getPhase(1).getVolume();
        }
        System.out.println("accumulated VOlume " + totalAccumulatedVolumeAtStadardConditions + " total reference volume " + totalReferenceNodeVolumeAtStadardConditions);
        System.out.println("oil recovery ratio" + totalAccumulatedVolumeAtStadardConditions / totalReferenceNodeVolumeAtStadardConditions);
        int i3 = 0;
        while (i3 < this.numberOfSlimTubeNodes) {
            this.slimTubeNodeSystem[i3].display();
            ++i3;
        }
    }

    public static void main(String[] args) {
        SystemSrkEos gasSystem = new SystemSrkEos(298.0, 200.0);
        gasSystem.addComponent("CO2", 10.0);
        gasSystem.createDatabase(true);
        gasSystem.setMixingRule(2);
        SystemSrkEos oilSystem = new SystemSrkEos(298.0, 200.0);
        oilSystem.addComponent("CO2", 0.1);
        oilSystem.addComponent("methane", 1.5);
        oilSystem.addComponent("ethane", 1.5);
        oilSystem.addTBPfraction("C7", 1.06, 0.0922, 0.7324);
        oilSystem.addTBPfraction("C8", 1.06, 0.1046, 0.7602);
        oilSystem.addTBPfraction("C9", 0.79, 0.1191, 0.7677);
        oilSystem.addTBPfraction("C10", 0.57, 0.133, 0.79);
        oilSystem.addTBPfraction("C11", 0.38, 0.155, 0.795);
        oilSystem.addTBPfraction("C12", 0.37, 0.162, 0.806);
        oilSystem.addTBPfraction("C13", 0.32, 0.177, 0.824);
        oilSystem.addTBPfraction("C14", 0.27, 0.198, 0.835);
        oilSystem.addTBPfraction("C15", 0.23, 0.202, 0.84);
        oilSystem.addTBPfraction("C16", 0.19, 0.215, 0.846);
        oilSystem.addTBPfraction("C17", 0.17, 0.234, 0.84);
        oilSystem.addTBPfraction("C18", 0.13, 0.251, 0.844);
        oilSystem.addTBPfraction("C19", 0.13, 0.27, 0.854);
        oilSystem.addPlusFraction("C20", 10.62, 0.381, 0.88);
        oilSystem.getCharacterization().characterisePlusFraction();
        oilSystem.createDatabase(true);
        oilSystem.setMixingRule(2);
        SlimTubeSim sepSim = new SlimTubeSim(oilSystem, gasSystem);
        sepSim.setTemperature(373.15);
        sepSim.setPressure(380.0);
        sepSim.setNumberOfSlimTubeNodes(40);
        sepSim.run();
    }

    public int getNumberOfSlimTubeNodes() {
        return this.numberOfSlimTubeNodes;
    }

    public void setNumberOfSlimTubeNodes(int numberOfSlimTubeNodes) {
        this.numberOfSlimTubeNodes = numberOfSlimTubeNodes;
    }
}

