/*
 * Decompiled with CFR 0.152.
 */
package neqsim.PVTsimulation.simulation;

import neqsim.PVTsimulation.simulation.BasePVTsimulation;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermo.system.SystemSrkEos;

public class SaturationPressure
extends BasePVTsimulation {
    public SaturationPressure(SystemInterface tempSystem) {
        super(tempSystem);
    }

    public double calcSaturationPressure() {
        this.getThermoSystem().isImplementedCompositionDeriativesofFugacity(false);
        this.getThermoSystem().setPressure(1.0);
        do {
            this.getThermoSystem().setPressure(this.getThermoSystem().getPressure() + 10.0);
            this.thermoOps.TPflash();
        } while (this.getThermoSystem().getNumberOfPhases() == 1 && this.getThermoSystem().getPressure() < 1000.0);
        do {
            this.getThermoSystem().setPressure(this.getThermoSystem().getPressure() + 10.0);
            this.thermoOps.TPflash();
        } while (this.getThermoSystem().getNumberOfPhases() > 1 && this.getThermoSystem().getPressure() < 1000.0);
        double minPres = this.getThermoSystem().getPressure() - 10.0;
        double maxPres = this.getThermoSystem().getPressure();
        int iteration = 0;
        do {
            ++iteration;
            this.getThermoSystem().setPressure((minPres + maxPres) / 2.0);
            this.thermoOps.TPflash();
            if (this.getThermoSystem().getNumberOfPhases() > 1) {
                minPres = this.getThermoSystem().getPressure();
                continue;
            }
            maxPres = this.getThermoSystem().getPressure();
        } while (Math.abs(maxPres - minPres) > 1.0E-5 && iteration < 500);
        this.getThermoSystem().setPressure(maxPres);
        this.thermoOps.TPflash();
        return this.getThermoSystem().getPressure();
    }

    @Override
    public void run() {
        super.run();
        this.saturationPressure = this.calcSaturationPressure();
    }

    public static void main(String[] args) {
        SystemSrkEos tempSystem = new SystemSrkEos(393.15, 100.0);
        tempSystem.addComponent("nitrogen", 0.34);
        tempSystem.addComponent("CO2", 3.59);
        tempSystem.addComponent("methane", 67.42);
        tempSystem.addComponent("ethane", 9.02);
        tempSystem.addComponent("propane", 4.31);
        tempSystem.addComponent("i-butane", 0.93);
        tempSystem.addComponent("n-butane", 1.71);
        tempSystem.addComponent("i-pentane", 0.74);
        tempSystem.addComponent("n-pentane", 0.85);
        tempSystem.addComponent("n-hexane", 1.38);
        tempSystem.addTBPfraction("C7", 1.5, 0.109, 0.6912);
        tempSystem.addTBPfraction("C8", 1.69, 0.1202, 0.7255);
        tempSystem.addTBPfraction("C9", 1.14, 0.1295, 0.7454);
        tempSystem.addTBPfraction("C10", 0.8, 0.1353, 0.7864);
        tempSystem.addPlusFraction("C11", 4.58, 0.2562, 0.8398);
        tempSystem.getCharacterization().characterisePlusFraction();
        tempSystem.createDatabase(true);
        tempSystem.setMixingRule(9);
        tempSystem.init(0);
        tempSystem.init(1);
        tempSystem.saveFluid(928);
        SaturationPressure satPresSim = new SaturationPressure(tempSystem);
        satPresSim.run();
        satPresSim.getThermoSystem().display();
    }

    @Override
    public double getSaturationPressure() {
        return this.saturationPressure;
    }
}

