from nautobot.core.apps import NavMenuAddButton, NavMenuGroup, NavMenuItem, NavMenuImportButton, NavMenuTab


menu_items = (
    NavMenuTab(
        name="IPAM",
        weight=300,
        groups=(
            NavMenuGroup(
                name="IP Addresses",
                weight=100,
                items=(
                    NavMenuItem(
                        link="ipam:ipaddress_list",
                        name="IP Addresses",
                        weight=100,
                        permissions=[
                            "ipam.view_ipaddress",
                        ],
                        buttons=(
                            NavMenuAddButton(
                                link="ipam:ipaddress_add",
                                permissions=[
                                    "ipam.add_ipaddress",
                                ],
                            ),
                            NavMenuImportButton(
                                link="ipam:ipaddress_import",
                                permissions=[
                                    "ipam.add_ipaddress",
                                ],
                            ),
                        ),
                    ),
                ),
            ),
            NavMenuGroup(
                name="Prefixes",
                weight=200,
                items=(
                    NavMenuItem(
                        link="ipam:prefix_list",
                        name="Prefixes",
                        weight=100,
                        permissions=[
                            "ipam.view_prefix",
                        ],
                        buttons=(
                            NavMenuAddButton(
                                link="ipam:prefix_add",
                                permissions=[
                                    "ipam.add_prefix",
                                ],
                            ),
                            NavMenuImportButton(
                                link="ipam:prefix_import",
                                permissions=[
                                    "ipam.add_prefix",
                                ],
                            ),
                        ),
                    ),
                    NavMenuItem(
                        link="ipam:rir_list",
                        name="RIRs",
                        weight=200,
                        permissions=[
                            "ipam.view_rir",
                        ],
                        buttons=(
                            NavMenuAddButton(
                                link="ipam:rir_add",
                                permissions=[
                                    "ipam.add_rir",
                                ],
                            ),
                            NavMenuImportButton(
                                link="ipam:rir_import",
                                permissions=[
                                    "ipam.add_rir",
                                ],
                            ),
                        ),
                    ),
                ),
            ),
            NavMenuGroup(
                name="VRFs",
                weight=400,
                items=(
                    NavMenuItem(
                        link="ipam:vrf_list",
                        name="VRFs",
                        weight=100,
                        permissions=[
                            "ipam.view_vrf",
                        ],
                        buttons=(
                            NavMenuAddButton(
                                link="ipam:vrf_add",
                                permissions=[
                                    "ipam.add_vrf",
                                ],
                            ),
                            NavMenuImportButton(
                                link="ipam:vrf_import",
                                permissions=[
                                    "ipam.add_vrf",
                                ],
                            ),
                        ),
                    ),
                    NavMenuItem(
                        link="ipam:routetarget_list",
                        name="Route Targets",
                        weight=200,
                        permissions=[
                            "ipam.view_routetarget",
                        ],
                        buttons=(
                            NavMenuAddButton(
                                link="ipam:routetarget_add",
                                permissions=[
                                    "ipam.add_routetarget",
                                ],
                            ),
                            NavMenuImportButton(
                                link="ipam:routetarget_import",
                                permissions=[
                                    "ipam.add_routetarget",
                                ],
                            ),
                        ),
                    ),
                ),
            ),
            NavMenuGroup(
                name="VLANs",
                weight=500,
                items=(
                    NavMenuItem(
                        link="ipam:vlan_list",
                        name="VLANs",
                        weight=100,
                        permissions=[
                            "ipam.view_vlan",
                        ],
                        buttons=(
                            NavMenuAddButton(
                                link="ipam:vlan_add",
                                permissions=[
                                    "ipam.add_vlan",
                                ],
                            ),
                            NavMenuImportButton(
                                link="ipam:vlan_import",
                                permissions=[
                                    "ipam.add_vlan",
                                ],
                            ),
                        ),
                    ),
                    NavMenuItem(
                        link="ipam:vlangroup_list",
                        name="VLAN Groups",
                        weight=200,
                        permissions=[
                            "ipam.view_vlangroup",
                        ],
                        buttons=(
                            NavMenuAddButton(
                                link="ipam:vlangroup_add",
                                permissions=[
                                    "ipam.add_vlangroup",
                                ],
                            ),
                            NavMenuImportButton(
                                link="ipam:vlangroup_import",
                                permissions=[
                                    "ipam.add_vlangroup",
                                ],
                            ),
                        ),
                    ),
                ),
            ),
            NavMenuGroup(
                name="Services",
                weight=600,
                items=(
                    NavMenuItem(
                        link="ipam:service_list",
                        name="Services",
                        weight=100,
                        permissions=[
                            "ipam.view_service",
                        ],
                        buttons=(
                            NavMenuImportButton(
                                link="ipam:service_import",
                                permissions=[
                                    "ipam.add_service",
                                ],
                            ),
                        ),
                    ),
                ),
            ),
        ),
    ),
)
