# Generated by Django 3.2.16 on 2022-11-25 11:45

from django.db import migrations
from nautobot.extras.utils import migrate_role_data


def migrate_data_from_legacy_role_to_new_role(apps, schema):
    """Copy record from role to temp_role"""

    role_model = apps.get_model("extras", "Role")
    for model_name in ("Device", "Rack"):
        model = apps.get_model("dcim", model_name)
        migrate_role_data(model=model, role_model=role_model)


def reverse_role_data_migrate(apps, schema):
    """Reverse changes made to new_role"""

    model_role_map = {"Device": "DeviceRole", "Rack": "RackRole"}
    for model_name, role_name in model_role_map.items():
        model = apps.get_model("dcim", model_name)
        role_model = apps.get_model("dcim", role_name)
        migrate_role_data(
            model=model,
            role_model=role_model,
            legacy_role="new_role",
            new_role="legacy_role",
        )


class Migration(migrations.Migration):

    dependencies = [
        ("dcim", "0024_alter_device_and_rack_role_add_new_role"),
    ]

    operations = [
        migrations.RunPython(migrate_data_from_legacy_role_to_new_role, reverse_role_data_migrate),
    ]
