# Generated by Django 3.2.16 on 2022-11-23 12:27

from django.db import migrations
from nautobot.extras.utils import migrate_role_data


def migrate_data_from_legacy_role_to_new_role(apps, schema):
    """Copy record from role to temp_role"""

    model = apps.get_model("virtualization", "VirtualMachine")
    role_model = apps.get_model("extras", "Role")
    migrate_role_data(model=model, role_model=role_model)


def reverse_role_data_migrate(apps, schema):
    """Reverse changes made to new_role"""

    model = apps.get_model("virtualization", "VirtualMachine")
    device_role_model = apps.get_model("dcim", "DeviceRole")
    migrate_role_data(
        model=model,
        role_model=device_role_model,
        legacy_role="new_role",
        new_role="legacy_role",
    )


class Migration(migrations.Migration):

    dependencies = [
        ("virtualization", "0012_alter_virtualmachine_role_add_new_role"),
    ]

    operations = [
        migrations.RunPython(migrate_data_from_legacy_role_to_new_role, reverse_role_data_migrate),
    ]
