# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['nautobot',
 'nautobot.circuits',
 'nautobot.circuits.api',
 'nautobot.circuits.graphql',
 'nautobot.circuits.migrations',
 'nautobot.circuits.tests',
 'nautobot.circuits.tests.integration',
 'nautobot.core',
 'nautobot.core.api',
 'nautobot.core.apps',
 'nautobot.core.celery',
 'nautobot.core.graphql',
 'nautobot.core.management',
 'nautobot.core.management.commands',
 'nautobot.core.models',
 'nautobot.core.runner',
 'nautobot.core.tests',
 'nautobot.core.tests.integration',
 'nautobot.core.views',
 'nautobot.dcim',
 'nautobot.dcim.api',
 'nautobot.dcim.graphql',
 'nautobot.dcim.management',
 'nautobot.dcim.management.commands',
 'nautobot.dcim.migrations',
 'nautobot.dcim.models',
 'nautobot.dcim.tables',
 'nautobot.dcim.tests',
 'nautobot.extras',
 'nautobot.extras.api',
 'nautobot.extras.datasources',
 'nautobot.extras.graphql',
 'nautobot.extras.management',
 'nautobot.extras.management.commands',
 'nautobot.extras.migrations',
 'nautobot.extras.models',
 'nautobot.extras.plugins',
 'nautobot.extras.secrets',
 'nautobot.extras.templatetags',
 'nautobot.extras.tests',
 'nautobot.extras.tests.example_jobs',
 'nautobot.extras.tests.example_plugin_dependency',
 'nautobot.extras.tests.integration',
 'nautobot.ipam',
 'nautobot.ipam.api',
 'nautobot.ipam.graphql',
 'nautobot.ipam.migrations',
 'nautobot.ipam.tests',
 'nautobot.ipam.tests.integration',
 'nautobot.tenancy',
 'nautobot.tenancy.api',
 'nautobot.tenancy.migrations',
 'nautobot.tenancy.tests',
 'nautobot.users',
 'nautobot.users.api',
 'nautobot.users.migrations',
 'nautobot.users.tests',
 'nautobot.utilities',
 'nautobot.utilities.forms',
 'nautobot.utilities.management',
 'nautobot.utilities.management.commands',
 'nautobot.utilities.templatetags',
 'nautobot.utilities.testing',
 'nautobot.utilities.tests',
 'nautobot.virtualization',
 'nautobot.virtualization.api',
 'nautobot.virtualization.graphql',
 'nautobot.virtualization.migrations',
 'nautobot.virtualization.tests']

package_data = \
{'': ['*'],
 'nautobot': ['docs/*',
              'docs/additional-features/*',
              'docs/administration/*',
              'docs/configuration/*',
              'docs/configuration/authentication/*',
              'docs/core-functionality/*',
              'docs/development/*',
              'docs/docker/*',
              'docs/img/*',
              'docs/installation/*',
              'docs/media/*',
              'docs/media/development/*',
              'docs/media/installation/*',
              'docs/media/models/*',
              'docs/media/plugins/*',
              'docs/models/circuits/*',
              'docs/models/dcim/*',
              'docs/models/extras/*',
              'docs/models/ipam/*',
              'docs/models/tenancy/*',
              'docs/models/users/*',
              'docs/models/virtualization/*',
              'docs/plugins/*',
              'docs/release-notes/*',
              'docs/rest-api/*',
              'docs/user-guides/*',
              'docs/user-guides/getting-started/*',
              'docs/user-guides/images/getting-started-nautobot-ui/*',
              'docs/user-guides/images/git-as-data-source/*',
              'docs/user-guides/images/graphql/*',
              'project-static/bootstrap-3.4.1-dist/css/*',
              'project-static/bootstrap-3.4.1-dist/fonts/*',
              'project-static/bootstrap-3.4.1-dist/js/*',
              'project-static/clipboard.js-2.0.9/*',
              'project-static/css/*',
              'project-static/flatpickr-4.6.9/*',
              'project-static/flatpickr-4.6.9/themes/*',
              'project-static/graphiql-1.5.16/*',
              'project-static/img/*',
              'project-static/jquery-ui-1.13.1/*',
              'project-static/jquery-ui-1.13.1/images/*',
              'project-static/jquery/*',
              'project-static/js/*',
              'project-static/materialdesignicons-6.5.95/*',
              'project-static/materialdesignicons-6.5.95/.github/*',
              'project-static/materialdesignicons-6.5.95/css/*',
              'project-static/materialdesignicons-6.5.95/fonts/*',
              'project-static/materialdesignicons-6.5.95/scss/*',
              'project-static/react-16.14.0/*',
              'project-static/react-dom-16.14.0/*',
              'project-static/select2-4.0.13/*',
              'project-static/select2-4.0.13/i18n/*',
              'project-static/select2-bootstrap-0.1.0-beta.10/*',
              'project-static/subscriptions-transport-ws-0.9.18/*',
              'project-static/whatwg-fetch-3.6.2/*'],
 'nautobot.circuits': ['templates/circuits/*', 'templates/circuits/inc/*'],
 'nautobot.core': ['fixtures/*',
                   'templates/*',
                   'templates/admin/*',
                   'templates/admin/bootstrapped_extra/*',
                   'templates/admin/config/*',
                   'templates/admin/edit_inline/*',
                   'templates/admin/includes/*',
                   'templates/exceptions/*',
                   'templates/generic/*',
                   'templates/graphene/*',
                   'templates/inc/*',
                   'templates/inc/computed_fields/*',
                   'templates/inc/custom_fields/*',
                   'templates/inc/relationships/*',
                   'templates/modals/*',
                   'templates/plugin_template/*',
                   'templates/plugin_template/migrations/*',
                   'templates/plugin_template/tests/*',
                   'templates/rest_framework/*'],
 'nautobot.dcim': ['templates/dcim/*',
                   'templates/dcim/device/*',
                   'templates/dcim/inc/*',
                   'templates/dcim/trace/*'],
 'nautobot.extras': ['templates/django_ajax_tables/*',
                     'templates/extras/*',
                     'templates/extras/inc/*',
                     'templates/extras/templatetags/*'],
 'nautobot.ipam': ['templates/ipam/*', 'templates/ipam/inc/*'],
 'nautobot.tenancy': ['templates/tenancy/*'],
 'nautobot.users': ['templates/users/*'],
 'nautobot.utilities': ['templates/buttons/*',
                        'templates/utilities/*',
                        'templates/utilities/templatetags/*',
                        'templates/widgets/*'],
 'nautobot.virtualization': ['templates/virtualization/*']}

install_requires = \
['Django>=3.2.14,<3.3.0',
 'GitPython>=3.1.27,<3.2.0',
 'Jinja2>=3.0.3,<3.1.0',
 'Markdown>=3.3.7,<3.4.0',
 'MarkupSafe>=2.1.1,<2.2.0',
 'Pillow>=9.1.1,<9.2.0',
 'PyYAML>=6.0,<6.1',
 'celery>=5.2.7,<5.3.0',
 'django-ajax-tables>=1.1.1,<1.2.0',
 'django-cacheops>=6.0,<6.1',
 'django-celery-beat>=2.2.1,<2.3.0',
 'django-constance[database]>=2.8.0,<2.9.0',
 'django-cors-headers>=3.13.0,<3.14.0',
 'django-cryptography>=1.0,<1.1',
 'django-db-file-storage>=0.5.5,<0.6.0',
 'django-extensions>=3.1.5,<3.2.0',
 'django-filter>=21.1,<21.2',
 'django-health-check>=3.16.5,<3.17.0',
 'django-jinja>=2.10.2,<2.11.0',
 'django-mptt>=0.13.4,<0.14.0',
 'django-prometheus>=2.2.0,<2.3.0',
 'django-redis>=5.2.0,<5.3.0',
 'django-rq>=2.5.1,<2.6.0',
 'django-tables2>=2.4.1,<2.5.0',
 'django-taggit>=1.5.1,<1.6.0',
 'django-timezone-field>=4.1.2,<4.2.0',
 'django-tree-queries>=0.11,<0.12',
 'django-webserver>=1.2.0,<1.3.0',
 'djangorestframework>=3.13.1,<3.14.0',
 'drf-spectacular[sidecar]>=0.22.1,<0.23.0',
 'drf-yasg[validation]>=1.20.0,<1.21.0',
 'graphene-django-optimizer>=0.8.0,<0.9.0',
 'graphene-django>=2.15.0,<2.16.0',
 'jsonschema>=4.4.0,<4.5.0',
 'netaddr>=0.8.0,<0.9.0',
 'netutils>=1.1.0,<1.2.0',
 'psycopg2-binary>=2.9.3,<2.10.0',
 'pycryptodome>=3.13.0,<3.14.0',
 'pyuwsgi>=2.0.20,<2.1.0',
 'social-auth-app-django>=5.0.0,<5.1.0',
 'svgwrite>=1.4.2,<1.5.0']

extras_require = \
{':python_version < "3.10"': ['importlib-metadata>=4.4,<4.5'],
 'all': ['django-auth-ldap>=4.1.0,<4.2.0',
         'django-storages>=1.12.3,<1.13.0',
         'mysqlclient>=2.1.0,<2.2.0',
         'napalm>=3.4.1,<3.5.0',
         'social-auth-core[saml,openidconnect]>=4.2.0,<4.3.0'],
 'ldap': ['django-auth-ldap>=4.1.0,<4.2.0'],
 'mysql': ['mysqlclient>=2.1.0,<2.2.0'],
 'napalm': ['napalm>=3.4.1,<3.5.0'],
 'remote_storage': ['django-storages>=1.12.3,<1.13.0'],
 'sso': ['social-auth-core[saml,openidconnect]>=4.2.0,<4.3.0']}

entry_points = \
{'console_scripts': ['nautobot-server = nautobot.core.cli:main']}

setup_kwargs = {
    'name': 'nautobot',
    'version': '1.4.0a2',
    'description': 'Source of truth and network automation platform.',
    'long_description': '# Nautobot\n\n![Nautobot](https://raw.githubusercontent.com/nautobot/nautobot/develop/nautobot/docs/nautobot_logo.svg "Nautobot logo")\n\nNautobot is a Network Source of Truth and Network Automation Platform.\n\n> Nautobot was initially developed as a fork of NetBox (v2.10.4).  NetBox was originally developed by Jeremy Stretch at DigitalOcean and the NetBox Community.\n\nNautobot runs as a web application atop the [Django](https://www.djangoproject.com/) Python framework with a\n[PostgreSQL](https://www.postgresql.org/) or [MySQL](https://www.mysql.com) database.\n\nThe complete documentation for Nautobot can be found at [Read the Docs](https://nautobot.readthedocs.io/en/stable/).\n\nQuestions? Comments? Start by perusing our [GitHub discussions](https://github.com/nautobot/nautobot/discussions) for the topic you have in mind, or join the **#nautobot** channel on [Network to Code\'s Slack community](https://slack.networktocode.com/)!\n\n## Build Status\n\n| Branch      | Status |\n|-------------|------------|\n| **main** | [![Build Status](https://github.com/nautobot/nautobot/actions/workflows/ci_integration.yml/badge.svg?branch=main)](https://github.com/nautobot/nautobot/actions/workflows/ci_integration.yml) |\n| **develop** | [![Build Status](https://github.com/nautobot/nautobot/actions/workflows/ci_integration.yml/badge.svg?branch=develop)](https://github.com/nautobot/nautobot/actions/workflows/ci_integration.yml) |\n| **next** | [![Build Status](https://github.com/nautobot/nautobot/actions/workflows/ci_integration.yml/badge.svg?branch=next)](https://github.com/nautobot/nautobot/actions/workflows/ci_integration.yml) |\n\n## Screenshots\n\n![Screenshot of main page](https://raw.githubusercontent.com/nautobot/nautobot/develop/nautobot/docs/media/ss_main_page.png "Main page")\n\n---\n\n![Screenshot of config contexts](https://raw.githubusercontent.com/nautobot/nautobot/develop/nautobot/docs/media/ss_config_contexts.png "Config Contexts")\n\n---\n\n![Screenshot of prefix hierarchy](https://raw.githubusercontent.com/nautobot/nautobot/develop/nautobot/docs/media/ss_prefix_hierarchy.png "Prefix hierarchy")\n\n---\n\n![Screenshot of GraphQL](https://raw.githubusercontent.com/nautobot/nautobot/develop/nautobot/docs/media/ss_graphiql.png "GraphQL API")\n\n## Installation\n\nPlease see [the documentation](https://nautobot.readthedocs.io/en/stable/installation/) for instructions on installing Nautobot.\n\n## Application Stack\n\nBelow is a simplified overview of the Nautobot application stack for reference:\n\n![Application stack diagram](https://raw.githubusercontent.com/nautobot/nautobot/develop/nautobot/docs/media/nautobot_application_stack_high_level.png "Application stack diagram")\n\n## Plugins and Extensibility\n\nNautobot offers the ability to customize your setup to better align with your direct business needs. It does so through the use of various plugins that have been developed for network automation, and are designed to be used in environments where needed.\n\nThere are many plugins available within the Nautobot Apps ecosystem. The below screenshots are an example of some popular ones that are currently available.\n\n### Plugin Screenshots\n\n#### Golden Config Plugin\n\n![Screenshot of golden config](https://raw.githubusercontent.com/nautobot/nautobot/develop/nautobot/docs/media/ss_plugin_golden_config.png "Golden config")\n\n#### ChatOps Plugin\n\n![Screenshot of chatops](https://raw.githubusercontent.com/nautobot/nautobot/develop/nautobot/docs/media/ss_plugin_chatops.png "ChatOps")\n\n## Providing Feedback\n\nThe best platform for general feedback, assistance, and other discussion is our [GitHub discussions](https://github.com/nautobot/nautobot/discussions). To report a bug or request a specific feature, please open a GitHub issue using the [appropriate template](https://github.com/nautobot/nautobot/issues/new/choose).\n\nIf you are interested in contributing to the development of Nautobot, please read our [contributing guide](CONTRIBUTING.md) prior to beginning any work.\n\n## Related projects\n\nPlease see [our wiki](https://github.com/nautobot/nautobot/wiki/Related-Projects) for a list of relevant community projects.\n',
    'author': 'Network to Code',
    'author_email': 'opensource@networktocode.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://nautobot.com',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
