# Generated by Django 3.1.14 on 2022-03-19 23:21

from django.db import migrations
from nautobot.extras.management import export_statuses_from_choiceset
from nautobot.virtualization.choices import VMInterfaceStatusChoices


def populate_vminterface_status(app, schema):

    Status = app.get_model("extras.Status")
    VMInterface = app.get_model("virtualization.VMInterface")
    ContentType = app.get_model("contenttypes.ContentType")

    vminterface_content_type = ContentType.objects.get_for_model(VMInterface)
    choices = export_statuses_from_choiceset(VMInterfaceStatusChoices)

    # Create VMInterface Statuses and add dcim.VMInterface to its content_types
    for choice_kwargs in choices:
        try:
            obj, created = Status.objects.get_or_create(**choice_kwargs)
        except Exception as err:
            raise SystemExit(
                f"Unexpected error while running data migration to populate"
                f"status for vitualization.vminterface: {err}"
            )

        obj.content_types.add(vminterface_content_type)

    # populate existing interfaces status
    active_status = Status.objects.get(slug=VMInterfaceStatusChoices.STATUS_ACTIVE)
    for interface in VMInterface.objects.all():
        interface.status = active_status
        interface.save()


def reverse_populate_vminterface_status(app, schema_editor):
    Status = app.get_model("extras.Status")
    VMInterface = app.get_model("virtualization.VMInterface")
    ContentType = app.get_model("contenttypes.ContentType")

    vminterface_content_type = ContentType.objects.get_for_model(VMInterface)

    for interface in VMInterface.objects.filter(status__slug=VMInterfaceStatusChoices.STATUS_ACTIVE):
        interface.status = None
        interface.save()

    for status in Status.objects.filter(content_types__in=[vminterface_content_type]):
        status.content_types.remove(vminterface_content_type)


class Migration(migrations.Migration):

    dependencies = [
        ("virtualization", "0006_vminterface_status"),
    ]

    operations = [
        migrations.RunPython(populate_vminterface_status, reverse_populate_vminterface_status),
    ]
