// -------------------------------------------------------------------------------------------------
//  Copyright (C) 2015-2023 Nautech Systems Pty Ltd. All rights reserved.
//  https://nautechsystems.io
//
//  Licensed under the GNU Lesser General Public License Version 3.0 (the "License");
//  You may not use this file except in compliance with the License.
//  You may obtain a copy of the License at https://www.gnu.org/licenses/lgpl-3.0.en.html
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
// -------------------------------------------------------------------------------------------------

use nautilus_model::model;
use nautilus_persistence::persistence;
use pyo3::{prelude::*, types::PyDict};

/// Need to modify sys modules so that submodule can be loaded directly as
/// import supermodule.submodule
///
/// refer: https://github.com/PyO3/pyo3/issues/2644
#[pymodule]
fn nautilus_pyo3(py: Python<'_>, m: &PyModule) -> PyResult<()> {
    // Persistence
    let submodule = pyo3::wrap_pymodule!(persistence);
    m.add_wrapped(submodule)?;
    let sys = PyModule::import(py, "sys")?;
    let sys_modules: &PyDict = sys.getattr("modules")?.downcast()?;
    sys_modules.set_item(
        "nautilus_trader.core.nautilus_pyo3.persistence",
        m.getattr("persistence")?,
    )?;

    // Model
    let submodule = pyo3::wrap_pymodule!(model);
    m.add_wrapped(submodule)?;
    let sys = PyModule::import(py, "sys")?;
    let sys_modules: &PyDict = sys.getattr("modules")?.downcast()?;
    sys_modules.set_item(
        "nautilus_trader.core.nautilus_pyo3.model",
        m.getattr("model")?,
    )?;
    Ok(())
}
