&nbsp;

<p align="center">
  <a href="https://py.n6.ai" target="_blank" rel="noopener noreferrer">
    <img src="https://raw.githubusercontent.com/n6ai/n6py/main/.github/img/n6py.svg" alt="n6py" width="125" height="auto">
  </a>
</p>

# n6py

[![PyPI Latest Release](https://img.shields.io/pypi/v/n6py?color=%23141414&style=for-the-badge)](https://pypi.org/project/n6py)
[![PyPI Python Version](https://img.shields.io/pypi/pyversions/n6py?color=%23141414&style=for-the-badge)](https://pypi.org/project/n6py)

> ⚡ AI Power Tools

Python Power Tools for Scientific Computing, Machine Learning and Deep Learning.

[Read the Docs to Learn More](https://py.n6.ai).

## Try Online

Click one of the icons to start with a fresh copy of `n6py` in an online environment.

<table>
  <tbody>
    <tr>
      <td>
        <a href="https://colab.research.google.com/github/n6ai/n6py/blob/main/notebooks/n6py-demo.ipynb">
          <div align="center">
            <img height="32" src="https://raw.githubusercontent.com/n6ai/n6py/main/.github/img/colab.svg" />
          </div>
        </a>
      </td>
      <td>
        <a href="https://mybinder.org/v2/git/https%3A%2F%2Fgithub.com%2Fn6ai%2Fn6py/HEAD?labpath=%2Fnotebooks%2Fn6py-demo.ipynb">
          <div align="center">
            <img height="32" src="https://raw.githubusercontent.com/n6ai/n6py/main/.github/img/binder.svg" />
          </div>
        </a>
      </td>
      <td>
        <a href="https://kaggle.com/kernels/welcome?src=https://github.com/n6ai/n6py/blob/main/notebooks/n6py-demo.ipynb">
          <div align="center">
            <img height="32" src="https://raw.githubusercontent.com/n6ai/n6py/main/.github/img/kaggle.svg" />
          </div>
        </a>
      </td>
    </tr>
  </tbody>
</table>

## Features

- 🐍 Python - Utility library for AI Python projects.
- 📃 Jupyter Notebooks - Designed for use inside Jupyter Notebooks but also works in regular .py files.
- ☁️ Cloud - Notebook Cloud Environment compatible e.g. Google Colab.
- 👶 Simple - Dive right in by adding n6py package to your project via pip.
- 📦 Modular - Pick and choose which modules to import to suit your needs.
- 🎲 Framework Agnostic - Use n6py with many common frameworks - NumPy, Pandas, etc ...

## Installation

```sh
pip install n6py
```

## Import

```py
import n6py as n6
```

## Contribution

See [Contributing Guide](https://github.com/n6ai/n6py/blob/main/.github/CONTRIBUTING.md).

## License

MIT
