from mutwo import music_parameters

# ###################################################################### #
#                            sabat constants                             #
# ###################################################################### #

TUNEABLE_INTERVAL_TO_DIFFICULTY_DICT = {
    music_parameters.JustIntonationPitch("1/1").exponent_tuple: 0,
    music_parameters.JustIntonationPitch("8/7").exponent_tuple: 1,
    music_parameters.JustIntonationPitch("7/6").exponent_tuple: 0,
    music_parameters.JustIntonationPitch("6/5").exponent_tuple: 0,
    music_parameters.JustIntonationPitch("11/9").exponent_tuple: 2,
    music_parameters.JustIntonationPitch("5/4").exponent_tuple: 0,
    music_parameters.JustIntonationPitch("9/7").exponent_tuple: 0,
    music_parameters.JustIntonationPitch("13/10").exponent_tuple: 1,
    music_parameters.JustIntonationPitch("4/3").exponent_tuple: 0,
    music_parameters.JustIntonationPitch("11/8").exponent_tuple: 2,
    music_parameters.JustIntonationPitch("7/5").exponent_tuple: 0,
    music_parameters.JustIntonationPitch("10/7").exponent_tuple: 1,
    music_parameters.JustIntonationPitch("13/9").exponent_tuple: 2,
    music_parameters.JustIntonationPitch("16/11").exponent_tuple: 2,
    music_parameters.JustIntonationPitch("3/2").exponent_tuple: 0,
    music_parameters.JustIntonationPitch("14/9").exponent_tuple: 2,
    music_parameters.JustIntonationPitch("11/7").exponent_tuple: 1,
    music_parameters.JustIntonationPitch("8/5").exponent_tuple: 0,
    music_parameters.JustIntonationPitch("13/8").exponent_tuple: 1,
    music_parameters.JustIntonationPitch("5/3").exponent_tuple: 0,
    music_parameters.JustIntonationPitch("12/7").exponent_tuple: 1,
    music_parameters.JustIntonationPitch("7/4").exponent_tuple: 0,
    music_parameters.JustIntonationPitch("9/5").exponent_tuple: 0,
    music_parameters.JustIntonationPitch("11/6").exponent_tuple: 1,
    music_parameters.JustIntonationPitch("13/7").exponent_tuple: 1,
    music_parameters.JustIntonationPitch("15/8").exponent_tuple: 2,
    music_parameters.JustIntonationPitch("23/12").exponent_tuple: 2,
    music_parameters.JustIntonationPitch("2/1").exponent_tuple: 0,
    music_parameters.JustIntonationPitch("13/6").exponent_tuple: 1,
    music_parameters.JustIntonationPitch("11/5").exponent_tuple: 1,
    music_parameters.JustIntonationPitch("9/4").exponent_tuple: 0,
    music_parameters.JustIntonationPitch("7/3").exponent_tuple: 0,
    music_parameters.JustIntonationPitch("19/8").exponent_tuple: 2,
    music_parameters.JustIntonationPitch("12/5").exponent_tuple: 0,
    music_parameters.JustIntonationPitch("17/7").exponent_tuple: 1,
    music_parameters.JustIntonationPitch("5/2").exponent_tuple: 0,
    music_parameters.JustIntonationPitch("18/7").exponent_tuple: 1,
    music_parameters.JustIntonationPitch("13/5").exponent_tuple: 1,
    music_parameters.JustIntonationPitch("8/3").exponent_tuple: 0,
    music_parameters.JustIntonationPitch("11/4").exponent_tuple: 0,
    music_parameters.JustIntonationPitch("14/5").exponent_tuple: 0,
    music_parameters.JustIntonationPitch("17/6").exponent_tuple: 1,
    music_parameters.JustIntonationPitch("20/7").exponent_tuple: 1,
    music_parameters.JustIntonationPitch("23/8").exponent_tuple: 1,
    music_parameters.JustIntonationPitch("3/1").exponent_tuple: 0,
    music_parameters.JustIntonationPitch("28/9").exponent_tuple: 2,
    music_parameters.JustIntonationPitch("25/8").exponent_tuple: 2,
    music_parameters.JustIntonationPitch("22/7").exponent_tuple: 2,
    music_parameters.JustIntonationPitch("19/6").exponent_tuple: 2,
    music_parameters.JustIntonationPitch("16/5").exponent_tuple: 0,
    music_parameters.JustIntonationPitch("13/4").exponent_tuple: 0,
    music_parameters.JustIntonationPitch("10/3").exponent_tuple: 0,
    music_parameters.JustIntonationPitch("27/8").exponent_tuple: 2,
    music_parameters.JustIntonationPitch("17/5").exponent_tuple: 1,
    music_parameters.JustIntonationPitch("24/7").exponent_tuple: 2,
    music_parameters.JustIntonationPitch("7/2").exponent_tuple: 0,
    music_parameters.JustIntonationPitch("18/5").exponent_tuple: 0,
    music_parameters.JustIntonationPitch("11/3").exponent_tuple: 0,
    music_parameters.JustIntonationPitch("15/4").exponent_tuple: 0,
    music_parameters.JustIntonationPitch("19/5").exponent_tuple: 1,
    music_parameters.JustIntonationPitch("23/6").exponent_tuple: 2,
    music_parameters.JustIntonationPitch("27/7").exponent_tuple: 2,
    music_parameters.JustIntonationPitch("4/1").exponent_tuple: 0,
    music_parameters.JustIntonationPitch("25/6").exponent_tuple: 2,
    music_parameters.JustIntonationPitch("21/5").exponent_tuple: 2,
    music_parameters.JustIntonationPitch("17/4").exponent_tuple: 1,
    music_parameters.JustIntonationPitch("13/3").exponent_tuple: 0,
    music_parameters.JustIntonationPitch("22/5").exponent_tuple: 2,
    music_parameters.JustIntonationPitch("9/2").exponent_tuple: 0,
    music_parameters.JustIntonationPitch("23/5").exponent_tuple: 1,
    music_parameters.JustIntonationPitch("14/3").exponent_tuple: 0,
    music_parameters.JustIntonationPitch("19/4").exponent_tuple: 1,
    music_parameters.JustIntonationPitch("24/5").exponent_tuple: 1,
    music_parameters.JustIntonationPitch("5/1").exponent_tuple: 0,
    music_parameters.JustIntonationPitch("26/5").exponent_tuple: 2,
    music_parameters.JustIntonationPitch("21/4").exponent_tuple: 1,
    music_parameters.JustIntonationPitch("16/3").exponent_tuple: 0,
    music_parameters.JustIntonationPitch("11/2").exponent_tuple: 0,
    music_parameters.JustIntonationPitch("28/5").exponent_tuple: 1,
    music_parameters.JustIntonationPitch("17/3").exponent_tuple: 0,
    music_parameters.JustIntonationPitch("23/4").exponent_tuple: 1,
    music_parameters.JustIntonationPitch("6/1").exponent_tuple: 0,
    music_parameters.JustIntonationPitch("25/4").exponent_tuple: 1,
    music_parameters.JustIntonationPitch("19/3").exponent_tuple: 0,
    music_parameters.JustIntonationPitch("13/2").exponent_tuple: 0,
    music_parameters.JustIntonationPitch("20/3").exponent_tuple: 0,
    music_parameters.JustIntonationPitch("27/4").exponent_tuple: 2,
    music_parameters.JustIntonationPitch("7/1").exponent_tuple: 0,
    music_parameters.JustIntonationPitch("22/3").exponent_tuple: 0,
    music_parameters.JustIntonationPitch("15/2").exponent_tuple: 0,
    music_parameters.JustIntonationPitch("23/3").exponent_tuple: 0,
    music_parameters.JustIntonationPitch("8/1").exponent_tuple: 0,
}
"""Tuneable Just Intonation Intervals sorted by difficulty, according to Marc Sabat."""

TUNEABLE_INTERVAL_TUPLE = tuple(
    music_parameters.JustIntonationPitch(exponent_tuple)
    for exponent_tuple in TUNEABLE_INTERVAL_TO_DIFFICULTY_DICT.keys()
)
"""Tuneable Just Intonation Intervals according to Marc Sabat."""

del music_parameters
