# Generated by Django 3.2.11 on 2022-01-22 08:15

from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='HostCheck',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('host_name', models.CharField(help_text='主机名称', max_length=50)),
                ('ipv4', models.CharField(help_text='IP地址字符', max_length=16)),
            ],
        ),
        migrations.CreateModel(
            name='HostCheckPort',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('ipv4', models.CharField(help_text='IP地址字符', max_length=16)),
                ('proto', models.CharField(help_text='协议: tcp | udp', max_length=10)),
                ('port', models.IntegerField(help_text='端口号')),
            ],
        ),
        migrations.CreateModel(
            name='VpnConnect',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('uptime', models.DateTimeField(default=django.utils.timezone.now, help_text='初次启动时间')),
                ('logfilepath', models.CharField(help_text='日志文件路径(过时)', max_length=100)),
                ('logtext', models.TextField(default=None, help_text='openvpn输出的日志文本', null=True)),
                ('pid', models.IntegerField(help_text='进程id', null=True)),
                ('tunnel_name', models.CharField(help_text='通道名，形如“tun0”,跟网卡名对应', max_length=100)),
                ('is_gate_way', models.BooleanField(default=False, help_text='是否默认网关')),
            ],
        ),
        migrations.CreateModel(
            name='VpnOvpn',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('host', models.CharField(help_text='主机名称', max_length=50)),
                ('port', models.IntegerField(help_text='端口')),
                ('proto', models.CharField(help_text='协议: tcp | udp', max_length=10)),
            ],
        ),
        migrations.CreateModel(
            name='VpnStatus',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('last_check_at', models.DateTimeField(auto_now_add=True, help_text='最后一次检测时间')),
                ('last_up_at', models.DateTimeField(default=django.utils.timezone.now, help_text='最后一次成功连接时间', null=True)),
                ('isUp', models.BooleanField(help_text='是否能连接，null 未知，True能，False，不能', null=True)),
            ],
        ),
        migrations.CreateModel(
            name='VpnItem',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('hostname', models.CharField(max_length=200)),
                ('ip', models.CharField(max_length=200)),
                ('score', models.CharField(max_length=200)),
                ('ping', models.CharField(max_length=200)),
                ('speed', models.CharField(max_length=200)),
                ('country_long', models.CharField(max_length=200)),
                ('country_short', models.CharField(max_length=200)),
                ('num_vpn_sessions', models.IntegerField(null=True)),
                ('uptime', models.BigIntegerField(null=True)),
                ('total_users', models.IntegerField(null=True)),
                ('total_traffic', models.BigIntegerField(null=True)),
                ('logtype', models.CharField(max_length=200)),
                ('operator', models.CharField(max_length=200)),
                ('message', models.CharField(max_length=200)),
                ('ovpn_config_text', models.TextField()),
                ('createat', models.DateTimeField(auto_now_add=True)),
                ('updateat', models.DateTimeField(auto_now=True)),
                ('connectinfo', models.ForeignKey(help_text='当前连接信息', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='connectinfo2', to='vpngate.vpnconnect')),
                ('ovpnconfig', models.ForeignKey(help_text='ovpn配置信息', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='ovpn', to='vpngate.vpnovpn')),
            ],
        ),
    ]
