Mission Pinball Framework (MPF)
===============================

<img align="center" height="146" src="mpf-logo-200.png"/>

<em>...Let's build a pinball machine!</em>

What is Mission Pinball Framework?
----------------------------------

Mission Pinball Framework (MPF) is an open source, cross-platform software for powering real pinball
machines in restaurants, bars, arcades, and elsewhere. MPF is developed by fun people under the MIT license, and supported by a vibrant pinball-loving community. It is a work in progress we are actively developing. We review commits weekly.

[![Coverage Status](https://coveralls.io/repos/missionpinball/mpf/badge.svg?branch=dev&service=github)](https://coveralls.io/github/missionpinball/mpf?branch=dev)
[![Build Status](https://travis-ci.org/missionpinball/mpf.svg?branch=dev)](https://travis-ci.org/missionpinball/mpf)
[![Build status](https://ci.appveyor.com/api/projects/status/ir15w3bo3kq19na1?svg=true)](https://ci.appveyor.com/project/toomanybrians/mpf)
[![Code Health](https://landscape.io/github/missionpinball/mpf/dev/landscape.svg?style=flat)](https://landscape.io/github/missionpinball/mpf/dev)
[![CII Best Practices](https://bestpractices.coreinfrastructure.org/projects/1687/badge)](https://bestpractices.coreinfrastructure.org/projects/1687)


Technology and Compatibility
----------------------------

You can use MPF to power your own custom-built machine, or to update software in existing Williams, Bally,
Stern, or Data East pinball machines. MPF interfaces with machines via modern pinball controller hardware, including (but not limited to):

* Multimorphic P-ROC or P3-ROC systems
* FAST Pinball controllers
* Open Pinball Project (OPP) open source hardware
* Stern SPIKE pinball systems

MPF is written in Python 3. It is compatible with Windows, Mac, and Linux using the same code and configurations. 

Visit the MPF project homepage at http://missionpinball.org.

<em>See also the [MPF Media Controller](https://github.com/missionpinball/mpf-mc/) (based on [Kivy](http://kivy.org)),
which is used to control graphics and sounds, including high-res LCD displays, classic DMDs, and modern RGB LED DMDs.</em>

Installation and Documentation
------------------------------
* Getting started tutorial: http://docs.missionpinball.org/en/latest/tutorial/
* Installation: http://docs.missionpinball.org/en/latest/install/
* User documentation: http://docs.missionpinball.org
* Developer documentation: http://developer.missionpinball.org/

Support
-------
Visit the user support forum at https://groups.google.com/forum/#!forum/mpf-users.

Contributing
------------
MPF is a passion project supported by an awesome pinball-loving community. If you're a Python coder, documentation writer, or pinball proponent, join the community! Drop us a line in the forum, or make a change and submit a pull request. For more information about contributing see the [Contributing Code](http://docs.missionpinball.org/en/latest/about/contributing_to_mpf.html)
and [Contributing Documentation](http://docs.missionpinball.org/en/latest/about/contributing_to_mpf_docs.html) pages.

License
-------
MPF and related projects are released under the MIT License. Refer to the LICENSE file for details. Docs are released under Creative Commons CC BY 4.0.
