#!/usr/bin/env python
# -*- coding: utf-8 -*-
# @Project      : MeUtils.
# @File         : wechat
# @Time         : 2021/6/7 11:17 上午
# @Author       : yuanjie
# @WeChat       : 313303303
# @Software     : PyCharm
# @Description  :

from meutils.pipe import *

from wechatpy.enterprise import WeChatClient as _WeChatClient


class WeChatClient(_WeChatClient):

    def __init__(self, corp_id, secret,
                 api_base_url=None,
                 access_token=None,
                 session=None, timeout=None, auto_retry=True):
        self.corp_id = corp_id
        self.secret = secret
        self.API_BASE_URL = api_base_url if api_base_url else 'https://qyapi.weixin.qq.com/cgi-bin/'

        super().__init__(
            corp_id, secret, access_token, session, timeout, auto_retry
        )

    def fetch_access_token(self):
        """ Fetch access token"""
        return self._fetch_access_token(
            url=f'{self.API_BASE_URL}gettoken',
            params={
                'corpid': self.corp_id,
                'corpsecret': self.secret
            }
        )

    @staticmethod
    def name2id(name='AI小分队'):
        from meutils.hash_utils import murmurhash
        return murmurhash(name)


if __name__ == '__main__':
    corp_id = '95fece49bb4206c3ww'[::-1]
    secret = 'Qyv5rH7bSdRrEe6YQ1lCq65AVzu6Kt4dgSR-xMNKpme'[::-1]  # AI *-
    agent_id = '1000041'
    api_base_url = 'https://qywxlocal.nesc.cn:7443/cgi-bin/'

    wc = WeChatClient(corp_id, secret, api_base_url)

    name = 'Notice'
    chat_id = wc.name2id(name)
    # wc.appchat.create(chat_id=chat_id, name=name, owner=7683, user_list=[7683, 7689])
    wc.appchat.send_text(chat_id, f"{name}#chat_id: {chat_id}")
