#!/usr/bin/env python
# -*- coding: utf-8 -*-
# @Project      : Python.
# @File         : data_utils
# @Time         : 2020-03-12 20:22
# @Author       : yuanjie
# @Email        : yuanjie@xiaomi.com
# @Software     : PyCharm
# @Description  :
# https://github.com/spotify/tfreader
# https://www.w3cschool.cn/tensorflow_python

from pathlib import Path

# Torch
# https://github.com/vahidk/tfrecord
import torch
from tfrecord.torch.dataset import TFRecordDataset

p = "/Users/yuanjie/Desktop/Projects/Spark/MIPush/test-output.tfrecord"
tfrecord_paths = list(map(str, Path(p).glob("part*")))
index_path = None
description = {"id": "int", "feature": "int"}
dataset = TFRecordDataset(tfrecord_paths[0], index_path, description)
loader = torch.utils.data.DataLoader(dataset, batch_size=32)

data = next(iter(loader))
print(data)

# TF
# https://www.tensorflow.org/api_docs/python/tf/data/TFRecordDataset
import tensorflow as tf


# d = tf.data.TFRecordDataset(input_file)
# d = d.shard(num_workers, worker_index)
# d = d.repeat(num_epochs)
# d = d.shuffle(shuffle_buffer_size)
# d = d.map(parser_fn, num_parallel_calls=num_map_threads)

# d = Dataset.list_files(pattern)
# d = d.shard(num_workers, worker_index)
# d = d.repeat(num_epochs)
# d = d.shuffle(shuffle_buffer_size)
# d = d.interleave(tf.data.TFRecordDataset,
#                  cycle_length=num_readers, block_length=1)
# d = d.map(parser_fn, num_parallel_calls=num_map_threads)

def parser_fn(example_photo):
    features = {
        'id': tf.io.FixedLenFeature((), tf.int64),
        'feature': tf.io.FixedLenFeature((), tf.int64),
    }
    parsed_features = tf.io.parse_single_example(example_photo, features=features)
    return parsed_features


data = (
    tf.data.TFRecordDataset(tfrecord_paths)
        .map(parser_fn)
        .shuffle(3, reshuffle_each_iteration=True)
        .repeat(2)
        # .make_one_shot_iterator()

)

print(list(data.as_numpy_iterator()))

# list(data.list_files(p + '/part*'), shuffle=True, seed=666)


FEATURE_COLUMNS = ['channel_id', 'article_vector', 'user_weigths', 'article_weights']

# http://baijiahao.baidu.com/s?id=1583657817436843385&wfr=spider&for=pc%20%E4%BB%8Etfrecord%E6%96%87%E4%BB%B6%E5%88%9B%E5%BB%BATFRecordDataset%E6%96%B9%E5%BC%8F%E5%A6%82%E4%B8%8B%EF%BC%9A%201%202%20#%20%E7%94%A8dataset%E8%AF%BB%E5%8F%96TFRecords%E6%96%87%E4%BB%B6%20dataset%20=%20tf.contrib.data.TFRecordDataset(input_file)%20%E8%A7%A3%E6%9E%90tfrecord%20%E6%96%87%E4%BB%B6%E7%9A%84%E6%AF%8F%E6%9D%A1%E8%AE%B0%E5%BD%95%EF%BC%8C%E5%8D%B3%E5%BA%8F%E5%88%97%E5%8C%96%E5%90%8E%E7%9A%84%20tf.train.Example%EF%BC%9B%E4%BD%BF%E7%94%A8%20tf.parse_single_example%20%E6%9D%A5%E8%A7%A3%E6%9E%90%EF%BC%9A%201%20feats%20=%20tf.parse_single_example(serial_exmp,%20features=data_dict)%20%E5%85%B6%E4%B8%AD%EF%BC%8Cdata_dict%20%E6%98%AF%E4%B8%80%E4%B8%AAdict%EF%BC%8C%E5%8C%85%E5%90%AB%E7%9A%84key%20%E6%98%AF%E5%86%99%E5%85%A5tfrecord%E6%96%87%E4%BB%B6%E6%97%B6%E7%94%A8%E7%9A%84key%20,%E7%9B%B8%E5%BA%94%E7%9A%84value%E6%98%AF%E5%AF%B9%E5%BA%94%E4%B8%8D%E5%90%8C%E7%9A%84%E6%95%B0%E6%8D%AE%E7%B1%BB%E5%9E%8B%EF%BC%8C%E6%88%91%E4%BB%AC%E7%9B%B4%E6%8E%A5%E4%BD%BF%E7%94%A8%E4%BB%A3%E7%A0%81%E7%9C%8B%EF%BC%8C%E5%A6%82%E4%B8%8B%EF%BC%9A%201%202%203%204%205%206%207%208%20def%20_parse_record(example_photo):%20features%20=%20{%20'name':%20tf.FixedLenFeature((),%20tf.string),%20'shape':%20tf.FixedLenFeature([3],%20tf.int64),%20'data':%20tf.FixedLenFeature((),%20tf.string)%20}%20parsed_features%20=%20tf.parse_single_example(example_photo,features=features)%20return%20parsed_features%20%E8%A7%A3%E6%9E%90tfrecord%E6%96%87%E4%BB%B6%E4%B8%AD%E7%9A%84%E6%89%80%E6%9C%89%E8%AE%B0%E5%BD%95%EF%BC%8C%E6%88%91%E4%BB%AC%E9%9C%80%E8%A6%81%E4%BD%BF%E7%94%A8dataset%20%E7%9A%84map%20%E6%96%B9%E6%B3%95%EF%BC%8C%E5%A6%82%E4%B8%8B%EF%BC%9A%201%20dataset%20=%20dataset.map(_parse_record)%20Dataset%E6%94%AF%E6%8C%81%E4%B8%80%E7%B1%BB%E7%89%B9%E6%AE%8A%E7%9A%84%E6%93%8D%E4%BD%9C%EF%BC%9ATransformation%E3%80%82%E4%B8%80%E4%B8%AADataset%E9%80%9A%E8%BF%87Transformation%E5%8F%98%E6%88%90%E4%B8%80%E4%B8%AA%E6%96%B0%E7%9A%84Dataset%E3%80%82%E9%80%9A%E5%B8%B8%E6%88%91%E4%BB%AC%E5%8F%AF%E4%BB%A5%E9%80%9A%E8%BF%87Transformation%E5%AE%8C%E6%88%90%E6%95%B0%E6%8D%AE%E5%8F%98%E6%8D%A2%EF%BC%8C%E6%89%93%E4%B9%B1%EF%BC%8C%E7%BB%84%E6%88%90batch%EF%BC%8C%E7%94%9F%E6%88%90epoch%E7%AD%89%E4%B8%80%E7%B3%BB%E5%88%97%E6%93%8D%E4%BD%9C%E3%80%82%E5%B8%B8%E7%94%A8%E7%9A%84Transformation%E6%9C%89%EF%BC%9Amap%E3%80%81batch%E3%80%81shuffle%E5%92%8Crepeat%E3%80%82%20map%E6%96%B9%E6%B3%95%E5%8F%AF%E4%BB%A5%E6%8E%A5%E5%8F%97%E4%BB%BB%E6%84%8F%E5%87%BD%E6%95%B0%E5%AF%B9dataset%E4%B8%AD%E7%9A%84%E6%95%B0%E6%8D%AE%E8%BF%9B%E8%A1%8C%E5%A4%84%E7%90%86%EF%BC%9B%E5%8F%A6%E5%A4%96%E5%8F%AF%E4%BB%A5%E4%BD%BF%E7%94%A8repeat%EF%BC%8Cshuffle%EF%BC%8Cbatch%E6%96%B9%E6%B3%95%E5%AF%B9dataset%E8%BF%9B%E8%A1%8C%E9%87%8D%E5%A4%8D%EF%BC%8C%E6%B7%B7%E6%B4%97%EF%BC%8C%E5%88%86%E6%89%B9%EF%BC%9B%E7%94%A8repeat%E8%B5%8B%E5%80%BCdataset%E4%BB%A5%E8%BF%9B%E8%A1%8C%E5%A4%9A%E4%B8%AAepoch%EF%BC%9B%E5%A6%82%E4%B8%8B%EF%BC%9A%201%20dataset%20=%20dataset.repeat(epochs).shuffle(buffer_size).batch(batch_size)%20%E8%A7%A3%E6%9E%90%E5%AE%8C%E6%95%B0%E6%8D%AE%E5%90%8E%EF%BC%8C%E4%BE%BF%E5%8F%AF%E4%BB%A5%E5%8F%96%E5%87%BA%E6%95%B0%E6%8D%AE%E8%BF%9B%E8%A1%8C%E4%BD%BF%E7%94%A8%EF%BC%8C%E9%80%9A%E8%BF%87%E5%88%9B%E5%BB%BAiterator%E6%9D%A5%E8%BF%9B%E8%A1%8C%EF%BC%8C%E5%A6%82%E4%B8%8B%EF%BC%9A%201%202%203%20iterator%20=%20dataset.make_one_shot_iterator()%20features%20=%20sess.run(iterator.get_next())%20%E4%B8%8B%E9%9D%A2%E5%88%86%E5%88%AB%E4%BB%8B%E7%BB%8D%208.1%EF%BC%8Cmap%20%E4%BD%BF%E7%94%A8%20tf.data.Dataset.map%EF%BC%8C%E6%88%91%E4%BB%AC%E5%8F%AF%E4%BB%A5%E5%BE%88%E6%96%B9%E4%BE%BF%E5%9C%B0%E5%AF%B9%E6%95%B0%E6%8D%AE%E9%9B%86%E4%B8%AD%E7%9A%84%E5%90%84%E4%B8%AA%E5%85%83%E7%B4%A0%E8%BF%9B%E8%A1%8C%E9%A2%84%E5%A4%84%E7%90%86%E3%80%82%E5%9B%A0%E4%B8%BA%E8%BE%93%E5%85%A5%E5%85%83%E7%B4%A0%E4%B9%8B%E9%97%B4%E6%97%B6%E7%8B%AC%E7%AB%8B%E7%9A%84%EF%BC%8C%E6%89%80%E4%BB%A5%E5%8F%AF%E4%BB%A5%E5%9C%A8%E5%A4%9A%E4%B8%AA%20CPU%20%E6%A0%B8%E5%BF%83%E4%B8%8A%E5%B9%B6%E8%A1%8C%E5%9C%B0%E8%BF%9B%E8%A1%8C%E9%A2%84%E5%A4%84%E7%90%86%E3%80%82map%20%E5%8F%98%E6%8D%A2%E6%8F%90%E4%BE%9B%E4%BA%86%E4%B8%80%E4%B8%AA%20num_parallel_calls%E5%8F%82%E6%95%B0%E5%8E%BB%E6%8C%87%E5%AE%9A%E5%B9%B6%E8%A1%8C%E7%9A%84%E7%BA%A7%E5%88%AB%E3%80%82%201%20dataset%20=%20dataset.map(map_func=parse_fn,%20num_parallel_calls=FLAGS.num_parallel_calls)%208.2%EF%BC%8Cprefetch%20tf.data.Dataset.prefetch%20%E6%8F%90%E4%BE%9B%E4%BA%86%20software%20pipelining%20%E6%9C%BA%E5%88%B6%E3%80%82%E8%AF%A5%E5%87%BD%E6%95%B0%E8%A7%A3%E8%80%A6%E4%BA%86%20%E6%95%B0%E6%8D%AE%E4%BA%A7%E7%94%9F%E7%9A%84%E6%97%B6%E9%97%B4%20%E5%92%8C%20%E6%95%B0%E6%8D%AE%E6%B6%88%E8%80%97%E7%9A%84%E6%97%B6%E9%97%B4%E3%80%82%E5%85%B7%E4%BD%93%E6%9D%A5%E8%AF%B4%EF%BC%8C%E8%AF%A5%E5%87%BD%E6%95%B0%E6%9C%89%E4%B8%80%E4%B8%AA%E5%90%8E%E5%8F%B0%E7%BA%BF%E7%A8%8B%E5%92%8C%E4%B8%80%E4%B8%AA%E5%86%85%E9%83%A8%E7%BC%93%E5%AD%98%E5%8C%BA%EF%BC%8C%E5%9C%A8%E6%95%B0%E6%8D%AE%E8%A2%AB%E8%AF%B7%E6%B1%82%E5%89%8D%EF%BC%8C%E5%B0%B1%E4%BB%8E%20dataset%20%E4%B8%AD%E9%A2%84%E5%8A%A0%E8%BD%BD%E4%B8%80%E4%BA%9B%E6%95%B0%E6%8D%AE%EF%BC%88%E8%BF%9B%E4%B8%80%E6%AD%A5%E6%8F%90%E9%AB%98%E6%80%A7%E8%83%BD%EF%BC%89%E3%80%82prefech(n)%20%E4%B8%80%E8%88%AC%E4%BD%9C%E4%B8%BA%E6%9C%80%E5%90%8E%E4%B8%80%E4%B8%AA%20transformation%EF%BC%8C%E5%85%B6%E4%B8%AD%20n%20%E4%B8%BA%20batch_size%E3%80%82%20prefetch%20%E7%9A%84%E4%BD%BF%E7%94%A8%E6%96%B9%E6%B3%95%E5%A6%82%E4%B8%8B%EF%BC%9A%201%202%203%20dataset%20=%20dataset.batch(batch_size=FLAGS.batch_size)%20dataset%20=%20dataset.prefetch(buffer_size=FLAGS.prefetch_buffer_size)%20#%20last%20transformation%20return%20dataset%208.3%EF%BC%8Crepeat%20repeat%E7%9A%84%E5%8A%9F%E8%83%BD%E5%B0%B1%E6%98%AF%E5%B0%86%E6%95%B4%E4%B8%AA%E5%BA%8F%E5%88%97%E9%87%8D%E5%A4%8D%E5%A4%9A%E6%AC%A1%EF%BC%8C%E4%B8%BB%E8%A6%81%E7%94%A8%E6%9D%A5%E5%A4%84%E7%90%86%E6%9C%BA%E5%99%A8%E5%AD%A6%E4%B9%A0%E4%B8%AD%E7%9A%84epoch%EF%BC%8C%E5%81%87%E8%AE%BE%E5%8E%9F%E5%85%88%E7%9A%84%E6%95%B0%E6%8D%AE%E6%98%AF%E4%B8%80%E4%B8%AAepoch%EF%BC%8C%E4%BD%BF%E7%94%A8repeat(5)%E5%B0%B1%E5%8F%AF%E4%BB%A5%E5%B0%86%E4%B9%8B%E5%8F%98%E6%88%905%E4%B8%AAepoch%EF%BC%9A%20%E5%A6%82%E6%9E%9C%E7%9B%B4%E6%8E%A5%E8%B0%83%E7%94%A8repeat()%E7%9A%84%E8%AF%9D%EF%BC%8C%E7%94%9F%E6%88%90%E7%9A%84%E5%BA%8F%E5%88%97%E5%B0%B1%E4%BC%9A%E6%97%A0%E9%99%90%E9%87%8D%E5%A4%8D%E4%B8%8B%E5%8E%BB%EF%BC%8C%E6%B2%A1%E6%9C%89%E7%BB%93%E6%9D%9F%EF%BC%8C%E5%9B%A0%E6%AD%A4%E4%B9%9F%E4%B8%8D%E4%BC%9A%E6%8A%9B%E5%87%BAtf.errors.OutOfRangeError%E5%BC%82%E5%B8%B8%208.4%EF%BC%8C%E5%AE%8C%E6%95%B4%E4%BB%A3%E7%A0%81%E5%A6%82%E4%B8%8B%EF%BC%9A%201%202%203%204%205%206%207%208%209%2010%2011%2012%2013%2014%2015%2016%2017%2018%2019%2020%2021%2022%2023%2024%2025%2026%2027%2028%2029%2030%2031%2032%2033%2034%2035%2036%2037%2038%2039%2040%2041%2042%2043%2044%2045%2046%2047%2048%2049%2050%2051%2052%2053%2054%2055%2056%2057%2058%2059%2060%2061%2062%2063%2064%2065%2066%2067%2068%2069%2070%2071%2072%2073%20#%20-*-coding:%20utf-8%20-*-%20import%20tensorflow%20as%20tf%20import%20numpy%20as%20np%20import%20glob%20import%20matplotlib.pyplot%20as%20plt%20width=0%20height=0%20def%20show_image(title,%20image):%20'''%20%E6%98%BE%E7%A4%BA%E5%9B%BE%E7%89%87%20:param%20title:%20%E5%9B%BE%E5%83%8F%E6%A0%87%E9%A2%98%20:param%20image:%20%E5%9B%BE%E5%83%8F%E7%9A%84%E6%95%B0%E6%8D%AE%20:return:%20'''%20#%20plt.figure(%22show_image%22)%20#%20print(image.dtype)%20plt.imshow(image)%20plt.axis('on')%20%20#%20%E5%85%B3%E6%8E%89%E5%9D%90%E6%A0%87%E8%BD%B4%E4%B8%BA%20off%20plt.title(title)%20%20#%20%E5%9B%BE%E5%83%8F%E9%A2%98%E7%9B%AE%20plt.show()%20def%20tf_read_image(filename,%20label):%20image_string%20=%20tf.read_file(filename)%20image_decoded%20=%20tf.image.decode_jpeg(image_string,%20channels=3)%20image%20=%20tf.cast(image_decoded,%20tf.float32)%20if%20width%3E0%20and%20height%3E0:%20image%20=%20tf.image.resize_images(image,%20[height,%20width])%20image%20=%20tf.cast(image,%20tf.float32)%20*%20(1.%20/%20255.0)%20%20#%20%E5%BD%92%E4%B8%80%E5%8C%96%20return%20image,%20label%20def%20input_fun(files_list,%20labels_list,%20batch_size,%20shuffle=True):%20'''%20:param%20files_list:%20:param%20labels_list:%20:param%20batch_size:%20:param%20shuffle:%20:return:%20'''%20#%20%E6%9E%84%E5%BB%BA%E6%95%B0%E6%8D%AE%E9%9B%86%20dataset%20=%20tf.data.Dataset.from_tensor_slices((files_list,%20labels_list))%20if%20shuffle:%20dataset%20=%20dataset.shuffle(100)%20dataset%20=%20dataset.repeat()%20%20#%20%E7%A9%BA%E4%B8%BA%E6%97%A0%E9%99%90%E5%BE%AA%E7%8E%AF%20dataset%20=%20dataset.map(tf_read_image,%20num_parallel_calls=4)%20%20#%20num_parallel_calls%E4%B8%80%E8%88%AC%E8%AE%BE%E7%BD%AE%E4%B8%BAcpu%E5%86%85%E6%A0%B8%E6%95%B0%E9%87%8F%20dataset%20=%20dataset.batch(batch_size)%20dataset%20=%20dataset.prefetch(2)%20%20#%20software%20pipelining%20%E6%9C%BA%E5%88%B6%20return%20dataset%20if%20__name__%20==%20'__main__':%20data_dir%20=%20'dataset/image/*.jpg'%20#%20labels_list%20=%20tf.constant([0,1,2,3,4])%20#%20labels_list%20=%20[1,%202,%203,%204,%205]%20files_list%20=%20glob.glob(data_dir)%20labels_list%20=%20np.arange(len(files_list))%20num_sample%20=%20len(files_list)%20batch_size%20=%201%20dataset%20=%20input_fun(files_list,%20labels_list,%20batch_size=batch_size,%20shuffle=False)%20#%20%E9%9C%80%E6%BB%A1%E8%B6%B3%EF%BC%9Amax_iterate*batch_size%20%3C=num_sample*num_epoch%EF%BC%8C%E5%90%A6%E5%88%99%E8%B6%8A%E7%95%8C%20max_iterate%20=%203%20with%20tf.Session()%20as%20sess:%20iterator%20=%20dataset.make_initializable_iterator()%20init_op%20=%20iterator.make_initializer(dataset)%20sess.run(init_op)%20iterator%20=%20iterator.get_next()%20for%20i%20in%20range(max_iterate):%20images,%20labels%20=%20sess.run(iterator)%20show_image(%22image%22,%20images[0,%20:,%20:,%20:])%20print('shape:{},tpye:{},labels:{}'.format(images.shape,%20images.dtype,%20labels))%209%EF%BC%8CAttributeError:%20module%20'tensorflow'%20has%20no%20attribute%20'data'%20%E8%A7%A3%E5%86%B3%E6%96%B9%E6%B3%95%20%E5%BD%93%E6%88%91%E4%BB%AC%E4%BD%BF%E7%94%A8tf%20%E4%B8%AD%E7%9A%84%20dataset%E6%97%B6%EF%BC%8C%E5%8F%AF%E8%83%BD%E4%BC%9A%E5%87%BA%E7%8E%B0%E5%A6%82%E4%B8%8B%E9%94%99%E8%AF%AF%EF%BC%9A%20%E5%8E%9F%E5%9B%A0%E6%98%AFtf%20%E7%89%88%E6%9C%AC%E4%B8%8D%E5%90%8C%E5%AF%BC%E8%87%B4%E7%9A%84%E9%94%99%E8%AF%AF%E3%80%82%20%E5%9C%A8%E7%BC%96%E5%86%99%E4%BB%A3%E7%A0%81%E7%9A%84%E6%97%B6%E5%80%99%EF%BC%8C%E4%BD%BF%E7%94%A8%E7%9A%84tf%E7%89%88%E6%9C%AC%E4%B8%8D%E5%90%8C%EF%BC%8C%E5%8F%AF%E8%83%BD%E5%AF%BC%E8%87%B4%E5%85%B6Dataset%20API%20%E6%94%BE%E7%BD%AE%E7%9A%84%E4%BD%8D%E7%BD%AE%E4%B8%8D%E5%90%8C%E3%80%82%E5%BD%93%E4%BD%BF%E7%94%A8TensorFlow1.3%E7%9A%84%E6%97%B6%E5%80%99%EF%BC%8CDataset%20API%E6%98%AF%E6%94%BE%E5%9C%A8%20contrib%20%E5%8C%85%E9%87%8C%E9%9D%A2%EF%BC%8C%E8%80%8C%E5%BD%93%E4%BD%BF%E7%94%A8TensorFlow1.4%E4%BB%A5%E5%90%8E%E7%9A%84%E7%89%88%E6%9C%AC%EF%BC%8CDataset%20API%E5%B7%B2%E7%BB%8F%E4%BB%8Econtrib%20%E5%8C%85%E4%B8%AD%E7%A7%BB%E9%99%A4%E4%BA%86%EF%BC%8C%E8%80%8C%E5%8F%98%E6%88%90%E4%BA%86%E6%A0%B8%E5%BF%83API%E7%9A%84%E4%B8%80%E5%91%98%E3%80%82%E6%95%85%E4%BC%9A%E4%BA%A7%E7%94%9F%E6%8A%A5%E9%94%99%E3%80%82%20%E8%A7%A3%E5%86%B3%E6%96%B9%E6%B3%95%EF%BC%9A%20%E5%B0%86%E4%B8%8B%E9%9D%A2%E4%BB%A3%E7%A0%81%EF%BC%9A%201%202%20#%20%E7%94%A8dataset%E8%AF%BB%E5%8F%96TFRecords%E6%96%87%E4%BB%B6%20dataset%20=%20tf.data.TFRecordDataset(input_file)%20%E6%94%B9%E4%B8%BA%E6%AD%A4%E4%BB%A3%E7%A0%81%EF%BC%9A%201%202%20#%20%E7%94%A8dataset%E8%AF%BB%E5%8F%96TFRecords%E6%96%87%E4%BB%B6%20dataset%20=%20tf.contrib.data.TFRecordDataset(input_file)%20%E9%97%AE%E9%A2%98%E8%A7%A3%E5%86%B3%E3%80%82%2010%EF%BC%8Ctf.gfile.FastGfile()%E5%87%BD%E6%95%B0%E5%AD%A6%E4%B9%A0%20%E5%87%BD%E6%95%B0%E5%A6%82%E4%B8%8B%EF%BC%9A%201%20tf.gfile.FastGFile(path,decodestyle)%20%E5%87%BD%E6%95%B0%E5%8A%9F%E8%83%BD%EF%BC%9A%E5%AE%9E%E7%8E%B0%E5%AF%B9%E5%9B%BE%E7%89%87%E7%9A%84%E8%AF%BB%E5%8F%96%20%E5%87%BD%E6%95%B0%E5%8F%82%E6%95%B0%EF%BC%9Apath%EF%BC%9A%E5%9B%BE%E7%89%87%E6%89%80%E5%9C%A8%E8%B7%AF%E5%BE%84%20decodestyle%EF%BC%9A%E5%9B%BE%E7%89%87%E7%9A%84%E8%A7%A3%E7%A0%81%E6%96%B9%E5%BC%8F(%E2%80%98r%E2%80%99%EF%BC%9AUTF-8%E7%BC%96%E7%A0%81%EF%BC%9B%20%E2%80%98rb%E2%80%99%EF%BC%9A%E9%9D%9EUTF-8%E7%BC%96%E7%A0%81)%20%E4%BE%8B%E5%AD%90%E5%A6%82%E4%B8%8B%EF%BC%9A%201%20img_raw%20=%20tf.gfile.FastGFile(IMAGE_PATH,%20'rb').read()%2011%EF%BC%8CPython%20zip()%E5%87%BD%E6%95%B0%E5%AD%A6%E4%B9%A0%20zip()%20%E5%87%BD%E6%95%B0%E7%94%A8%E4%BA%8E%E5%B0%86%E5%8F%AF%E8%BF%AD%E4%BB%A3%E7%9A%84%E5%AF%B9%E8%B1%A1%E4%BD%9C%E4%B8%BA%E5%8F%82%E6%95%B0%EF%BC%8C%E5%B0%86%E5%AF%B9%E8%B1%A1%E4%B8%AD%E5%AF%B9%E5%BA%94%E7%9A%84%E5%85%83%E7%B4%A0%E6%89%93%E5%8C%85%E6%88%90%E4%B8%80%E4%B8%AA%E4%B8%AA%E5%85%83%E7%BB%84%EF%BC%8C%E7%84%B6%E5%90%8E%E8%BF%94%E5%9B%9E%E7%94%B1%E8%BF%99%E4%BA%9B%E5%85%83%E7%BB%84%E7%BB%84%E6%88%90%E7%9A%84%E5%88%97%E8%A1%A8%E3%80%82%E5%A6%82%E6%9E%9C%E5%90%84%E4%B8%AA%E8%BF%AD%E4%BB%A3%E5%99%A8%E7%9A%84%E5%85%83%E7%B4%A0%E4%B8%AA%E6%95%B0%E4%B8%8D%E4%B8%80%E8%87%B4%EF%BC%8C%E5%88%99%E8%BF%94%E5%9B%9E%E5%88%97%E8%A1%A8%E9%95%BF%E5%BA%A6%E4%B8%8E%E6%9C%80%E7%9F%AD%E7%9A%84%E5%AF%B9%E8%B1%A1%E7%9B%B8%E5%90%8C%EF%BC%8C%E5%88%A9%E7%94%A8*%E5%8F%B7%E6%93%8D%E4%BD%9C%E7%AC%A6%EF%BC%8C%E5%8F%AF%E4%BB%A5%E5%B0%86%E5%85%83%E7%BB%84%E8%A7%A3%E5%8E%8B%E4%B8%BA%E5%88%97%E8%A1%A8%E3%80%82%20%E5%9C%A8%20Python%203.x%20%E4%B8%AD%E4%B8%BA%E4%BA%86%E5%87%8F%E5%B0%91%E5%86%85%E5%AD%98%EF%BC%8Czip()%20%E8%BF%94%E5%9B%9E%E7%9A%84%E6%98%AF%E4%B8%80%E4%B8%AA%E5%AF%B9%E8%B1%A1%E3%80%82%E5%A6%82%E9%9C%80%E5%B1%95%E7%A4%BA%E5%88%97%E8%A1%A8%EF%BC%8C%E9%9C%80%E6%89%8B%E5%8A%A8%20list()%20%E8%BD%AC%E6%8D%A2%E3%80%82%201%202%203%204%205%20zip([iterable,%20...])%20%E5%8F%82%E6%95%B0%E8%AF%B4%E6%98%8E%EF%BC%9A%20iterabl%E2%80%94%E2%80%94%E4%B8%80%E4%B8%AA%E6%88%96%E5%A4%9A%E4%B8%AA%E8%BF%AD%E4%BB%A3%E5%99%A8%20%E8%BF%94%E5%9B%9E%E5%80%BC%EF%BC%9A%E8%BF%94%E5%9B%9E%E5%85%83%E7%BB%84%E5%88%97%E8%A1%A8%20%E5%AE%9E%E4%BE%8B%EF%BC%9A%201%202%203%204%205%206%207%208%209%2010%2011%2012%20%3E%3E%3Ea%20=%20[1,2,3]%20%3E%3E%3E%20b%20=%20[4,5,6]%20%3E%3E%3E%20c%20=%20[4,5,6,7,8]%20%3E%3E%3E%20zipped%20=%20zip(a,b)%20%20%20%20%20#%20%E6%89%93%E5%8C%85%E4%B8%BA%E5%85%83%E7%BB%84%E7%9A%84%E5%88%97%E8%A1%A8%20[(1,%204),%20(2,%205),%20(3,%206)]%20%3E%3E%3E%20zip(a,c)%20%20%20%20%20%20%20%20%20%20%20%20%20%20#%20%E5%85%83%E7%B4%A0%E4%B8%AA%E6%95%B0%E4%B8%8E%E6%9C%80%E7%9F%AD%E7%9A%84%E5%88%97%E8%A1%A8%E4%B8%80%E8%87%B4%20[(1,%204),%20(2,%205),%20(3,%206)]%20%3E%3E%3E%20zip(*zipped)%20%20%20%20%20%20%20%20%20%20#%20%E4%B8%8E%20zip%20%E7%9B%B8%E5%8F%8D%EF%BC%8C*zipped%20%E5%8F%AF%E7%90%86%E8%A7%A3%E4%B8%BA%E8%A7%A3%E5%8E%8B%EF%BC%8C%E8%BF%94%E5%9B%9E%E4%BA%8C%E7%BB%B4%E7%9F%A9%E9%98%B5%E5%BC%8F%20[(1,%202,%203),%20(4,%205,%206)]%2012%EF%BC%8C%E4%B8%8B%E4%B8%80%E6%AD%A5%E8%AE%A1%E5%88%92%201%EF%BC%8C%E4%B8%BA%E4%BB%80%E4%B9%88%E5%89%8D%E9%9D%A2%E4%BD%BF%E7%94%A8Dataset%EF%BC%8C%E8%80%8C%E7%94%A8%E5%A4%A7%E5%A4%9A%E6%95%B0%E5%8D%9A%E6%96%87%E4%B8%AD%E7%9A%84%20QueueRunner%20%E5%91%A2%EF%BC%9F%20A:%E8%BF%99%E6%98%AF%E5%9B%A0%E4%B8%BA%20Dataset%20%E6%AF%94%20QueueRunner%20%E6%96%B0%EF%BC%8C%E8%80%8C%E4%B8%94%E6%98%AF%E5%AE%98%E6%96%B9%E6%8E%A8%E8%8D%90%E7%9A%84%EF%BC%8CDataset%20%E6%AF%94%E8%BE%83%E7%AE%80%E5%8D%95%E3%80%82%202%EF%BC%8C%E5%AD%A6%E4%B9%A0%E4%BA%86%20TFRecord%20%E7%9B%B8%E5%85%B3%E7%9F%A5%E8%AF%86%EF%BC%8C%E4%B8%8B%E4%B8%80%E6%AD%A5%E5%AD%A6%E4%B9%A0%E4%BB%80%E4%B9%88%EF%BC%9F%20A:%E5%8F%AF%E4%BB%A5%E5%B0%9D%E8%AF%95%E5%B0%86%E5%B8%B8%E8%A7%81%E7%9A%84%E6%95%B0%E6%8D%AE%E9%9B%86%E5%A6%82%20MNIST%20%E5%92%8C%20CIFAR-10%20%E8%BD%AC%E6%8D%A2%E6%88%90%20TFRecord%20%E6%A0%BC%E5%BC%8F%E3%80%82%20%E5%8F%82%E8%80%83%E6%96%87%E7%8C%AE%EF%BC%9Ahttps://blog.csdn.net/u012759136/article/details/52232266%20https://blog.csdn.net/tengxing007/article/details/56847828/%20https://blog.csdn.net/briblue/article/details/80789608%20(%E4%BA%94%E6%98%9F%E6%8E%A8%E8%8D%90)%20https://blog.csdn.net/happyhorizion/article/details/77894055%20%20(%E4%BA%94%E6%98%9F%E6%8E%A8%E8%8D%90)%20%E4%B8%8D%E7%BB%8F%E4%B8%80%E7%95%AA%E5%BD%BB%E9%AA%A8%E5%AF%92%20%E6%80%8E%E5%BE%97%E6%A2%85%E8%8A%B1%E6%89%91%E9%BC%BB%E9%A6%99%20%E6%A0%87%E7%AD%BE:%20%E6%B7%B1%E5%BA%A6%E5%AD%A6%E4%B9%A0%E5%B8%B8%E7%94%A8%E7%AE%97%E6%B3%95%E5%8F%8A%E7%AC%94%E8%AE%B0%20%E5%A5%BD%E6%96%87%E8%A6%81%E9%A1%B6%20%E5%85%B3%E6%B3%A8%E6%88%91%20%E6%94%B6%E8%97%8F%E8%AF%A5%E6%96%87%20%E6%88%98%E4%BA%89%E7%83%AD%E8%AF%9A%20%E5%85%B3%E6%B3%A8%20-%2029%20%E7%B2%89%E4%B8%9D%20-%20816%20+%E5%8A%A0%E5%85%B3%E6%B3%A8%2010%20%C2%AB%20%E4%B8%8A%E4%B8%80%E7%AF%87%EF%BC%9A%20OCR%E6%96%87%E5%AD%97%E8%AF%86%E5%88%AB%E7%AC%94%E8%AE%B0%E6%80%BB%E7%BB%93%20%C2%BB%20%E4%B8%8B%E4%B8%80%E7%AF%87%EF%BC%9A%20tensorflow%E5%AD%A6%E4%B9%A0%E7%AC%94%E8%AE%B0%E2%80%94%E2%80%94%E4%BD%BF%E7%94%A8TensorFlow%E6%93%8D%E4%BD%9CMNIST%E6%95%B0%E6%8D%AE%EF%BC%881%EF%BC%89%20posted%20@%202019-07-20%2020:02%20%20%E6%88%98%E4%BA%89%E7%83%AD%E8%AF%9A%20%20%E9%98%85%E8%AF%BB(3566)%20%20%E8%AF%84%E8%AE%BA(1)%20%20%E7%BC%96%E8%BE%91%20%20%E6%94%B6%E8%97%8F%20%E8%AF%84%E8%AE%BA%E5%88%97%E8%A1%A8%20#1%E6%A5%BC%202020-01-13%2014:39%20MaybeLL%20%E5%A5%BD%E6%96%87%EF%BC%8C%E6%84%9F%E8%B0%A2%E5%8D%9A%E4%B8%BB%20%E6%94%AF%E6%8C%81(0)%20%E5%8F%8D%E5%AF%B9(0)%20%E5%88%B7%E6%96%B0%E8%AF%84%E8%AE%BA%E5%88%B7%E6%96%B0%E9%A1%B5%E9%9D%A2%E8%BF%94%E5%9B%9E%E9%A1%B6%E9%83%A8%20%E6%B3%A8%E5%86%8C%E7%94%A8%E6%88%B7%E7%99%BB%E5%BD%95%E5%90%8E%E6%89%8D%E8%83%BD%E5%8F%91%E8%A1%A8%E8%AF%84%E8%AE%BA%EF%BC%8C%E8%AF%B7%20%E7%99%BB%E5%BD%95%20%E6%88%96%20%E6%B3%A8%E5%86%8C%EF%BC%8C%20%E8%AE%BF%E9%97%AE%20%E7%BD%91%E7%AB%99%E9%A6%96%E9%A1%B5%E3%80%82%20%E3%80%90%E6%8E%A8%E8%8D%90%E3%80%91%E8%B6%8550%E4%B8%87%E8%A1%8CVC++%E6%BA%90%E7%A0%81:%20%E5%A4%A7%E5%9E%8B%E7%BB%84%E6%80%81%E5%B7%A5%E6%8E%A7%E3%80%81%E7%94%B5%E5%8A%9B%E4%BB%BF%E7%9C%9FCAD%E4%B8%8EGIS%E6%BA%90%E7%A0%81%E5%BA%93%20%E3%80%90%E6%B4%BB%E5%8A%A8%E3%80%91%E8%85%BE%E8%AE%AF%E4%BA%91%E6%9C%8D%E5%8A%A1%E5%99%A8%E6%8E%A8%E5%87%BA%E4%BA%91%E4%BA%A7%E5%93%81%E9%87%87%E8%B4%AD%E5%AD%A3%201%E6%A0%B82G%E9%A6%96%E5%B9%B4%E4%BB%85%E9%9C%8099%E5%85%83%20%E3%80%90%E6%8E%A8%E8%8D%90%E3%80%91%E7%8B%AC%E5%AE%B6%E4%B8%8B%E8%BD%BD%20|%E3%80%8A%E5%A4%A7%E6%95%B0%E6%8D%AE%E5%B7%A5%E7%A8%8B%E5%B8%88%E5%BF%85%E8%AF%BB%E6%89%8B%E5%86%8C%E3%80%8B%E6%8F%AD%E7%A7%98%E9%98%BF%E9%87%8C%E5%A6%82%E4%BD%95%E7%8E%A9%E8%BD%AC%E5%A4%A7%E6%95%B0%E6%8D%AE%20%E3%80%90%E6%8E%A8%E8%8D%90%E3%80%91%E7%B2%BE%E5%93%81%E9%97%AE%E7%AD%94%EF%BC%9A%E5%A4%A7%E6%95%B0%E6%8D%AE%E8%AE%A1%E7%AE%97%E6%8A%80%E6%9C%AF%201000%20%E9%97%AE%20%E7%9B%B8%E5%85%B3%E5%8D%9A%E6%96%87%EF%BC%9A%20%C2%B7%20Tensorflow%20%E5%A4%84%E7%90%86libsvm%E6%A0%BC%E5%BC%8F%E6%95%B0%E6%8D%AE%E7%94%9F%E6%88%90TFRecord%20(parse%20libsvm%20data%20to%20TFRecord)%20%C2%B7%20%E5%90%B4%E8%A3%95%E9%9B%84python%E7%A5%9E%E7%BB%8F%E7%BD%91%E7%BB%9C%E2%80%94%E2%80%94TensorFlowTFRecord%E6%A0%B7%E4%BE%8B%E7%A8%8B%E5%BA%8F%20%C2%B7%20%E5%B0%86%E6%95%B0%E6%8D%AE%E8%BD%AC%E4%B8%BAtfrecord%E6%A0%BC%E5%BC%8F%20%C2%B7%20TensorFlow%E7%AC%94%E8%AE%B0-%E5%9B%BE%E7%89%87%E8%AF%BB%E5%8F%96%20%C2%B7%20TFRecord%20%E7%9A%84%E4%BD%BF%E7%94%A8%20%C2%BB%20%E6%9B%B4%E5%A4%9A%E6%8E%A8%E8%8D%90...%20Java%E7%BB%8F%E5%85%B8%E9%9D%A2%E8%AF%95%E9%A2%98%E6%95%B4%E7%90%86%E5%8F%8A%E7%AD%94%E6%A1%88%E8%AF%A6%E8%A7%A3%EF%BC%88%E4%BA%8C%EF%BC%89%20%E6%9C%80%E6%96%B0%20IT%20%E6%96%B0%E9%97%BB:%20%C2%B7%20%E7%94%B1%E4%BA%8E%E6%8B%85%E5%BF%83%E6%96%B0%E5%86%A0%E7%97%85%E6%AF%92%20%E7%89%B9%E6%96%AF%E6%8B%89%E6%92%A4%E5%9B%9E%E5%9C%A8%E6%9F%8F%E6%9E%97%E8%B6%85%E7%BA%A7%E5%B7%A5%E5%8E%82%E7%9A%84%E6%89%80%E6%9C%89%E7%BE%8E%E5%9B%BD%E5%91%98%E5%B7%A5%20%C2%B7%20%E7%BA%A2%E9%AD%945G%E4%BD%93%E9%AA%8C%EF%BC%8C%E6%B8%B8%E6%88%8F%E6%89%8B%E6%9C%BA%E8%B7%91%E6%AD%A5%E8%BF%9B%E5%85%A5%20144Hz%20%E6%97%B6%E4%BB%A3%20%C2%B7%20%E5%86%8D%E4%B8%8D%E5%BC%80%E5%AD%A6%E5%AE%B6%E9%95%BF%E5%B0%B1%E7%96%AF%E4%BA%86%20%E5%90%90%E6%A7%BD%E4%B8%8A%E7%BD%91%E8%AF%BE%E7%9A%84%E9%82%A3%E4%BA%9B%E4%BA%8B%20%C2%B7%20%E5%BE%AE%E8%BD%AF%E5%85%AC%E5%B8%83%20Windows%20%E4%B8%80%E4%B8%AA%E5%B0%9A%E6%97%A0%E8%A1%A5%E4%B8%81%E7%9A%84%E8%A0%95%E8%99%AB%E7%BA%A7%E6%BC%8F%E6%B4%9E%20%C2%B7%20%E6%9A%B4%E8%B7%8C30%%20BTC%E6%AF%94%E7%89%B9%E5%B8%81%E4%BB%B7%E6%A0%BC%E5%A4%A7%E8%B7%B3%E6%B0%B4%20%E8%A2%AB%E5%98%B2%E4%B8%8D%E5%A6%82%E5%8D%AB%E7%94%9F%E7%BA%B8%E4%BF%9D%E5%80%BC%20%C2%BB%20%E6%9B%B4%E5%A4%9A%E6%96%B0%E9%97%BB...%20%E5%85%AC%E5%91%8A%20%E6%98%B5%E7%A7%B0%EF%BC%9A%20%E6%88%98%E4%BA%89%E7%83%AD%E8%AF%9A%20%E5%9B%AD%E9%BE%84%EF%BC%9A%202%E5%B9%B46%E4%B8%AA%E6%9C%88%20%E7%B2%89%E4%B8%9D%EF%BC%9A%20816%20%E5%85%B3%E6%B3%A8%EF%BC%9A%2029%20+%E5%8A%A0%E5%85%B3%E6%B3%A8%20%3C2020%E5%B9%B43%E6%9C%88%3E%20%E6%97%A5%E4%B8%80%E4%BA%8C%E4%B8%89%E5%9B%9B%E4%BA%94%E5%85%AD%201234567%20891011121314%2015161718192021%2022232425262728%202930311234%20567891011%20%E6%88%91%E7%9A%84%E6%A0%87%E7%AD%BE%20%E6%9C%80%E8%BF%91%E7%9A%84%E5%AD%A6%E4%B9%A0%E7%AC%94%E8%AE%B0(49)%20Django%20%E5%AD%A6%E4%B9%A0%E7%AC%94%E8%AE%B0(43)%20%E5%89%8D%E7%AB%AF%E5%BC%80%E5%8F%91%E5%9F%BA%E7%A1%80%E7%9F%A5%E8%AF%86(40)%20%E6%B7%B1%E5%BA%A6%E5%AD%A6%E4%B9%A0%E5%B8%B8%E7%94%A8%E7%AE%97%E6%B3%95%E5%8F%8A%E7%AC%94%E8%AE%B0(30)%20%E6%9C%BA%E5%99%A8%E5%AD%A6%E4%B9%A0%E5%B8%B8%E7%94%A8%E7%AE%97%E6%B3%95%E5%8F%8A%E7%AC%94%E8%AE%B0(30)%20python%20%E7%AE%97%E6%B3%95%E4%B8%8E%E9%9D%A2%E8%AF%95%E7%AC%94%E8%AF%95%E9%A2%98(25)%20%E5%9B%BE%E5%83%8F%E5%A4%84%E7%90%86(23)%20python%20%E9%A1%B9%E7%9B%AE%E5%8F%8A%E8%A7%84%E8%8C%83%E8%A6%81%E6%B1%82(22)%20%E6%95%B0%E6%8D%AE%E5%BA%93%E5%9F%BA%E7%A1%80%E7%9F%A5%E8%AF%86%E5%8F%8A%E5%85%B6%E7%AC%94%E8%AF%95%E9%A2%98(19)%20Linux%E5%9F%BA%E7%A1%80%E6%93%8D%E4%BD%9C%E7%9F%A5%E8%AF%86%E7%82%B9(15)%20%E6%9B%B4%E5%A4%9A%20%E9%9A%8F%E7%AC%94%E6%A1%A3%E6%A1%88%202020%E5%B9%B41%E6%9C%88(2)%202019%E5%B9%B412%E6%9C%88(5)%202019%E5%B9%B411%E6%9C%88(3)%202019%E5%B9%B410%E6%9C%88(4)%202019%E5%B9%B49%E6%9C%88(3)%202019%E5%B9%B48%E6%9C%88(7)%202019%E5%B9%B47%E6%9C%88(5)%202019%E5%B9%B46%E6%9C%88(8)%202019%E5%B9%B45%E6%9C%88(7)%202019%E5%B9%B44%E6%9C%88(8)%202019%E5%B9%B43%E6%9C%88(5)%202019%E5%B9%B42%E6%9C%88(6)%202019%E5%B9%B41%E6%9C%88(6)%202018%E5%B9%B412%E6%9C%88(5)%202018%E5%B9%B411%E6%9C%88(4)%202018%E5%B9%B410%E6%9C%88(8)%202018%E5%B9%B49%E6%9C%88(6)%202018%E5%B9%B48%E6%9C%88(9)%202018%E5%B9%B47%E6%9C%88(1)%202018%E5%B9%B46%E6%9C%88(5)%202018%E5%B9%B45%E6%9C%88(12)%202018%E5%B9%B44%E6%9C%88(11)%202018%E5%B9%B43%E6%9C%88(12)%202018%E5%B9%B42%E6%9C%88(8)%202018%E5%B9%B41%E6%9C%88(8)%202017%E5%B9%B412%E6%9C%88(10)%202017%E5%B9%B411%E6%9C%88(3)%202017%E5%B9%B49%E6%9C%88(7)%202017%E5%B9%B48%E6%9C%88(5)%20%E6%9C%80%E6%96%B0%E8%AF%84%E8%AE%BA%201.%20Re:%E5%AE%9E%E7%8E%B0text-detection-ctpn%E4%B8%80%E8%B7%AF%E7%9A%84%E5%9D%8E%E5%9D%8E%E5%9D%B7%E5%9D%B7%20%E5%85%B6%E5%AE%9E%EF%BC%8C%E5%A4%A7%E5%AE%B6%E6%9C%89%E9%97%AE%E9%A2%98%EF%BC%8C%E5%8F%AF%E4%BB%A5%E5%9C%A8%E8%AF%84%E8%AE%BA%E5%8C%BA%E8%AE%A8%E8%AE%BA%EF%BC%8C%E6%8F%90%E9%97%AE%E3%80%82%E6%88%91%E4%BC%9A%E7%9A%84%E4%B8%80%E5%AE%9A%E5%B8%AE%E5%8A%A9%EF%BC%8C%E8%A6%81%E6%98%AF%E9%83%BD%E6%89%A3%E6%89%A3%E9%97%AE%E7%9A%84%E8%AF%9D%EF%BC%8C%E5%85%B6%E4%BB%96%E4%BA%BA%E5%8F%AF%E8%83%BD%E4%BC%9A%EF%BC%8C%E4%BD%86%E6%98%AF%E5%8D%B4%E5%B8%AE%E4%B8%8D%E4%B8%8A%E5%BF%99%E3%80%82%20--%E6%88%98%E4%BA%89%E7%83%AD%E8%AF%9A%202.%20Re:%E5%AE%9E%E7%8E%B0text-detection-ctpn%E4%B8%80%E8%B7%AF%E7%9A%84%E5%9D%8E%E5%9D%8E%E5%9D%B7%E5%9D%B7%20@ThanatosL%20OK%EF%BC%8C%E5%B7%B2%E5%8A%A0...%20--%E6%88%98%E4%BA%89%E7%83%AD%E8%AF%9A%203.%20Re:%E6%88%98%E4%BA%89%E7%83%AD%E8%AF%9A%E7%9A%84python%E5%85%A8%E6%A0%88%E5%BC%80%E5%8F%91%E4%B9%8B%E8%B7%AF%20@%E5%B0%8F%E7%8E%8B%E5%B0%8F%E7%8E%8B%EF%BC%8C%E8%83%BD%E5%86%99%E4%B8%A4%E8%A1%8C%20%E5%8A%A0%E6%B2%B9...%20--%E6%88%98%E4%BA%89%E7%83%AD%E8%AF%9A%204.%20Re:%E6%B7%B1%E5%85%A5%E5%AD%A6%E4%B9%A0python%E8%A7%A3%E6%9E%90%E5%B9%B6%E8%AF%BB%E5%8F%96PDF%E6%96%87%E4%BB%B6%E5%86%85%E5%AE%B9%E7%9A%84%E6%96%B9%E6%B3%95%20@%E6%9F%AF%E8%A5%BF%E6%94%B6%E6%95%9B%20%E5%8F%AF%E4%BB%A5%E5%95%8A%EF%BC%8C%E4%BD%A0%E8%87%AA%E5%B7%B1%E6%A3%80%E6%9F%A5%E4%B8%80%E4%B8%8B...%20--%E6%88%98%E4%BA%89%E7%83%AD%E8%AF%9A%205.%20Re:%E6%88%98%E4%BA%89%E7%83%AD%E8%AF%9A%E7%9A%84python%E5%85%A8%E6%A0%88%E5%BC%80%E5%8F%91%E4%B9%8B%E8%B7%AF%202020%E5%B9%B43%E6%9C%8811%E6%97%A5%EF%BC%8C%E6%88%91%E5%BC%80%E5%A7%8B%E6%8E%A5%E8%A7%A6python%E7%9A%84%E7%AC%AC%E4%B8%80%E4%B8%AA%E6%9C%88%E3%80%82%E6%88%91%E4%B9%9F%E6%98%AF%E5%A4%A7%E4%B8%89%E4%B8%8B%E5%AD%A6%E6%9C%9F%EF%BC%8C%E7%96%AB%E6%83%85%E7%9A%84%E7%88%86%E5%8F%91%E8%AE%A9%E6%88%91%E5%9C%A8%E5%AE%B6%E6%95%B0%E6%9C%88%E4%B9%8B%E4%B9%85%EF%BC%8C%E7%A9%BA%E4%BD%99%E6%97%B6%E9%97%B4%E4%B9%9F%E8%AE%A9%E6%88%91%E6%80%9D%E8%80%83%EF%BC%8C%E8%87%AA%E5%B7%B1%E5%B0%86%E6%9D%A5%E8%BF%9B%E5%85%A5%E7%9A%84%E7%A4%BE%E4%BC%9A%E6%9C%89%E4%BB%80%E4%B9%88%E7%9A%84%E4%B8%80%E6%8A%80%E4%B9%8B%E9%95%BF%EF%BC%8C%E5%8F%AF%E6%83%9C%E5%8F%91%E7%8E%B0%EF%BC%8C%E9%99%A4%E4%BA%86%E5%9C%A8%E6%A0%A1%E7%9A%84%E6%88%90%E7%BB%A9%E7%9C%8B%E5%BE%97%E8%BF%87%E5%8E%BB%EF%BC%8C%E7%A1%AC%E5%AE%9E%E5%8A%9B%E7%9C%9F...%20--%E5%B0%8F%E7%8E%8B%E5%B0%8F%E7%8E%8B%EF%BC%8C%E8%83%BD%E5%86%99%E4%B8%A4%E8%A1%8C%20%E9%98%85%E8%AF%BB%E6%8E%92%E8%A1%8C%E6%A6%9C%201.%20Git%E5%AE%89%E8%A3%85%E6%95%99%E7%A8%8B%EF%BC%88windows%EF%BC%89(207881)%202.%20python%20%E7%94%9F%E6%88%90%E5%99%A8%E5%92%8C%E8%BF%AD%E4%BB%A3%E5%99%A8%E6%9C%89%E8%BF%99%E7%AF%87%E5%B0%B1%E5%A4%9F%E4%BA%86(85612)%203.%20%E6%B7%B1%E5%BA%A6%E5%AD%A6%E4%B9%A0%E4%B9%8BPyTorch%E5%AE%9E%E6%88%98%EF%BC%881%EF%BC%89%E2%80%94%E2%80%94%E5%9F%BA%E7%A1%80%E5%AD%A6%E4%B9%A0%E5%8F%8A%E6%90%AD%E5%BB%BA%E7%8E%AF%E5%A2%83(46215)%204.%20%E6%B7%B1%E5%85%A5%E5%AD%A6%E4%B9%A0%E5%8D%B7%E7%A7%AF%E7%A5%9E%E7%BB%8F%E7%BD%91%E7%BB%9C%EF%BC%88CNN%EF%BC%89%E7%9A%84%E5%8E%9F%E7%90%86%E7%9F%A5%E8%AF%86(45611)%205.%20%E6%B7%B1%E5%85%A5%E5%AD%A6%E4%B9%A0python%E8%A7%A3%E6%9E%90%E5%B9%B6%E8%AF%BB%E5%8F%96PDF%E6%96%87%E4%BB%B6%E5%86%85%E5%AE%B9%E7%9A%84%E6%96%B9%E6%B3%95(44000)%206.%20Python%E6%9C%BA%E5%99%A8%E5%AD%A6%E4%B9%A0%E7%AC%94%E8%AE%B0%EF%BC%9Asklearn%E5%BA%93%E7%9A%84%E5%AD%A6%E4%B9%A0(38469)%207.%20%E6%B7%B1%E5%85%A5%E5%AD%A6%E4%B9%A0%E5%8D%B7%E7%A7%AF%E7%A5%9E%E7%BB%8F%E7%BD%91%E7%BB%9C%E4%B8%AD%E5%8D%B7%E7%A7%AF%E5%B1%82%E5%92%8C%E6%B1%A0%E5%8C%96%E5%B1%82%E7%9A%84%E6%84%8F%E4%B9%89(33781)%208.%20%E6%B5%85%E8%B0%88%E4%BD%BF%E7%94%A8git%E8%BF%9B%E8%A1%8C%E7%89%88%E6%9C%AC%E6%8E%A7%E5%88%B6(32167)%209.%20%E5%A6%82%E4%BD%95%E4%B8%BA%E5%BC%80%E5%8F%91%E9%A1%B9%E7%9B%AE%E7%BC%96%E5%86%99%E8%A7%84%E8%8C%83%E7%9A%84README%E6%96%87%E4%BB%B6%EF%BC%88windows%EF%BC%89%EF%BC%8C%E6%AD%A4%E6%96%87%E8%AF%A6%E8%A7%A3(27340)%2010.%20HBuilder%E7%9A%84%E5%AE%89%E8%A3%85%E5%8F%8A%E7%94%A8%E6%B3%95(23971)%20%E8%AF%84%E8%AE%BA%E6%8E%92%E8%A1%8C%E6%A6%9C%201.%20python%20%E7%94%9F%E6%88%90%E5%99%A8%E5%92%8C%E8%BF%AD%E4%BB%A3%E5%99%A8%E6%9C%89%E8%BF%99%E7%AF%87%E5%B0%B1%E5%A4%9F%E4%BA%86(44)%202.%20%E6%88%98%E4%BA%89%E7%83%AD%E8%AF%9A%E7%9A%84python%E5%85%A8%E6%A0%88%E5%BC%80%E5%8F%91%E4%B9%8B%E8%B7%AF(43)%203.%20%E5%AE%9E%E7%8E%B0text-detection-ctpn%E4%B8%80%E8%B7%AF%E7%9A%84%E5%9D%8E%E5%9D%8E%E5%9D%B7%E5%9D%B7(14)%204.%20%E6%B7%B1%E5%85%A5%E5%AD%A6%E4%B9%A0%E4%BD%BF%E7%94%A8ocr%E7%AE%97%E6%B3%95%E8%AF%86%E5%88%AB%E5%9B%BE%E7%89%87%E4%B8%AD%E6%96%87%E5%AD%97%E7%9A%84%E6%96%B9%E6%B3%95(12)%205.%20%E6%B7%B1%E5%85%A5%E5%AD%A6%E4%B9%A0%E5%8D%B7%E7%A7%AF%E7%A5%9E%E7%BB%8F%E7%BD%91%E7%BB%9C%E4%B8%AD%E5%8D%B7%E7%A7%AF%E5%B1%82%E5%92%8C%E6%B1%A0%E5%8C%96%E5%B1%82%E7%9A%84%E6%84%8F%E4%B9%89(10)%20%E6%8E%A8%E8%8D%90%E6%8E%92%E8%A1%8C%E6%A6%9C%201.%20python%20%E7%94%9F%E6%88%90%E5%99%A8%E5%92%8C%E8%BF%AD%E4%BB%A3%E5%99%A8%E6%9C%89%E8%BF%99%E7%AF%87%E5%B0%B1%E5%A4%9F%E4%BA%86(38)%202.%20%E6%88%98%E4%BA%89%E7%83%AD%E8%AF%9A%E7%9A%84python%E5%85%A8%E6%A0%88%E5%BC%80%E5%8F%91%E4%B9%8B%E8%B7%AF(18)%203.%20%E5%A6%82%E4%BD%95%E4%B8%BA%E5%BC%80%E5%8F%91%E9%A1%B9%E7%9B%AE%E7%BC%96%E5%86%99%E8%A7%84%E8%8C%83%E7%9A%84README%E6%96%87%E4%BB%B6%EF%BC%88windows%EF%BC%89%EF%BC%8C%E6%AD%A4%E6%96%87%E8%AF%A6%E8%A7%A3(15)%204.%20%E6%B7%B1%E5%85%A5%E5%AD%A6%E4%B9%A0%E5%8D%B7%E7%A7%AF%E7%A5%9E%E7%BB%8F%E7%BD%91%E7%BB%9C%E4%B8%AD%E5%8D%B7%E7%A7%AF%E5%B1%82%E5%92%8C%E6%B1%A0%E5%8C%96%E5%B1%82%E7%9A%84%E6%84%8F%E4%B9%89(12)%205.%20Git%E5%AE%89%E8%A3%85%E6%95%99%E7%A8%8B%EF%BC%88windows%EF%BC%89(11)%206.%20Python%E6%9C%BA%E5%99%A8%E5%AD%A6%E4%B9%A0%E7%AC%94%E8%AE%B0%EF%BC%9Asklearn%E5%BA%93%E7%9A%84%E5%AD%A6%E4%B9%A0(10)%207.%20%E8%AE%B0%E5%BD%95%E8%87%AA%E5%B7%B1%E4%BD%BF%E7%94%A8GitHub%E7%9A%84%E7%82%B9%E7%82%B9%E6%BB%B4%E6%BB%B4(9)%208.%20%E6%B7%B1%E5%85%A5%E5%AD%A6%E4%B9%A0%E5%8D%B7%E7%A7%AF%E7%A5%9E%E7%BB%8F%E7%BD%91%E7%BB%9C%EF%BC%88CNN%EF%BC%89%E7%9A%84%E5%8E%9F%E7%90%86%E7%9F%A5%E8%AF%86(9)%209.%20%E7%BD%91%E7%BB%9C%E5%9F%BA%E7%A1%80%E7%9F%A5%E8%AF%86-%E7%BD%91%E7%BB%9C%E5%8D%8F%E8%AE%AE(9)%2010.%20%E6%B5%85%E8%B0%88%E4%BD%BF%E7%94%A8git%E8%BF%9B%E8%A1%8C%E7%89%88%E6%9C%AC%E6%8E%A7%E5%88%B6(7)
# def parse_tfrecords(example):
#     features = {
#         "feature": tf.FixedLenFeature([], tf.string),
#         "label": tf.FixedLenFeature([], tf.int64)
#     }
#     parsed_features = tf.parse_single_example(example, features)
#     feature = tf.decode_raw(parsed_features['feature'], tf.float64)
#     feature = tf.reshape(tf.cast(feature, tf.float32), [1, 121])
#
#     channel_id = tf.cast(tf.slice(feature, [0, 0], [1, 1]), tf.int32)
#     article_vector = tf.reduce_sum(tf.slice(feature, [0, 1], [1, 100]), axis=1)
#     user_weights = tf.reduce_sum(tf.slice(feature, [0, 101], [1, 10]), axis=1)
#     article_weights = tf.reduce_sum(tf.slice(feature, [0, 111], [1, 10]), axis=1)
#
#     label = tf.cast(parsed_features['label'], tf.float32)
#
#     # 构造字典 名称-tensor
#     tensor_list = [channel_id, article_vector, user_weights, article_weights]
#     feature_dict = dict(zip(FEATURE_COLUMNS, tensor_list))
#
#     return feature_dict, label
