#!/usr/bin/env python
# -*- coding: utf-8 -*-
# @Project      : MeUtils.
# @File         : __init__.py
# @Time         : 2020/11/20 2:47 下午
# @Author       : yuanjie
# @Email        : yuanjie@xiaomi.com
# @Software     : PyCharm
# @Description  : 


from meutils.pipe import *
from meutils.np_utils import normalize

os.environ['TF_KERAS'] = '1'

from bert4keras.backend import keras
from bert4keras.models import build_transformer_model
from bert4keras.tokenizers import Tokenizer

from bert4keras.snippets import sequence_padding


class Bert(object):

    def __init__(self, bert_top_dir='/fds/data/bert/chinese_simbert_L-12_H-768_A-12'):
        self.bert_top_dir = Path(bert_top_dir)
        self.get_bert_path()

        self.tokenizer = Tokenizer(str(self.dict_path), do_lower_case=True)

    def get_bert_path(self):
        self.config_path = self.bert_top_dir / 'bert_config.json'
        self.checkpoint_path = self.bert_top_dir / 'bert_model.ckpt'
        self.dict_path = self.bert_top_dir / 'vocab.txt'

    def bert_model(self):
        # 建立加载模型
        bert = build_transformer_model(
            str(self.config_path),
            str(self.checkpoint_path),
            with_pool='linear',
            application='unilm',
            return_keras_model=False  # True: bert.predict([np.array([token_ids]), np.array([segment_ids])])
        )
        return bert

    @property
    def simbert_encoder(self):
        bert = self.bert_model()
        encoder = keras.models.Model(bert.model.inputs, bert.model.outputs[0])
        return encoder

    def texts2vec(self, texts, batch_size=1000, maxlen=64, is_lite=1):
        tokenizer = self.tokenizer
        simbert_encoder = self.simbert_encoder

        X = []
        S = []
        for text in texts:
            token_ids, segment_ids = tokenizer.encode(text, maxlen=maxlen)
            X.append(token_ids)
            S.append(segment_ids)

        data = [sequence_padding(X, length=maxlen), sequence_padding(S, length=maxlen)]

        del text, X, S
        gc.collect()

        vecs = simbert_encoder.predict(data, batch_size=batch_size)

        if is_lite:
            vecs = vecs[:, range(0, 768, 4)]

        return normalize(vecs)


if __name__ == '__main__':
    bert = Bert()
    bert.texts2vec(['第一条文本', '第二条文本'])
