# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['metprint']

package_data = \
{'': ['*']}

setup_kwargs = {
    'name': 'metprint',
    'version': '2021',
    'description': 'Pretty print text in a range of builtin formats or make your own',
    'long_description': '[![GitHub top language](https://img.shields.io/github/languages/top/FHPythonUtils/MetPrint.svg?style=for-the-badge)](../../)\n[![Repository size](https://img.shields.io/github/repo-size/FHPythonUtils/MetPrint.svg?style=for-the-badge)](../../)\n[![Issues](https://img.shields.io/github/issues/FHPythonUtils/MetPrint.svg?style=for-the-badge)](../../issues)\n[![License](https://img.shields.io/github/license/FHPythonUtils/MetPrint.svg?style=for-the-badge)](/LICENSE.md)\n[![Commit activity](https://img.shields.io/github/commit-activity/m/FHPythonUtils/MetPrint.svg?style=for-the-badge)](../../commits/master)\n[![Last commit](https://img.shields.io/github/last-commit/FHPythonUtils/MetPrint.svg?style=for-the-badge)](../../commits/master)\n[![PyPI Downloads](https://img.shields.io/pypi/dm/MetPrint.svg?style=for-the-badge)](https://pypistats.org/packages/metprint)\n[![PyPI Total Downloads](https://img.shields.io/badge/dynamic/json?style=for-the-badge&label=total%20downloads&query=%24.total_downloads&url=https%3A%2F%2Fapi.pepy.tech%2Fapi%2Fprojects%2Fmetprint)](https://pepy.tech/project/metprint)\n[![PyPI Version](https://img.shields.io/pypi/v/metprint.svg?style=for-the-badge)](https://pypi.org/project/metprint)\n\n<!-- omit in TOC -->\n# MetPrint\n\n<img src="readme-assets/icons/name.png" alt="Project Icon" width="750">\n\nPretty print text in a range of builtin formats or make your own\n\nExample usage in your project\n```python\nfrom metprint import (\n\tLogType,\n\tLogger,\n\tMeterpreterFormatter,\n)\n\nmetLogger = Logger(MeterpreterFormatter())\nmetLogger.logPrint("none", LogType.NONE)\nmetLogger.logPrint("bold indent", LogType.BOLD, True)\nmetLogger.logPrint("italic indent", LogType.ITALIC, True)\nmetLogger.logPrint("header", LogType.HEADER)\nmetLogger.logPrint("debug", LogType.DEBUG)\nmetLogger.logPrint("info", LogType.INFO)\nmetLogger.logPrint("success", LogType.SUCCESS)\nmetLogger.logPrint("warning", LogType.WARNING)\nmetLogger.logPrint("error", LogType.ERROR)\nmetLogger.logPrint("critical", LogType.CRITICAL)\n```\n\nOutput of test.py\n<div>\n<img src="readme-assets/screenshots/desktop/screenshot-0.svg" alt="Screenshot 1" width="500">\n</div>\n\nAlternatively, you may prefer to make use of the `LAZY_PRINT` function.\nSet `builtins.METPRINT_LAZY_FORMATTER` to customize the formatter.\n\nAlso, you have the option to show dependencies some love with\n`builtins.METPRINT_DONATIONS` add a dictionary of projects and the\ndonations/ funding URL. Note that this is outputted on import.\n\nSee below for example usage of these.\n```python\n#!/usr/bin/env python3\n"""Test metprint LAZY_PRINT and donations\n"""\nimport builtins\n\n# Show some love to \'Test\'\nbuiltins.METPRINT_DONATIONS = {"Test": "Test URL"}\n# Set this if you want to set the LAZY_PRINT formatter\nbuiltins.METPRINT_LAZY_FORMATTER = "FHFormatter"\n\nfrom metprint import LAZY_PRINT, LogType\n\nprint("#########################")\nprint("#      FHFormatter      #")\nprint("#########################")\n# You will still need LogType for this\nLAZY_PRINT("none", LogType.NONE)\nLAZY_PRINT("bold", LogType.BOLD)\nLAZY_PRINT("italic", LogType.ITALIC)\nLAZY_PRINT("header", LogType.HEADER)\nLAZY_PRINT("debug", LogType.DEBUG)\nLAZY_PRINT("info", LogType.INFO)\nLAZY_PRINT("success", LogType.SUCCESS)\nLAZY_PRINT("warning", LogType.WARNING)\nLAZY_PRINT("error", LogType.ERROR)\nLAZY_PRINT("critical", LogType.CRITICAL)\n\n# Test that the donations message is not triggered again\n#pylint: disable=unused-import\nimport metprint\n```\n\nOutput of lazytest.py (for simplicity this is the output copied from the\nterminal so note that the actual output contains colours as above)\n```none\n1 project is looking for funding:\n\nTest: Test URL\n\n#########################\n#      FHFormatter      #\n#########################\nnone\nbold\nitalic\nheader\n[$  Deb] debug\n[* Info] info\n[+   Ok] success\n[/ Warn] warning\n[-  Err] error\n[! Crit] critical\n```\n\n- [Documentation](#documentation)\n- [Install With PIP](#install-with-pip)\n- [Language information](#language-information)\n\t- [Built for](#built-for)\n- [Install Python on Windows](#install-python-on-windows)\n\t- [Chocolatey](#chocolatey)\n\t- [Download](#download)\n- [Install Python on Linux](#install-python-on-linux)\n\t- [Apt](#apt)\n- [How to run](#how-to-run)\n\t- [With VSCode](#with-vscode)\n\t- [From the Terminal](#from-the-terminal)\n- [Download Project](#download-project)\n\t- [Clone](#clone)\n\t\t- [Using The Command Line](#using-the-command-line)\n\t\t- [Using GitHub Desktop](#using-github-desktop)\n\t- [Download Zip File](#download-zip-file)\n- [Community Files](#community-files)\n\t- [Licence](#licence)\n\t- [Changelog](#changelog)\n\t- [Code of Conduct](#code-of-conduct)\n\t- [Contributing](#contributing)\n\t- [Security](#security)\n\t- [Support](#support)\n\t- [Rationale](#rationale)\n\n## Documentation\nSee the [Docs](/DOCS/) for more information.\n\n## Install With PIP\n```python\npip install metprint\n```\n\nHead to https://pypi.org/project/metprint/ for more info\n\n## Language information\n\n### Built for\n\nThis program has been written for Python versions 3.7 - 3.10 and has been tested with both 3.7 and\n3.10\n\n## Install Python on Windows\n\n### Chocolatey\n\n```powershell\nchoco install python\n```\n\n### Windows - Python.org\n\nTo install Python, go to https://www.python.org/downloads/windows/ and download the latest\nversion.\n\n## Install Python on Linux\n\n### Apt\n\n```bash\nsudo apt install python3.x\n```\n\n### Dnf\n\n```bash\nsudo dnf install python3.x\n```\n\n## Install Python on MacOS\n\n### Homebrew\n\n```bash\nbrew install python@3.x\n```\n\n### MacOS - Python.org\n\nTo install Python, go to https://www.python.org/downloads/macos/ and download the latest\nversion.\n\n## How to run\n\n### Windows\n\n- Module\n\t`py -3.x -m [module]` or `[module]` (if module installs a script)\n\n- File\n\t`py -3.x [file]` or `./[file]`\n\n### Linux/ MacOS\n\n- Module\n\t`python3.x -m [module]` or `[module]` (if module installs a script)\n\n- File\n\t`python3.x [file]` or `./[file]`\n\n## Download Project\n### Clone\n#### Using The Command Line\n1. Press the Clone or download button in the top right\n2. Copy the URL (link)\n3. Open the command line and change directory to where you wish to\nclone to\n4. Type \'git clone\' followed by URL in step 2\n```bash\ngit clone https://github.com/FHPythonUtils/MetPrint\n```\n\nMore information can be found at\nhttps://help.github.com/en/articles/cloning-a-repository\n\n#### Using GitHub Desktop\n1. Press the Clone or download button in the top right\n2. Click open in desktop\n3. Choose the path for where you want and click Clone\n\nMore information can be found at\nhttps://help.github.com/en/desktop/contributing-to-projects/cloning-a-repository-from-github-to-github-desktop\n\n### Download Zip File\n\n1. Download this GitHub repository\n2. Extract the zip archive\n3. Copy/ move to the desired location\n\n## Community Files\n### Licence\nMIT License\nCopyright (c) FredHappyface\n(See the [LICENSE](/LICENSE.md) for more information.)\n\n### Changelog\nSee the [Changelog](/CHANGELOG.md) for more information.\n\n### Code of Conduct\nOnline communities include people from many backgrounds. The *Project*\ncontributors are committed to providing a friendly, safe and welcoming\nenvironment for all. Please see the\n[Code of Conduct](https://github.com/FHPythonUtils/.github/blob/master/CODE_OF_CONDUCT.md)\n for more information.\n\n### Contributing\nContributions are welcome, please see the\n[Contributing Guidelines](https://github.com/FHPythonUtils/.github/blob/master/CONTRIBUTING.md)\nfor more information.\n\n### Security\nThank you for improving the security of the project, please see the\n[Security Policy](https://github.com/FHPythonUtils/.github/blob/master/SECURITY.md)\nfor more information.\n\n### Support\nThank you for using this project, I hope it is of use to you. Please be aware that\nthose involved with the project often do so for fun along with other commitments\n(such as work, family, etc). Please see the\n[Support Policy](https://github.com/FHPythonUtils/.github/blob/master/SUPPORT.md)\nfor more information.\n\n### Rationale\nThe rationale acts as a guide to various processes regarding projects such as\nthe versioning scheme and the programming styles used. Please see the\n[Rationale](https://github.com/FHPythonUtils/.github/blob/master/RATIONALE.md)\nfor more information.\n',
    'author': 'FredHappyface',
    'author_email': None,
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/FHPythonUtils/MetPrint',
    'packages': packages,
    'package_data': package_data,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
