## 功能描述

**自动生成数学作业，并保存为PDF。**

### 加减法

`series = 'Add'`

| 等级 | 名称               | 公式                          | 说明                  |
| ---- | ------------------ |-----------------------------| --------------------- |
| 1    | 加法               | a+b=                        | 20以内，非负          |
| 2    | 减法               | a-b=                        | 20以内，非负          |
| 3    | 加法、减法         | a+b= 或 a-b=                 | 20以内，非负          |
| 4    | 连加               | a+b+c=                      | 30以内，非负          |
| 5    | 连减               | a-b-c=                      | 30以内，非负          |
| 6    | 连加、连减         | a+b+c= 或 a-b-c=             | 30以内，非负          |
| 7    | 连加减             | a+b-c= 或 a-b+c=             | 30以内，非负          |
| 8    | 负数相加           | -a-b=                       | 30以内                |
| 9    | 加法、减法         | a-b= 或 -a+b=                | 30以内                |
| 10   | 加法、减法         | -a-b= 或 -a+b= 或 a-b=        | 30以内                |
| 11   | 连减法             | a-b-c= 或 -a-b-c=            | 30以内                |
| 12   | 连加减             | a+b-c= 或 a-b+c=             | 30以内                |
| 13   | 连加减             | -a+b-c= 或 -a-b+c=           | 30以内                |
| 14   | 负负得正           | a+(-b)= 或 a-(-b)=           | 40以内                |
| 15   | 负负得正           | -a+(-b)= 或 -a-(-b)=         | 40以内                |
| 16   | 符号混合           | a+b+c=                      | 40以内,abc可以带负号  |
| 17   | 加法填空           | a+?=b                       | 40以内                |
| 18   | 减法填空           | a-?=b                       | 40以内                |
| 19   | 加法填空、减法填空 | a+?=b 或 a-?=b               | 40以内                |
| 20   | 加后填空           | a+b+?=c 或 a+b-?=c           | 40以内                |
| 21   | 加法填空、减法填空 | -a+?=b 或 -a-?=b             | 40以内                |
| 22   | 加减法填空         | a-b+?=c 或 a-b-?=c           | 40以内                |
| 23   | 加减法填空         | -a-b+?=c 或 -a-b-?=c         | 40以内                |
| 24   | 加减法填空         | -a+b+?=c 或 -a+b-?=c         | 40以内                |
| 25   | 加减法填空         | -a+b+?=-c 或 -a-b+?=-c       | 40以内                |
| 26   | 中间填空           | a+?+b=c 或 a-?-b=c           | 40以内                |
| 27   | 中间填空           | -a+?+b=-c 或 -a-?-b=c        | 40以内                |
| 28   | 填空混合           | a+b+?=c 或 ?+a+b=c 或 a+?+b=c | 40以内，abc可以带负号 |

### 乘除法

`series = 'Mult'`

| 等级 | 名称          | 公式                                | 说明        |
| ---- | ------------- | ---------------------------------- |-----------|
| 1    | 乘法基础      | a×b=                               | ab是1位数，非负 |
| 2    | 乘法基础      | a×b=                               | ab是1位数    |
| 3    | 乘法填空      | a×?=c 或 ?×b =c                     | ab是1位数，非负 |
| 4    | 乘法填空      | a×?=c 或 ?×b =c                     | ab是1位数    |
| 5    | 除法基础      | c÷a=                               | a是1位数，非负  |
| 6    | 除法基础      | c÷a=                               | a是1位数     |
| 7    | 除法填空      | c÷?=b 或 ?÷a=b                      | ab是1位数，非负 |
| 8    | 除法填空-正负 | c÷?=b 或 ?÷a=b                      | ab是1位数       |
| 9    | 四则运算      | a×b+c×d= 或 a×b-c×d=                | abcd是1位数  |
| 10   | 四则填空      | a×?+c×d=e 或 a×b-?×d=e              | abcd是1位数  |
| 11   | 四则运算      | a×b+c÷d= 或 a×b-c÷d=                | abd是1位数   |
| 12   | 四则填空      | a×?+c÷d=e 或 a×b+c÷?=e 或 a×b-?÷d=e | abd是1位数   |
| 13   | 四则运算      | (a+b)×c= 或 a×(b+c)=                | abc是1位数   |
| 14   | 四则填空      | (a+?)×c=d 或 (a+b)×?=d              | abc是1位数   |
| 15   | 四则运算      | (a+b)×(c+d)=                       | abcd是1位数  |
| 16   | 四则填空      | (a+?)×(c+d)=e 或 (a+b)×(?+d)=e      | abcd是1位数  |
| 17   | 连乘          | a×b×c=                             | abc是1位数   |
| 18   | 连乘填空      | ?×b×c=d 或 a×?×c=d 或 a×b×?=d       | abc是1位数   |
| 19   | 乘法          | a×b=                               | ab是两位数    |
| 20   | 乘法填空      | a×?=c 或 ?×b=c                      | ab是两位数    |
| 21   | 除法          | a÷b=                               | b是两位数     |
| 22   | 除法填空      | a÷?=c 或 ?÷b=c                      | bc是两位数    |

## 使用方法

```python
from mathw import MathWork

if __name__ == '__main__':
    # 生成作业并保存成PDF
    MathWork(
        series='Add', # Add - 加减法；Mult - 乘除法
        level=4,  # 等级
        pageNum=40  # 页数
    ).go()
```